/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.java.enricher.DynamicMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.metadata.extension.model.attribute.AbstractOutputAttributes;
import org.mule.test.metadata.extension.model.shapes.Shape;
import org.mule.test.metadata.extension.resolver.TestInputResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataInputCarResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataInputHouseResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataInputPersonResolver;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class DynamicMetadataDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String CONTENT_METADATA_WITH_KEY_ID = "sdkContentMetadataWithKeyId";
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = ExtensionDeclarationTestUtils.declarerFor(MetadataExtension.class, MuleManifest.getProductVersion());
        new DynamicMetadataDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, ((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void parseMetadataAnnotationsOnParameter() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getDeclaration(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations(), CONTENT_METADATA_WITH_KEY_ID);
        List parameters = operationDeclaration.getAllParameters();
        this.assertParameterIsMetadataKeyPart((ParameterDeclaration)EnricherTestUtils.getDeclaration(parameters, "type"));
        this.assertParameterIsMetadataContent((ParameterDeclaration)EnricherTestUtils.getDeclaration(parameters, "content"));
    }

    @Test
    public void declareStaticAndDynamicTypesInOperation() {
        List operations = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations();
        MetadataType outputMetadataType = IntrospectionUtils.getReturnType((Type)new TypeWrapper(Object.class, ExtensionsTestUtils.TYPE_LOADER));
        MetadataType objectParameterMetadataType = new ParameterTypeWrapper(Object.class, ExtensionsTestUtils.TYPE_LOADER).asMetadataType();
        OperationDeclaration dynamicContent = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, CONTENT_METADATA_WITH_KEY_ID);
        this.assertOutputType(dynamicContent.getOutput(), outputMetadataType, true);
        this.assertOutputType(dynamicContent.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        List params = dynamicContent.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "content"), objectParameterMetadataType);
        OperationDeclaration dynamicOutput = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputMetadataWithKeyId");
        this.assertOutputType(dynamicOutput.getOutput(), outputMetadataType, true);
        this.assertOutputType(dynamicOutput.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        params = dynamicOutput.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "content"), objectParameterMetadataType);
        OperationDeclaration dynamicContentAndOutput = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "contentAndOutputMetadataWithKeyId");
        this.assertOutputType(dynamicContentAndOutput.getOutput(), outputMetadataType, true);
        this.assertOutputType(dynamicContentAndOutput.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        params = dynamicContentAndOutput.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "content"), objectParameterMetadataType);
        operations = this.declaration.getOperations();
        OperationDeclaration dynamicOutputAndAttributes = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "sdkOutputAttributesWithDynamicMetadata");
        this.assertOutputType(dynamicOutputAndAttributes.getOutput(), ExtensionsTestUtils.toMetadataType(Object.class), true);
        this.assertOutputType(dynamicOutputAndAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(AbstractOutputAttributes.class), true);
        params = dynamicOutputAndAttributes.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        OperationDeclaration staticOutputOnly = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "typeWithDeclaredSubtypesMetadata");
        this.assertOutputType(staticOutputOnly.getOutput(), ExtensionsTestUtils.toMetadataType(Boolean.TYPE), false);
        this.assertOutputType(staticOutputOnly.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        OperationDeclaration staticOutputAndAttributes = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputAttributesWithDeclaredSubtypesMetadata");
        this.assertOutputType(staticOutputAndAttributes.getOutput(), ExtensionsTestUtils.toMetadataType(Shape.class), false);
        this.assertOutputType(staticOutputAndAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(AbstractOutputAttributes.class), false);
    }

    @Test
    public void declareStaticAndDynamicTypesInSource() {
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDynamicAttributes = (SourceDeclaration)EnricherTestUtils.getDeclaration(messageSources, "MetadataSource");
        this.assertOutputType(sourceDynamicAttributes.getOutput(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Object.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(Object.class)).build(), true);
        this.assertOutputType(sourceDynamicAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(StringAttributes.class), false);
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(sourceDynamicAttributes.getAllParameters(), "type"), ExtensionsTestUtils.toMetadataType(String.class));
        messageSources = this.declaration.getMessageSources();
        SourceDeclaration sourceStaticAttributes = (SourceDeclaration)EnricherTestUtils.getDeclaration(messageSources, "MetadataSourceWithMultilevel");
        this.assertOutputType(sourceStaticAttributes.getOutput(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Object.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(Object.class)).build(), true);
        this.assertOutputType(sourceStaticAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(StringAttributes.class), false);
        List locationKey = sourceStaticAttributes.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(locationKey, "continent"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(locationKey, "country"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(locationKey, "city"), ExtensionsTestUtils.toMetadataType(String.class));
    }

    @Test
    public void declareDynamicInputTypesInSource() {
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDeclaration = (SourceDeclaration)EnricherTestUtils.getDeclaration(messageSources, "MetadataSourceWithCallbackParameters");
        SourceCallbackDeclaration successSourceCallback = (SourceCallbackDeclaration)sourceDeclaration.getSuccessCallback().get();
        this.assertParamResolverInfo((BaseDeclaration)successSourceCallback, "response", Optional.of(TestMetadataInputPersonResolver.TEST_INPUT_PERSON_RESOLVER));
        this.assertParamResolverInfo((BaseDeclaration)successSourceCallback, "successObject", Optional.of(TestMetadataInputCarResolver.TEST_INPUT_CAR_RESOLVER));
        SourceCallbackDeclaration errorSourceCallback = (SourceCallbackDeclaration)sourceDeclaration.getErrorCallback().get();
        this.assertParamResolverInfo((BaseDeclaration)errorSourceCallback, "response", Optional.of(TestMetadataInputHouseResolver.TEST_INPUT_HOUSE_RESOLVER));
        this.assertParamResolverInfo((BaseDeclaration)errorSourceCallback, "errorObject", Optional.of(TestInputResolver.INPUT_RESOLVER_NAME));
    }

    @Test
    public void declaresTypeResolverInformationForDynamicResolver() throws Exception {
        List operations = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations();
        OperationDeclaration dynamicContent = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, CONTENT_METADATA_WITH_KEY_ID);
        this.assertCategoryInfo((BaseDeclaration)dynamicContent, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)dynamicContent, Optional.of("TestOutputAnyTypeResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)dynamicContent, Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)dynamicContent, "type", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)dynamicContent, "content", Optional.of("TestInputResolverWithKeyResolver"));
        OperationDeclaration dynamicOutput = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputMetadataWithKeyId");
        this.assertCategoryInfo((BaseDeclaration)dynamicOutput, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)dynamicOutput, Optional.of("TestOutputResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)dynamicOutput, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)dynamicOutput, Optional.of("TestOutputResolverWithKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)dynamicOutput, "type", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)dynamicOutput, "content", Optional.empty());
        OperationDeclaration outputAndmultipleInput = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputAndMultipleInputWithKeyId");
        this.assertCategoryInfo((BaseDeclaration)outputAndmultipleInput, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)outputAndmultipleInput, Optional.of("TestInputAndOutputResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)outputAndmultipleInput, Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)outputAndmultipleInput, "type", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)outputAndmultipleInput, "firstPerson", Optional.of("TestInputAndOutputResolverWithKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)outputAndmultipleInput, "otherPerson", Optional.of("TestInputAndOutputResolverWithKeyResolver"));
        OperationDeclaration simpleMultiLevelKeyResolver = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "simpleMultiLevelKeyResolver");
        this.assertCategoryInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, Optional.empty());
        this.assertAttributesResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, Optional.of("TestMultiLevelKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "content", Optional.of("TestMultiLevelKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "continent", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "country", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "city", Optional.empty());
        OperationDeclaration withoutKeysWithKeyId = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "contentMetadataWithoutKeysWithKeyId");
        this.assertCategoryInfo((BaseDeclaration)withoutKeysWithKeyId, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)withoutKeysWithKeyId, Optional.empty());
        this.assertAttributesResolverInfo((BaseDeclaration)withoutKeysWithKeyId, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)withoutKeysWithKeyId, Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)withoutKeysWithKeyId, "content", Optional.of("TestInputResolverWithoutKeyResolver"));
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDynamicAttributes = (SourceDeclaration)EnricherTestUtils.getDeclaration(messageSources, "MetadataSource");
        this.assertCategoryInfo((BaseDeclaration)sourceDynamicAttributes, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.of("TestInputAndOutputWithAttributesResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.of("TestInputOutputSourceResolverWithKeyResolver"));
    }

    @Test
    public void typeResolverInformationSkippedForStaticResolver() throws Exception {
        OperationDeclaration operation = (OperationDeclaration)EnricherTestUtils.getDeclaration(this.declaration.getOperations(), "outputAttributesWithDeclaredSubtypesMetadata");
        Optional info = operation.getModelProperty(TypeResolversInformationModelProperty.class);
        MatcherAssert.assertThat((String)"Static resolvers information should not be declared in the model", (Object)info.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void outputTypeResolverInformationSetForDsql() throws Exception {
        OperationDeclaration query = (OperationDeclaration)EnricherTestUtils.getDeclaration(this.declaration.getOperations(), "doQuery");
        Optional info = query.getModelProperty(TypeResolversInformationModelProperty.class);
        MatcherAssert.assertThat((Object)info.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypeResolversInformationModelProperty)info.get()).getCategoryName(), (Matcher)CoreMatchers.is((Object)"QueryResolverCategory"));
        MatcherAssert.assertThat((Object)((ResolverInformation)((TypeResolversInformationModelProperty)info.get()).getOutputResolver().get()).getResolverName(), (Matcher)CoreMatchers.is((Object)"QUERY_OUTPUT_RESOLVER-ENTITY-NativeQueryResolver"));
    }

    private void assertParameterIsMetadataKeyPart(ParameterDeclaration param) {
        EnricherTestUtils.checkIsPresent((BaseDeclaration)param, MetadataKeyPartModelProperty.class);
    }

    private void assertParameterIsMetadataContent(ParameterDeclaration param) {
        MatcherAssert.assertThat((Object)param.getRole(), (Matcher)CoreMatchers.is((Object)ParameterRole.CONTENT));
    }

    private void assertParameterType(ParameterDeclaration param, MetadataType type) {
        MatcherAssert.assertThat((Object)param.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
    }

    private void assertOutputType(OutputDeclaration output, MetadataType type, boolean isDynamic) {
        MatcherAssert.assertThat((Object)output.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        MatcherAssert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)isDynamic));
    }

    private void assertParamResolverInfo(BaseDeclaration declaration, String param, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getParameterResolver(param), "ParameterResolver", expectedName);
    }

    private void assertOutputResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getOutputResolver(), "OutputResolver", expectedName);
    }

    private void assertAttributesResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getAttributesResolver(), "AttributesResolver", expectedName);
    }

    private void assertKeysResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getKeysResolver(), "KeysResolver", expectedName);
    }

    private void assertCategoryInfo(BaseDeclaration declaration, String expectedName) {
        TypeResolversInformationModelProperty info = this.getResolversInfo(declaration);
        MatcherAssert.assertThat((String)"Name miss match for the resolvers category: ", (Object)info.getCategoryName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedName)));
    }

    private TypeResolversInformationModelProperty getResolversInfo(BaseDeclaration declaration) {
        Optional info = declaration.getModelProperty(TypeResolversInformationModelProperty.class);
        if (!info.isPresent()) {
            Assert.fail((String)("Expected to have information of TypeResolvers but found no model property of class: " + TypeResolversInformationModelProperty.class.getName()));
        }
        return (TypeResolversInformationModelProperty)info.get();
    }

    private void assertResolverInfo(BaseDeclaration declaration, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> resolverSupplier, String kind, Optional<String> expectedName) {
        TypeResolversInformationModelProperty info = this.getResolversInfo(declaration);
        Optional<ResolverInformation> resolverName = resolverSupplier.apply(info);
        if (expectedName.isPresent() && !resolverName.isPresent()) {
            Assert.fail((String)String.format("Expected %s name to be '%s' but it was not declared in the model. Information was: %s", kind, expectedName, info.toString()));
        } else if (!expectedName.isPresent() && resolverName.isPresent()) {
            Assert.fail((String)String.format("Expected %s name to be empty, but a declaration was found in the model. Information was: %s", kind, info.toString()));
        }
        MatcherAssert.assertThat((String)("Name miss match for the " + kind), resolverName.map(ResolverInformation::getResolverName), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expectedName)));
    }
}

