/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOutputDeclaration;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.enricher.JavaMimeTypeParametersDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class JavaMimeTypeParametersDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final BaseTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    private static SinceMuleVersionModelProperty SINCE_MULE_VERSION_MODEL_PROPERTY = new SinceMuleVersionModelProperty("4.2.0");
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationDeclaration operation;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SourceDeclaration source;
    private JavaMimeTypeParametersDeclarationEnricher enricher = new JavaMimeTypeParametersDeclarationEnricher();
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Collections.singletonList(this.operation));
        Mockito.when((Object)this.extensionDeclaration.getMessageSources()).thenReturn(Collections.singletonList(this.source));
        Mockito.when((Object)this.source.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.source.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.source.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operation.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operation.getParameterGroup("General")).thenReturn((Object)new ParameterGroupDeclaration("General"));
        Mockito.when((Object)this.source.getParameterGroup("General")).thenReturn((Object)new ParameterGroupDeclaration("General"));
        this.mockMediaType((BaseDeclaration)this.operation, false);
        this.mockMediaType((BaseDeclaration)this.source, false);
    }

    private void mockMediaType(BaseDeclaration declaration, boolean strict) {
        Mockito.when((Object)declaration.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.of(new MediaTypeModelProperty("text/plain", strict)));
    }

    @Test
    public void binaryTypeOperation() {
        this.mockOutput((WithOutputDeclaration)this.operation, (MetadataType)builder.binaryType().build());
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void binaryTypeOperationWithStrictMimeType() {
        this.mockOutput((WithOutputDeclaration)this.operation, (MetadataType)builder.binaryType().build());
        this.mockMediaType((BaseDeclaration)this.operation, true);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void objectTypeOperation() {
        this.mockOutput((WithOutputDeclaration)this.operation, (MetadataType)builder.objectType().build());
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat(this.getGroupParameters((ComponentDeclaration)this.operation), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void enumTypeOperation() {
        DefaultStringType type = builder.stringType().with((TypeAnnotation)new EnumAnnotation((Object[])new String[]{"val"})).build();
        this.mockOutput((WithOutputDeclaration)this.operation, (MetadataType)type);
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat(this.getGroupParameters((ComponentDeclaration)this.operation), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void stringOperation() {
        this.mockOutput((WithOutputDeclaration)this.operation, (MetadataType)builder.stringType().build());
        this.enricher.enrich(this.extensionLoadingContext);
        List<ParameterDeclaration> params = this.getGroupParameters((ComponentDeclaration)this.operation);
        Assert.assertThat(params, (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(params.get(0), "outputMimeType");
    }

    @Test
    public void stringOperationWithStrictMimeType() {
        this.mockOutput((WithOutputDeclaration)this.operation, (MetadataType)builder.stringType().build());
        this.mockMediaType((BaseDeclaration)this.operation, true);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void stringTypeSource() {
        this.mockOutput((WithOutputDeclaration)this.source, (MetadataType)builder.stringType().build());
        this.enricher.enrich(this.extensionLoadingContext);
        List<ParameterDeclaration> params = this.getGroupParameters((ComponentDeclaration)this.source);
        Assert.assertThat(params, (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(params.get(0), "outputMimeType");
    }

    @Test
    public void stringTypeSourceWithStrictMimeType() {
        this.mockOutput((WithOutputDeclaration)this.source, (MetadataType)builder.stringType().build());
        this.mockMediaType((BaseDeclaration)this.source, true);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoMimeTypeParams((ParameterizedDeclaration<?>)this.source);
    }

    @Test
    public void inputStreamTypeSource() {
        this.mockOutput((WithOutputDeclaration)this.source, (MetadataType)builder.binaryType().build());
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertMimeTypeParams((ParameterizedDeclaration<?>)this.source);
    }

    @Test
    public void inputStreamTypeSourceWithStrictMimeType() {
        this.mockOutput((WithOutputDeclaration)this.source, (MetadataType)builder.binaryType().build());
        this.mockMediaType((BaseDeclaration)this.source, true);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoMimeTypeParams((ParameterizedDeclaration<?>)this.source);
    }

    @Test
    public void objectTypeSource() {
        this.mockOutput((WithOutputDeclaration)this.source, (MetadataType)builder.objectType().build());
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat(this.getGroupParameters((ComponentDeclaration)this.source), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void listResultString() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("listResultString");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertStringMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void listResultStream() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("listResultStream");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void listResultApple() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("listResultApple");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void pagedResultString() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultString");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertStringMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void pagedResultCursorProvider() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultCursorProvider");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void pagedResultApple() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultApple");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoMimeTypeParams((ParameterizedDeclaration<?>)this.operation);
    }

    @Test
    public void listResultStringSource() throws Exception {
        this.mockExtensionTypeDescriptorModelProperty(TestListResultStringSource.class);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertStringMimeTypeParams((ParameterizedDeclaration<?>)this.source);
    }

    @Test
    public void objectMethodHasModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("objectMethod");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, true);
    }

    @Test
    public void listResultStringHasModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("listResultString");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, true);
    }

    @Test
    public void pagedResultStringHasModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultString");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, true);
    }

    @Test
    public void listResultStreamHasModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("listResultStream");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, true);
    }

    @Test
    public void pagedResultCursorProviderHasModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultCursorProvider");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, true);
    }

    @Test
    public void listResultStringSourceHasModelProperty() throws Exception {
        this.mockExtensionTypeDescriptorModelProperty(TestListResultStringSource.class);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.source, true);
    }

    @Test
    public void resultStringDoesNotHaveModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultApple");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, false);
    }

    @Test
    public void inputStreamMethodDoesNotHaveModelProperty() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("pagedResultApple");
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.operation, false);
    }

    @Test
    public void resultStringSourceDoesNotHaveModelProperty() throws Exception {
        this.mockExtensionTypeDescriptorModelProperty(TestStringSource.class);
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertParametersSinceMuleVersionModelProperty((ParameterizedDeclaration<?>)this.source, false);
    }

    private void assertNoMimeTypeParams(ParameterizedDeclaration<?> withParams) {
        List parameters = withParams.getParameterGroup("General").getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)0));
    }

    private void assertStringMimeTypeParams(ParameterizedDeclaration<?> withParams) {
        List parameters = withParams.getParameterGroup("General").getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)1));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "outputMimeType");
    }

    private void assertMimeTypeParams(ParameterizedDeclaration<?> withParams) {
        List parameters = withParams.getParameterGroup("General").getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "outputMimeType");
        this.assertParameter((ParameterDeclaration)parameters.get(1), "outputEncoding");
    }

    private void assertParametersSinceMuleVersionModelProperty(ParameterizedDeclaration<?> withParams, boolean shouldAddSinceMuleVersionModelProperty) {
        List parameters = withParams.getParameterGroup("General").getParameters();
        parameters.stream().forEach(parameter -> {
            Assert.assertThat((Object)parameter.getModelProperty(SinceMuleVersionModelProperty.class).isPresent(), (Matcher)CoreMatchers.is((Object)shouldAddSinceMuleVersionModelProperty));
            if (shouldAddSinceMuleVersionModelProperty) {
                Assert.assertThat((Object)((SinceMuleVersionModelProperty)parameter.getModelProperty(SinceMuleVersionModelProperty.class).get()).getVersion(), (Matcher)CoreMatchers.is((Object)SINCE_MULE_VERSION_MODEL_PROPERTY.getVersion()));
            }
        });
    }

    private void assertParameter(ParameterDeclaration parameter, String name) {
        Assert.assertThat((Object)parameter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)name));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)ExtensionsTestUtils.toMetadataType(String.class)));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parameter.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void mockOutput(WithOutputDeclaration declaration, MetadataType type) {
        OutputDeclaration output = (OutputDeclaration)Mockito.mock(OutputDeclaration.class);
        Mockito.when((Object)output.getType()).thenReturn((Object)type);
        Mockito.when((Object)declaration.getOutput()).thenReturn((Object)output);
    }

    private void mockExtensionTypeDescriptorModelProperty(Class sourceClass) {
        SourceTypeWrapper sourceElement = new SourceTypeWrapper(sourceClass, this.typeLoader);
        Mockito.when((Object)this.source.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(new ExtensionTypeDescriptorModelProperty((Type)sourceElement)));
    }

    private void mockExtensionOperationDescriptorModelProperty(String operationMethodName) throws NoSuchMethodException {
        Method operationMethod = TestMethods.class.getMethod(operationMethodName, new Class[0]);
        OperationWrapper operationElement = new OperationWrapper(operationMethod, this.typeLoader);
        Mockito.when((Object)this.operation.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(Optional.of(new ExtensionOperationDescriptorModelProperty((OperationElement)operationElement)));
    }

    private List<ParameterDeclaration> getGroupParameters(ComponentDeclaration declaration) {
        return declaration.getParameterGroup("General").getParameters();
    }

    public class TestNoGenericsSource
    extends Source {
        public void onStart(SourceCallback sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public class TestListResultStringSource
    extends Source<List<Result<String, Object>>, Object> {
        public void onStart(SourceCallback<List<Result<String, Object>>, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public class TestAppleSource
    extends Source<Apple, Object> {
        public void onStart(SourceCallback<Apple, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public class TestStringSource
    extends Source<String, Object> {
        public void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public static enum TestEnum {
        ENUM1,
        ENUM2;

    }

    public class TestMethods {
        public void voidMethod() {
        }

        public Result<String, Object> resultString() {
            return null;
        }

        public Result<Apple, Object> resultApple() {
            return null;
        }

        public Object objectMethod() {
            return null;
        }

        public ByteArrayInputStream inputStreamMethod() {
            return null;
        }

        public Apple appleMethod() {
            return null;
        }

        public TestEnum enumMethod() {
            return TestEnum.ENUM1;
        }

        public List<Result<String, Object>> listResultString() {
            return null;
        }

        public List<Result<ByteArrayInputStream, Object>> listResultStream() {
            return null;
        }

        public List<Result<Apple, Object>> listResultApple() {
            return null;
        }

        public PagingProvider<Object, Result<String, Object>> pagedResultString() {
            return null;
        }

        public PagingProvider<Object, Result<CursorStreamProvider, Object>> pagedResultCursorProvider() {
            return null;
        }

        public PagingProvider<Object, Result<Apple, Object>> pagedResultApple() {
            return null;
        }
    }
}

