/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.CraftedExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CraftedExtensionModelLoaderTestCase
extends AbstractMuleTestCase {
    private static final String EXTENSION_NAME = "crafted extension";
    private ExtensionModelLoader loader = new CraftedExtensionModelLoader();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private DslResolvingContext dslResolvingContext;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    @Before
    public void before() throws Exception {
        this.attributes.put("type", TestExtensionLoadingDelegate.class.getName());
        this.attributes.put("COMPILATION_MODE", true);
    }

    @Test
    public void load() throws Exception {
        ExtensionModel extensionModel = this.loader.loadExtensionModel(this.classLoader, this.dslResolvingContext, this.attributes);
        Assert.assertThat((Object)extensionModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)extensionModel.getName(), (Matcher)CoreMatchers.is((Object)EXTENSION_NAME));
    }

    @Test
    public void typeNotPresent() throws Exception {
        this.attributes.clear();
        this.expectedException.expect(IllegalArgumentException.class);
        this.load();
    }

    @Test
    public void typeIsBlank() throws Exception {
        this.attributes.put("type", "");
        this.expectedException.expect(IllegalArgumentException.class);
        this.load();
    }

    @Test
    public void typeIsNotInstantiable() throws Exception {
        this.attributes.put("type", ExtensionLoadingDelegate.class.getName());
        this.expectedException.expect(IllegalArgumentException.class);
        this.load();
    }

    @Test
    public void typeIsOfWrongType() throws Exception {
        this.attributes.put("type", String.class.getName());
        this.expectedException.expect(IllegalArgumentException.class);
        this.load();
    }

    public static class TestExtensionLoadingDelegate
    implements ExtensionLoadingDelegate {
        public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext context) {
            extensionDeclarer.named(CraftedExtensionModelLoaderTestCase.EXTENSION_NAME).describedAs("Crafted Extension").onVersion("1.0.0").withCategory(Category.COMMUNITY).fromVendor("Mulesoft");
        }
    }
}

