/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.PrivilegedExport;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.vegan.extension.VeganCookBook;

public class JavaExtensionModelParserTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void getImportedTypesFromExtensionUsingTheSdkApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleExtensionUsingSdkApi.class, typeLoader);
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionTypeWrapper, (ExtensionLoadingContext)ctx);
        List importedTypes = javaExtensionModelParser.getImportedTypes();
        MatcherAssert.assertThat((Object)importedTypes.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(0)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
    }

    @Test
    public void getImportedTypesFromExtensionUsingTheLegacyApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleExtensionUsingLegacyApi.class, typeLoader);
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionTypeWrapper, (ExtensionLoadingContext)ctx);
        List importedTypes = javaExtensionModelParser.getImportedTypes();
        MatcherAssert.assertThat((Object)importedTypes.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(0)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
    }

    @Test
    public void getImportedTypesFromExtensionUsingBothTheLegacyAndTheSdkApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleMixedApiExtension.class, typeLoader);
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionTypeWrapper, (ExtensionLoadingContext)ctx);
        List importedTypes = javaExtensionModelParser.getImportedTypes();
        MatcherAssert.assertThat((Object)importedTypes.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(1)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(0)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.vegan.extension.VeganCookBook"));
    }

    @Test
    @Ignore
    public void getExportedTypesFromExtensionUsingTheSdkApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleExtensionUsingSdkApi.class, typeLoader);
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionTypeWrapper, (ExtensionLoadingContext)ctx);
        List exportedTypes = javaExtensionModelParser.getPrivilegedExportedPackages();
        MatcherAssert.assertThat((Object)exportedTypes.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Extension(name="SimpleExtension")
    @org.mule.sdk.api.annotation.Import(type=KnockeableDoor.class)
    @Import(type=VeganCookBook.class)
    private static class SimpleMixedApiExtension {
        private SimpleMixedApiExtension() {
        }
    }

    @Extension(name="SimpleExtension")
    @Import(type=KnockeableDoor.class)
    @org.mule.runtime.extension.api.annotation.PrivilegedExport(packages={"org.mule.runtime.module.extension.internal.loader.parser.java"})
    private static class SimpleExtensionUsingLegacyApi {
        private SimpleExtensionUsingLegacyApi() {
        }
    }

    @Extension(name="SimpleExtension")
    @org.mule.sdk.api.annotation.Import(type=KnockeableDoor.class)
    @PrivilegedExport(packages={"org.mule.runtime.module.extension.internal.loader.parser.java"})
    private static class SimpleExtensionUsingSdkApi {
        private SimpleExtensionUsingSdkApi() {
        }
    }
}

