/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.sdk.api.runtime.operation.ExecutionType;
import org.mule.tck.size.SmallTest;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@SmallTest
@RunWith(value=PowerMockRunner.class)
public class JavaExtensionModelParserUtilsTestCase {
    private OperationElement operationElement = (OperationElement)Mockito.mock(OperationElement.class);
    private ClassBasedAnnotationValueFetcher classBasedAnnotationValueFetcher = (ClassBasedAnnotationValueFetcher)Mockito.mock(ClassBasedAnnotationValueFetcher.class);

    @Test
    public void operationExecutionTypeFromLegacyAnnotation() {
        this.mockOperationExecutionTypeFromAnnotation(Execution.class, (Enum)org.mule.runtime.api.meta.model.operation.ExecutionType.CPU_LITE);
        Optional executionType = JavaExtensionModelParserUtils.getExecutionType((OperationElement)this.operationElement);
        Assert.assertThat((Object)executionType.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(executionType.get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.model.operation.ExecutionType.CPU_LITE));
    }

    @Test
    public void operationExecutionTypeFromSdkApiAnnotation() {
        this.mockOperationExecutionTypeFromAnnotation(org.mule.sdk.api.annotation.execution.Execution.class, (Enum)ExecutionType.CPU_LITE);
        Optional executionType = JavaExtensionModelParserUtils.getExecutionType((OperationElement)this.operationElement);
        Assert.assertThat((Object)executionType.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(executionType.get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.model.operation.ExecutionType.CPU_LITE));
    }

    @Test
    @PrepareForTest(value={ExecutionType.class})
    public void operationExecutionTypeFromSdkApiAnnotationWithUndefinedExecutionType() {
        ExecutionType UNKNOWN_EXECUTION_TYPE = (ExecutionType)Mockito.mock(ExecutionType.class);
        Whitebox.setInternalState((Object)UNKNOWN_EXECUTION_TYPE, (String)"name", (Object)"UNKNOWN");
        this.mockOperationExecutionTypeFromAnnotation(org.mule.sdk.api.annotation.execution.Execution.class, (Enum)UNKNOWN_EXECUTION_TYPE);
        Optional executionType = JavaExtensionModelParserUtils.getExecutionType((OperationElement)this.operationElement);
        Assert.assertThat((Object)executionType.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void mockOperationExecutionTypeFromAnnotation(Class executionAnnotationClass, Enum executionType) {
        Mockito.when((Object)this.classBasedAnnotationValueFetcher.getEnumValue((Function)ArgumentMatchers.any())).thenReturn((Object)executionType);
        Mockito.when((Object)this.operationElement.getValueFromAnnotation(executionAnnotationClass)).thenReturn(Optional.of(this.classBasedAnnotationValueFetcher));
    }
}

