/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.sdk.api.runtime.parameter.HttpParameterPlacement;

public class JavaParameterModelParserTestCase {
    private static final String ALIAS = "alias";
    private static final org.mule.runtime.extension.api.runtime.parameter.HttpParameterPlacement PARAMETER_PLACEMENT = org.mule.runtime.extension.api.runtime.parameter.HttpParameterPlacement.HEADERS;

    @Test
    public void nonOAuthParameter() throws Exception {
        Optional<OAuthParameterModelProperty> oAuthParameterModelProperty = this.getOAuthParameterModelPropertyFromParameterName("parameter");
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void oAuthParameter() throws Exception {
        Optional<OAuthParameterModelProperty> oAuthParameterModelProperty = this.getOAuthParameterModelPropertyFromParameterName("outhParameter");
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.get().getPlacement(), (Matcher)Is.is((Object)PARAMETER_PLACEMENT));
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.get().getRequestAlias(), (Matcher)Is.is((Object)ALIAS));
    }

    @Test
    public void sdkOAuthParameter() throws Exception {
        Optional<OAuthParameterModelProperty> oAuthParameterModelProperty = this.getOAuthParameterModelPropertyFromParameterName("sdkOuthParameter");
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.get().getPlacement(), (Matcher)Is.is((Object)PARAMETER_PLACEMENT));
        MatcherAssert.assertThat((Object)oAuthParameterModelProperty.get().getRequestAlias(), (Matcher)Is.is((Object)ALIAS));
    }

    private Optional<OAuthParameterModelProperty> getOAuthParameterModelPropertyFromParameterName(String parameterName) throws Exception {
        FieldWrapper extensionParameter = new FieldWrapper(TestConnectionProvider.class.getField(parameterName), new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        JavaParameterModelParser javaParameterModelParser = new JavaParameterModelParser((ExtensionParameter)extensionParameter, Optional.empty(), ParameterDeclarationContext.forConnectionProvider((String)"TestConnectionProvider"));
        return javaParameterModelParser.getOAuthParameterModelProperty();
    }

    private static class TestConnectionProvider
    implements ConnectionProvider<Object> {
        @Parameter
        public String parameter;
        @OAuthParameter(requestAlias="alias", placement=org.mule.runtime.extension.api.runtime.parameter.HttpParameterPlacement.HEADERS)
        public String outhParameter;
        @org.mule.sdk.api.annotation.connectivity.oauth.OAuthParameter(requestAlias="alias", placement=HttpParameterPlacement.HEADERS)
        public String sdkOuthParameter;

        private TestConnectionProvider() {
        }

        public Object connect() throws ConnectionException {
            return null;
        }

        public void disconnect(Object connection) {
        }

        public ConnectionValidationResult validate(Object connection) {
            return null;
        }
    }
}

