/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.property.SourceClusterSupportModelProperty;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaSourceModelParser;
import org.mule.sdk.api.annotation.source.BackPressure;
import org.mule.sdk.api.annotation.source.EmitsResponse;
import org.mule.sdk.api.runtime.source.BackPressureMode;

public class JavaSourceModelParserTestCase {
    private JavaSourceModelParser parser;
    private SourceElement sourceElement;

    @Test
    public void defaultClusterSupport() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(TestSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void noClusterSupport() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(NonClusteredSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.NOT_SUPPORTED));
    }

    @Test
    public void clusterSupportDefaultingAllNodes() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(AllNodesSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void clusterSupportDefaultingPrimaryNodeOnly() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(PrimaryNodeSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY));
    }

    @Test
    public void sdkNoClusterSupport() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(SdkNonClusteredSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.NOT_SUPPORTED));
    }

    @Test
    public void sdkClusterSupportDefaultingAllNodes() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(SdkAllNodesSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void sdkClusterSupportDefaultingPrimaryNodeOnly() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(SdkPrimaryNodeSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY));
    }

    @Test
    public void noBackPressureStrategy() {
        Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(TestSource.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void backPressureSourceWithDefaults() {
        Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(BackPressureSourceWithDefaults.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.extension.api.runtime.source.BackPressureMode.WAIT));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new org.mule.runtime.extension.api.runtime.source.BackPressureMode[]{org.mule.runtime.extension.api.runtime.source.BackPressureMode.WAIT}));
    }

    @Test
    public void sdkBackPressureSourceWithDefaults() {
        Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(SdkBackPressureSourceWithDefaults.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.extension.api.runtime.source.BackPressureMode.WAIT));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new org.mule.runtime.extension.api.runtime.source.BackPressureMode[]{org.mule.runtime.extension.api.runtime.source.BackPressureMode.WAIT}));
    }

    @Test
    public void backPressureSourceWithSelectedValues() {
        Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(BackPressureSourceWithSelectedValues.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.extension.api.runtime.source.BackPressureMode.DROP));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new org.mule.runtime.extension.api.runtime.source.BackPressureMode[]{org.mule.runtime.extension.api.runtime.source.BackPressureMode.FAIL, org.mule.runtime.extension.api.runtime.source.BackPressureMode.DROP}));
    }

    @Test
    public void sdkBackPressureSourceWithSelectedValues() {
        Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(SdkBackPressureSourceWithSelectedValues.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.extension.api.runtime.source.BackPressureMode.DROP));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new org.mule.runtime.extension.api.runtime.source.BackPressureMode[]{org.mule.runtime.extension.api.runtime.source.BackPressureMode.FAIL, org.mule.runtime.extension.api.runtime.source.BackPressureMode.DROP}));
    }

    @Test
    public void sourceEmitsResponse() {
        Assert.assertThat((Object)this.parseEmitsResponseFromSourceClass(EmitsResponseSource.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sdkSourceEmitsResponse() {
        Assert.assertThat((Object)this.parseEmitsResponseFromSourceClass(SdkEmitsResponseSource.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sourceDoesNotEmitsResponse() {
        Assert.assertThat((Object)this.parseEmitsResponseFromSourceClass(TestSource.class), (Matcher)CoreMatchers.is((Object)false));
    }

    private boolean parseEmitsResponseFromSourceClass(Class<? extends Source> sourceClass) {
        this.mockSourceWrapperWithClass(sourceClass);
        return this.parser.emitsResponse();
    }

    private Optional<BackPressureStrategyModelProperty> parseBackPressureStrategyFromSourceClass(Class<? extends Source> sourceClass) {
        this.mockSourceWrapperWithClass(sourceClass);
        return this.parser.getBackPressureStrategyModelProperty();
    }

    private SourceClusterSupportModelProperty parseClusterSupportFromSourceClass(Class<? extends Source> sourceClass) {
        this.mockSourceWrapperWithClass(sourceClass);
        return this.parser.getSourceClusterSupportModelProperty();
    }

    private void mockSourceWrapperWithClass(Class<? extends Source> sourceClass) {
        this.sourceElement = new SourceTypeWrapper(sourceClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        this.parser = new JavaSourceModelParser((ExtensionElement)Mockito.mock(ExtensionElement.class), this.sourceElement, (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class));
    }

    @EmitsResponse
    public static class SdkEmitsResponseSource
    extends TestSource {
    }

    @org.mule.runtime.extension.api.annotation.source.EmitsResponse
    public static class EmitsResponseSource
    extends TestSource {
    }

    @BackPressure(defaultMode=BackPressureMode.DROP, supportedModes={BackPressureMode.FAIL, BackPressureMode.DROP})
    public static class SdkBackPressureSourceWithSelectedValues
    extends TestSource {
    }

    @org.mule.runtime.extension.api.annotation.source.BackPressure(defaultMode=org.mule.runtime.extension.api.runtime.source.BackPressureMode.DROP, supportedModes={org.mule.runtime.extension.api.runtime.source.BackPressureMode.FAIL, org.mule.runtime.extension.api.runtime.source.BackPressureMode.DROP})
    public static class BackPressureSourceWithSelectedValues
    extends TestSource {
    }

    @BackPressure
    public static class SdkBackPressureSourceWithDefaults
    extends TestSource {
    }

    @org.mule.runtime.extension.api.annotation.source.BackPressure
    public static class BackPressureSourceWithDefaults
    extends TestSource {
    }

    @org.mule.sdk.api.annotation.source.ClusterSupport(value=org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
    public static class SdkPrimaryNodeSource
    extends TestSource {
    }

    @org.mule.sdk.api.annotation.source.ClusterSupport(value=org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES)
    public static class SdkAllNodesSource
    extends TestSource {
    }

    @org.mule.sdk.api.annotation.source.ClusterSupport(value=org.mule.sdk.api.annotation.source.SourceClusterSupport.NOT_SUPPORTED)
    public static class SdkNonClusteredSource
    extends TestSource {
    }

    @ClusterSupport(value=SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
    public static class PrimaryNodeSource
    extends TestSource {
    }

    @ClusterSupport(value=SourceClusterSupport.DEFAULT_ALL_NODES)
    public static class AllNodesSource
    extends TestSource {
    }

    @ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
    public static class NonClusteredSource
    extends TestSource {
    }

    public static class TestSource
    extends Source<String, Object> {
        public void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

