/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaValueProviderModelValidator;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class JavaValueProviderModelValidatorTestCase {
    private final JavaTypeLoader loader = new JavaTypeLoader(this.getClass().getClassLoader());
    private final MetadataType STRING_TYPE = this.loader.load(String.class);
    private final MetadataType NUMBER_TYPE = this.loader.load(Integer.class);
    private final MetadataType OBJECT_TYPE = this.loader.load(InputStream.class);
    private final MetadataType STRING_TYPE_WITH_ANNOTATIONS = new DefaultStringType(MetadataFormat.JAVA, this.createStringAnnotations());
    private final MetadataType NUMBER_TYPE_WITH_ANNOTATIONS = new DefaultNumberType(MetadataFormat.JAVA, this.createNumberAnnotations());
    private final MetadataType OBJECT_TYPE_WITH_ANNOTATIONS = new DefaultObjectType(Collections.emptyList(), false, null, MetadataFormat.JSON, this.createObjectAnnotations());
    private final MetadataType ARRAY_TYPE_WITH_ANNOTATIONS = new DefaultArrayType(() -> this.STRING_TYPE, MetadataFormat.JAVA, this.createObjectAnnotations());
    private JavaValueProviderModelValidator valueProviderModelValidator;
    private ProblemsReporter problemsReporter;
    @Mock(lenient=true)
    ExtensionModel extensionModel;
    @Mock(lenient=true)
    OperationModel operationModel;
    @Mock(lenient=true)
    ParameterModel operationParameter;
    @Mock(lenient=true)
    ParameterModel anotherOperationParameter;
    @Mock(lenient=true)
    ParameterModel configrationParameter;
    @Mock(lenient=true)
    ConfigurationModel configurationModel;
    @Mock(lenient=true)
    ParameterGroupModel parameterGroupModel;
    @Mock(lenient=true)
    ParameterGroupModel configurationParameterGroupModel;
    private ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder operationParameterBuilder;
    private ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder configrationParameterBuilder;

    @Before
    public void setUp() {
        this.valueProviderModelValidator = new JavaValueProviderModelValidator();
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        this.operationParameterBuilder = ValueProviderFactoryModelProperty.builder(SomeValueProvider.class);
        this.configrationParameterBuilder = ValueProviderFactoryModelProperty.builder(SomeValueProvider.class);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.configrationParameter));
        Mockito.when((Object)this.configurationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.configurationParameterGroupModel));
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)"SomeConfig");
        Mockito.when((Object)this.configurationParameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.configrationParameter));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.operationParameter, this.anotherOperationParameter));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"superOperation");
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.operationParameter, this.anotherOperationParameter));
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        this.mockParameter(this.configrationParameter, this.configrationParameterBuilder);
        this.mockParameter(this.operationParameter, this.operationParameterBuilder);
        this.mockAnotherParameter(this.anotherOperationParameter, this.STRING_TYPE);
    }

    @Test
    public void valueProviderShouldBeInstantiable() {
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder = ValueProviderFactoryModelProperty.builder(NonInstantiableProvider.class);
        this.mockParameter(this.operationParameter, builder, "anotherId");
        this.validate();
        this.assertProblems("The Value Provider [NonInstantiableProvider] is not instantiable but it should");
    }

    @Test
    public void parameterShouldExist() {
        this.operationParameterBuilder.withInjectableParameter("someParam", this.STRING_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] declares to use a parameter 'someParam' which doesn't exist in the operation 'superOperation'");
    }

    @Test
    public void parameterShouldBeOfSametype() {
        this.operationParameterBuilder.withInjectableParameter("someName", this.NUMBER_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines a parameter 'someName' of type 'class java.lang.Integer' but in the operation 'superOperation' is of type 'class java.lang.String'");
    }

    @Test
    public void injectConnectionInConnectionLessComponent() throws NoSuchFieldException {
        this.operationParameterBuilder.withConnection(SomeValueProvider.class.getDeclaredField("connection"));
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines that requires a connection, but is used in the operation 'superOperation' which is connection less");
    }

    @Test
    public void configurationBasedValueProviderDoesntSupportConnectionInjection() throws NoSuchFieldException {
        this.configrationParameterBuilder.withConnection(SomeValueProvider.class.getDeclaredField("connection"));
        this.mockParameter(this.configrationParameter, this.configrationParameterBuilder);
        Mockito.when((Object)this.configurationModel.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.configrationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines that requires a connection which is not allowed for a Value Provider of a configuration's parameter [SomeConfig]");
    }

    @Test
    public void configurationBasedValueProviderDoesntSupportConfigurationInjection() throws NoSuchFieldException {
        this.configrationParameterBuilder.withConfig(SomeValueProvider.class.getDeclaredField("connection"));
        this.mockParameter(this.configrationParameter, this.configrationParameterBuilder);
        Mockito.when((Object)this.configurationModel.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.configrationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines that requires a configuration which is not allowed for a Value Provider of a configuration's parameter [SomeConfig]");
    }

    @Test
    public void parameterWithValueProviderShouldBeOfStringType() {
        Mockito.when((Object)this.operationParameter.getType()).thenReturn((Object)this.NUMBER_TYPE);
        this.validate();
        this.assertProblems("The parameter [someName] of the operation 'superOperation' is not of String type. Parameters that provides Values should be of String type.");
    }

    @Test
    public void parameterWithValueProviderHasRepeatedIdInCompileTime() {
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder = ValueProviderFactoryModelProperty.builder(SomeOtherValueProvider.class);
        this.mockParameter(this.operationParameter, builder);
        this.validate();
        this.assertProblems("The following ValueProvider implementations [org.mule.runtime.module.extension.internal.loader.validation.JavaValueProviderModelValidatorTestCase$SomeValueProvider, org.mule.runtime.module.extension.internal.loader.validation.JavaValueProviderModelValidatorTestCase$SomeOtherValueProvider] use the same id [valueProviderId]. ValueProvider ids must be unique.");
    }

    @Test
    public void boundParameterExists() {
        this.operationParameterBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "someName");
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void boundParameterShouldExist() {
        this.operationParameterBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "anotherName");
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] declares to use a parameter 'anotherName' which doesn't exist in the operation 'superOperation'");
    }

    @Test
    public void boundParameterFromExtractionExpressionExists() {
        this.operationParameterBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "someName.someTag.@attribute");
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void boundParameterFromExtractionExpressionShouldExist() {
        this.operationParameterBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "anotherName.nested.fields");
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] declares to use a parameter 'anotherName' which doesn't exist in the operation 'superOperation'");
    }

    @Test
    public void parameterWithValueProviderHasDifferentIdInCompileTime() {
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder = ValueProviderFactoryModelProperty.builder(SomeOtherValueProvider.class);
        this.mockParameter(this.operationParameter, builder, "anotherId");
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void parameterShouldNotBeAnnotatedWithBothOfValuesAndFieldValues() {
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder = ValueProviderFactoryModelProperty.builder(SomeValueProvider.class);
        this.mockParameter(this.operationParameter, builder);
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder otherBuilder = ValueProviderFactoryModelProperty.builder(SomeOtherValueProvider.class);
        Map<String, ValueProviderFactoryModelProperty> fieldsValueProviderFactories = Collections.singletonMap("simple.path", otherBuilder.build());
        FieldsValueProviderFactoryModelProperty fieldsValueProviderFactoryModelProperty = new FieldsValueProviderFactoryModelProperty(fieldsValueProviderFactories);
        Mockito.when((Object)this.operationParameter.getModelProperty(FieldsValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(fieldsValueProviderFactoryModelProperty));
        this.validate();
        this.assertProblems("Parameter [someName] from operation with name superOperation has both a Value Provider and a Field Value Provider");
    }

    @Test
    public void parameterWithFieldValueProviderDoNotHaveToBeStringType() {
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.empty());
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder valueProviderFactoryModelPropertyBuilder = ValueProviderFactoryModelProperty.builder(SomeValueProvider.class);
        Map<String, ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder> valueProviderFactoryModelPropertyBuilders = Collections.singletonMap("simple.path", valueProviderFactoryModelPropertyBuilder);
        this.mockParameter(this.operationParameter, valueProviderFactoryModelPropertyBuilders);
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void modelTypeMatchesValueProviderTypeForStringParameter() {
        this.mockAnotherParameter(this.anotherOperationParameter, this.STRING_TYPE_WITH_ANNOTATIONS);
        this.operationParameterBuilder.withInjectableParameter("anotherParameter", this.OBJECT_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void modelTypeMatchesValueProviderTypeForNumberParameter() {
        this.mockAnotherParameter(this.anotherOperationParameter, this.NUMBER_TYPE_WITH_ANNOTATIONS);
        this.operationParameterBuilder.withInjectableParameter("anotherParameter", this.OBJECT_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void modelTypeMatchesValueProviderTypeForObjectParameter() {
        this.mockAnotherParameter(this.anotherOperationParameter, this.OBJECT_TYPE_WITH_ANNOTATIONS);
        this.operationParameterBuilder.withInjectableParameter("anotherParameter", this.OBJECT_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void modelTypeMatchesValueProviderTypeForArrayParameter() {
        this.mockAnotherParameter(this.anotherOperationParameter, this.ARRAY_TYPE_WITH_ANNOTATIONS);
        this.operationParameterBuilder.withInjectableParameter("anotherParameter", this.OBJECT_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertNoErrors();
    }

    private void assertProblems(String errorMessage) {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Problem)errors.get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)errorMessage));
    }

    private void assertNoErrors() {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    private void validate() {
        this.valueProviderModelValidator.validate(this.extensionModel, this.problemsReporter);
    }

    private void mockParameter(ParameterModel parameter, ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder) {
        this.mockParameter(parameter, builder, "valueProviderId");
    }

    private void mockParameter(ParameterModel parameter, ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder, String valueProviderId) {
        this.mockParameter(parameter, builder, valueProviderId, "someName", this.STRING_TYPE);
    }

    private void mockParameter(ParameterModel parameter, ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder, String valueProviderId, String paramName, MetadataType type) {
        Mockito.when((Object)parameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(builder.build()));
        Mockito.when((Object)parameter.getModelProperty(ImplementingParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getName()).thenReturn((Object)paramName);
        Mockito.when((Object)parameter.getType()).thenReturn((Object)type);
        Mockito.when((Object)parameter.getValueProviderModel()).thenReturn(Optional.of(new ValueProviderModel(Collections.emptyList(), false, false, true, Integer.valueOf(1), "name", valueProviderId)));
    }

    private void mockParameter(ParameterModel parameter, Map<String, ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder> valueProviderFactoryModelPropertyBuilders) {
        HashMap fieldsValueProviderFactories = new HashMap();
        valueProviderFactoryModelPropertyBuilders.forEach((targetSelector, valueProviderFactoryModelPropertyBuilder) -> fieldsValueProviderFactories.put(targetSelector, valueProviderFactoryModelPropertyBuilder.build()));
        FieldsValueProviderFactoryModelProperty fieldsValueProviderFactoryModelProperty = new FieldsValueProviderFactoryModelProperty(fieldsValueProviderFactories);
        FieldValueProviderModel fieldValueProviderModel = new FieldValueProviderModel(Collections.emptyList(), false, false, true, Integer.valueOf(1), "name", "providerId", "simple.path");
        List<FieldValueProviderModel> fieldValueProviderModels = Collections.singletonList(fieldValueProviderModel);
        Mockito.when((Object)this.operationParameter.getModelProperty(FieldsValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(fieldsValueProviderFactoryModelProperty));
        Mockito.when((Object)parameter.getModelProperty(ImplementingParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getName()).thenReturn((Object)"someName");
        Mockito.when((Object)parameter.getType()).thenReturn((Object)this.OBJECT_TYPE);
        Mockito.when((Object)parameter.getFieldValueProviderModels()).thenReturn(fieldValueProviderModels);
    }

    private void mockAnotherParameter(ParameterModel parameter, MetadataType type) {
        Mockito.when((Object)parameter.getModelProperty(ImplementingParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getName()).thenReturn((Object)"anotherParameter");
        Mockito.when((Object)parameter.getType()).thenReturn((Object)type);
    }

    private Map<Class<? extends TypeAnnotation>, TypeAnnotation> createStringAnnotations() {
        HashMap<Class<? extends TypeAnnotation>, TypeAnnotation> annotations = new HashMap<Class<? extends TypeAnnotation>, TypeAnnotation>();
        annotations.put((Class<? extends TypeAnnotation>)ClassInformationAnnotation.class, (TypeAnnotation)new ClassInformationAnnotation(InputStream.class));
        annotations.put((Class<? extends TypeAnnotation>)EnumAnnotation.class, (TypeAnnotation)new EnumAnnotation((Object[])new String[]{"value1", "value2"}));
        return annotations;
    }

    private Map<Class<? extends TypeAnnotation>, TypeAnnotation> createNumberAnnotations() {
        HashMap<Class<? extends TypeAnnotation>, TypeAnnotation> annotations = new HashMap<Class<? extends TypeAnnotation>, TypeAnnotation>();
        annotations.put((Class<? extends TypeAnnotation>)ClassInformationAnnotation.class, (TypeAnnotation)new ClassInformationAnnotation(InputStream.class));
        annotations.put((Class<? extends TypeAnnotation>)EnumAnnotation.class, (TypeAnnotation)new EnumAnnotation((Object[])new Number[]{1, 2}));
        return annotations;
    }

    private Map<Class<? extends TypeAnnotation>, TypeAnnotation> createObjectAnnotations() {
        HashMap<Class<? extends TypeAnnotation>, TypeAnnotation> annotations = new HashMap<Class<? extends TypeAnnotation>, TypeAnnotation>();
        annotations.put((Class<? extends TypeAnnotation>)ClassInformationAnnotation.class, (TypeAnnotation)new ClassInformationAnnotation(InputStream.class));
        return annotations;
    }

    public class NonInstantiableProvider
    implements ValueProvider {
        private NonInstantiableProvider() {
        }

        public Set<Value> resolve() throws ValueResolvingException {
            return null;
        }
    }

    public static class SomeOtherValueProvider
    implements ValueProvider {
        @Connection
        String connection;

        public Set<Value> resolve() {
            return Collections.emptySet();
        }
    }

    public static class SomeValueProvider
    implements ValueProvider {
        @Connection
        String connection;

        public Set<Value> resolve() {
            return Collections.emptySet();
        }
    }
}

