/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.feature.internal.config.DefaultFeatureFlaggingService;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.TestComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@RunWith(value=Parameterized.class)
public class ComponentMessageProcessorPolicyProcessingStrategyTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessorPolicyProcessingStrategyTestCase.class);
    public static final String TEST_ARTIFACT_ID = "artifactId";
    private ComponentMessageProcessor<ComponentModel> processor;
    private Location mpRootContainerLocation;
    private FlowConstruct rootContainer;
    private ProcessingStrategy processingStrategy;
    private ExtensionModel extensionModel;
    private ComponentModel componentModel;
    private ResolverSet resolverSet;
    private ExtensionManager extensionManager;
    private PolicyManager policyManager;
    private final ExecutorService threadSwitcher = Executors.newFixedThreadPool(2);
    private final AssertingExecutionMediator mediator = new AssertingExecutionMediator();
    private final boolean async;
    private final ReactiveProcessor.ProcessingType processingType;

    @Parameterized.Parameters(name="async: {0}, processingType: {1}")
    public static List<Object[]> parameters() {
        return Arrays.asList({true, ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC}, {false, ReactiveProcessor.ProcessingType.CPU_INTENSIVE}, {true, ReactiveProcessor.ProcessingType.CPU_INTENSIVE});
    }

    public ComponentMessageProcessorPolicyProcessingStrategyTestCase(boolean async, ReactiveProcessor.ProcessingType processingType) {
        this.async = async;
        this.processingType = processingType;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("core.featureFlaggingService", (Object)new DefaultFeatureFlaggingService(ComponentMessageProcessorPolicyProcessingStrategyTestCase.TEST_ARTIFACT_ID, Collections.emptyMap()));
            }
        });
    }

    @Before
    public void before() throws MuleException {
        CoreEvent response = this.testEvent();
        this.mpRootContainerLocation = (Location)Mockito.mock(Location.class);
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("mock").build());
        this.componentModel = (ComponentModel)Mockito.mock(ComponentModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{EnrichableModel.class}));
        Mockito.when((Object)this.componentModel.getModelProperty(CompletableComponentExecutorModelProperty.class)).thenReturn(Optional.of(new CompletableComponentExecutorModelProperty((cp, p) -> (ctx, callback) -> callback.complete((Object)response))));
        this.resolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn(Mockito.mock(ResolverSetResult.class));
        this.extensionManager = (ExtensionManager)Mockito.mock(ExtensionManager.class);
        this.policyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        this.processor = new TestComponentMessageProcessor(this.extensionModel, this.componentModel, null, null, null, this.resolverSet, null, null, null, this.extensionManager, this.policyManager, null, null, muleContext.getConfiguration().getShutdownTimeout()){

            protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
            }

            public ReactiveProcessor.ProcessingType getInnerProcessingType() {
                return ComponentMessageProcessorPolicyProcessingStrategyTestCase.this.processingType;
            }

            protected ExecutionMediator createExecutionMediator() {
                return ComponentMessageProcessorPolicyProcessingStrategyTestCase.this.mediator;
            }

            public Location getRootContainerLocation() {
                return ComponentMessageProcessorPolicyProcessingStrategyTestCase.this.mpRootContainerLocation;
            }

            protected boolean requiresConfig() {
                return ComponentMessageProcessorPolicyProcessingStrategyTestCase.this.async;
            }
        };
        this.rootContainer = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        this.processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)this.processingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any(ReactiveProcessor.class))).thenAnswer(inv -> inv.getArgument(0));
        Mockito.when((Object)this.processingStrategy.configureInternalPublisher((Publisher)ArgumentMatchers.any(Publisher.class))).thenAnswer(inv -> inv.getArgument(0));
        Mockito.when((Object)this.componentLocator.find(this.mpRootContainerLocation)).thenReturn(Optional.of(this.rootContainer));
        Mockito.when((Object)this.rootContainer.getProcessingStrategy()).thenReturn((Object)this.processingStrategy);
        this.processor.setComponentLocator(this.componentLocator);
        this.processor.setCacheIdGeneratorFactory((MetadataCacheIdGeneratorFactory)Mockito.mock(MetadataCacheIdGeneratorFactory.class));
        HashMap<QName, Object> annotations = new HashMap<QName, Object>();
        ComponentIdentifier opIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"ns:op");
        annotations.put(AbstractComponent.LOCATION_KEY, new DefaultComponentLocation(Optional.of("appleFlow"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("appleFlow", Optional.of(TypedComponentIdentifier.builder().identifier(opIdentifier).type(TypedComponentIdentifier.ComponentType.FLOW).build()), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()))));
        annotations.put(AbstractComponent.ROOT_CONTAINER_NAME_KEY, "appleFlow");
        annotations.put(AbstractComponent.ANNOTATION_NAME, opIdentifier);
        this.processor.setAnnotations(annotations);
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded(this.processor);
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
        this.threadSwitcher.shutdownNow();
    }

    @Test
    public void policyChangesThreadBefore() throws MuleException {
        AtomicReference switchedRef = new AtomicReference();
        Mockito.when((Object)this.policyManager.createOperationPolicy((Component)ArgumentMatchers.eq(this.processor), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class))).thenReturn((operationEvent, operationExecutionFunction, opParamProcessor, componentLocation, callback) -> this.threadSwitcher.execute(() -> {
            switchedRef.set(Thread.currentThread());
            operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent, callback);
        }));
        MessageProcessors.processToApply((CoreEvent)this.testEvent(), (ReactiveProcessor)this.processingStrategy.onProcessor(this.processor));
        PollingProber.probe(() -> {
            Assert.assertThat((Object)this.mediator.executed, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.mediator.executionThread, (Matcher)Matchers.sameInstance(switchedRef.get()));
            return true;
        });
    }

    @Test
    public void policyChangesThreadAfter() throws MuleException {
        Mockito.when((Object)this.policyManager.createOperationPolicy((Component)ArgumentMatchers.eq(this.processor), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class))).thenReturn((operationEvent, operationExecutionFunction, opParamProcessor, componentLocation, callback) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent, new CompletableComponentExecutor.ExecutorCallback(){

            public void error(Throwable e) {
                ComponentMessageProcessorPolicyProcessingStrategyTestCase.this.threadSwitcher.execute(() -> callback.error(e));
            }

            public void complete(Object value) {
                ComponentMessageProcessorPolicyProcessingStrategyTestCase.this.threadSwitcher.execute(() -> callback.complete(value));
            }
        }));
        MessageProcessors.processToApply((CoreEvent)this.testEvent(), (ReactiveProcessor)this.processingStrategy.onProcessor(this.processor));
        PollingProber.probe(() -> {
            Assert.assertThat((Object)this.mediator.executed, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.mediator.executionThread, (Matcher)Matchers.sameInstance((Object)Thread.currentThread()));
            return true;
        });
    }

    @Test
    public void noPolicyProcessingStrategyChangesThreadBefore() throws MuleException {
        AtomicReference switchedRef = new AtomicReference();
        Mockito.when((Object)this.processingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any(ReactiveProcessor.class))).thenAnswer(inv -> {
            ReactiveProcessor.ProcessingType processingType = ((ReactiveProcessor)inv.getArgument(0, ReactiveProcessor.class)).getProcessingType();
            if (processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) || processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE)) {
                return t -> Mono.from((Publisher)t).transform((Function)inv.getArgument(0, ReactiveProcessor.class));
            }
            return t -> Mono.from((Publisher)t).publishOn(Schedulers.fromExecutorService((ExecutorService)this.threadSwitcher)).doOnNext(e -> switchedRef.set(Thread.currentThread())).transform((Function)inv.getArgument(0, ReactiveProcessor.class));
        });
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded(this.processor);
        Mockito.when((Object)this.policyManager.createOperationPolicy((Component)ArgumentMatchers.eq(this.processor), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class))).thenReturn((Object)DefaultPolicyManager.noPolicyOperation());
        MessageProcessors.processToApply((CoreEvent)this.testEvent(), (ReactiveProcessor)this.processingStrategy.onProcessor(this.processor));
        PollingProber.probe(() -> {
            Assert.assertThat((Object)this.mediator.executed, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.mediator.executionThread, (Matcher)(this.processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) ? Matchers.sameInstance((Object)Thread.currentThread()) : Matchers.sameInstance(switchedRef.get())));
            return true;
        });
    }

    @Test
    public void noPolicyProcessingStrategyChangesThreadAfter() throws MuleException {
        Mockito.when((Object)this.processingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any(ReactiveProcessor.class))).thenAnswer(inv -> {
            ReactiveProcessor.ProcessingType processingType = ((ReactiveProcessor)inv.getArgument(0, ReactiveProcessor.class)).getProcessingType();
            if (processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC)) {
                return t -> Mono.from((Publisher)t).transform((Function)inv.getArgument(0, ReactiveProcessor.class)).publishOn(Schedulers.fromExecutorService((ExecutorService)this.threadSwitcher));
            }
            return t -> Mono.from((Publisher)t).transform((Function)inv.getArgument(0, ReactiveProcessor.class));
        });
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded(this.processor);
        Mockito.when((Object)this.policyManager.createOperationPolicy((Component)ArgumentMatchers.eq(this.processor), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class))).thenReturn((Object)DefaultPolicyManager.noPolicyOperation());
        MessageProcessors.processToApply((CoreEvent)this.testEvent(), (ReactiveProcessor)this.processingStrategy.onProcessor(this.processor));
        PollingProber.probe(() -> {
            Assert.assertThat((Object)this.mediator.executed, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.mediator.executionThread, (Matcher)Matchers.sameInstance((Object)Thread.currentThread()));
            return true;
        });
    }

    @Test
    public void processingStrategyChangesThreadBefore() throws MuleException {
        AtomicReference switchedRef = new AtomicReference();
        Mockito.when((Object)this.processingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any(ReactiveProcessor.class))).thenAnswer(inv -> {
            ReactiveProcessor.ProcessingType processingType = ((ReactiveProcessor)inv.getArgument(0, ReactiveProcessor.class)).getProcessingType();
            if (processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) || processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE)) {
                return t -> Mono.from((Publisher)t).transform((Function)inv.getArgument(0, ReactiveProcessor.class));
            }
            return t -> Mono.from((Publisher)t).publishOn(Schedulers.fromExecutorService((ExecutorService)this.threadSwitcher)).doOnNext(e -> switchedRef.set(Thread.currentThread())).transform((Function)inv.getArgument(0, ReactiveProcessor.class));
        });
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded(this.processor);
        Mockito.when((Object)this.policyManager.createOperationPolicy((Component)ArgumentMatchers.eq(this.processor), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class))).thenReturn((operationEvent, operationExecutionFunction, opParamProcessor, componentLocation, callback) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent, callback));
        MessageProcessors.processToApply((CoreEvent)this.testEvent(), (ReactiveProcessor)this.processingStrategy.onProcessor(this.processor));
        PollingProber.probe(() -> {
            Assert.assertThat((Object)this.mediator.executed, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.mediator.executionThread, (Matcher)(this.processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) ? Matchers.sameInstance((Object)Thread.currentThread()) : Matchers.sameInstance(switchedRef.get())));
            return true;
        });
    }

    @Test
    public void processingStrategyChangesThreadAfter() throws MuleException {
        Mockito.when((Object)this.processingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any(ReactiveProcessor.class))).thenAnswer(inv -> {
            ReactiveProcessor.ProcessingType processingType = ((ReactiveProcessor)inv.getArgument(0, ReactiveProcessor.class)).getProcessingType();
            if (processingType.equals((Object)ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC)) {
                return t -> Mono.from((Publisher)t).transform((Function)inv.getArgument(0, ReactiveProcessor.class)).publishOn(Schedulers.fromExecutorService((ExecutorService)this.threadSwitcher));
            }
            return t -> Mono.from((Publisher)t).transform((Function)inv.getArgument(0, ReactiveProcessor.class));
        });
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded(this.processor);
        Mockito.when((Object)this.policyManager.createOperationPolicy((Component)ArgumentMatchers.eq(this.processor), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class))).thenReturn((operationEvent, operationExecutionFunction, opParamProcessor, componentLocation, callback) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent, callback));
        MessageProcessors.processToApply((CoreEvent)this.testEvent(), (ReactiveProcessor)this.processingStrategy.onProcessor(this.processor));
        PollingProber.probe(() -> {
            Assert.assertThat((Object)this.mediator.executed, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.mediator.executionThread, (Matcher)Matchers.sameInstance((Object)Thread.currentThread()));
            return true;
        });
    }

    private static class AssertingExecutionMediator
    implements ExecutionMediator {
        private Thread executionThread;
        private boolean executed;

        private AssertingExecutionMediator() {
        }

        public void execute(CompletableComponentExecutor executor, ExecutionContextAdapter context, CompletableComponentExecutor.ExecutorCallback callback) {
            this.executed = true;
            this.executionThread = Thread.currentThread();
            callback.complete((Object)"");
        }
    }
}

