/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import io.qameta.allure.Issue;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Issue(value="MULE-19815")
public class ExtensionComponentTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private FeatureFlaggingService featureFlaggingService;
    @Mock
    private MuleApplicationClassLoader applicationClassLoader;
    private ExtensionComponent extensionComponent;
    private AtomicReference<ClassLoader> executedClassloader = new AtomicReference();
    private MuleArtifactClassLoader artifactClassLoader;

    @Before
    public void setUp() throws Exception {
        this.extensionComponent = new TestExtensionComponent((ExtensionModel)Mockito.mock(ExtensionModel.class), (ComponentModel)Mockito.mock(ComponentModel.class), (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class), (CursorProviderFactory)Mockito.mock(CursorProviderFactory.class), (ExtensionManager)Mockito.mock(ExtensionManager.class));
        RegionClassLoader regionClassLoader = (RegionClassLoader)Mockito.mock(RegionClassLoader.class);
        Mockito.when((Object)regionClassLoader.getOwnerClassLoader()).thenReturn((Object)this.applicationClassLoader);
        Mockito.when((Object)this.applicationClassLoader.getClassLoader()).thenReturn((Object)this.applicationClassLoader);
        URL url = new URL("file:///app.txt");
        this.artifactClassLoader = new MuleArtifactClassLoader("test", (ArtifactDescriptor)Mockito.mock(ArtifactDescriptor.class), new URL[]{url}, (ClassLoader)regionClassLoader, (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class));
        this.extensionComponent.classLoader = this.artifactClassLoader;
        MetadataCacheIdGeneratorFactory metadataCacheIdGeneratorFactory = (MetadataCacheIdGeneratorFactory)Mockito.mock(MetadataCacheIdGeneratorFactory.class);
        Mockito.when((Object)metadataCacheIdGeneratorFactory.create((DslResolvingContext)ArgumentMatchers.any(), (ComponentLocator)ArgumentMatchers.any())).thenReturn(null);
        this.extensionComponent.setCacheIdGeneratorFactory(metadataCacheIdGeneratorFactory);
        this.executedClassloader.set(null);
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("core.featureFlaggingService", (Object)this.featureFlaggingService);
    }

    @Test
    public void testLoadingWithComposite() throws MuleException {
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.START_EXTENSION_COMPONENTS_WITH_ARTIFACT_CLASSLOADER)).thenReturn((Object)false);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionComponent, (MuleContext)muleContext);
        this.extensionComponent.start();
        MatcherAssert.assertThat((Object)this.executedClassloader.get(), (Matcher)Matchers.instanceOf(CompositeClassLoader.class));
        MatcherAssert.assertThat((Object)((CompositeClassLoader)this.executedClassloader.get()).getDelegates().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(((CompositeClassLoader)this.executedClassloader.get()).getDelegates().get(0), (Matcher)Matchers.is((Object)this.artifactClassLoader));
        MatcherAssert.assertThat(((CompositeClassLoader)this.executedClassloader.get()).getDelegates().get(1), (Matcher)Matchers.is((Object)this.applicationClassLoader));
    }

    @Test
    public void testLoadingWithArtifact() throws MuleException {
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.START_EXTENSION_COMPONENTS_WITH_ARTIFACT_CLASSLOADER)).thenReturn((Object)true);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionComponent, (MuleContext)muleContext);
        this.extensionComponent.start();
        MatcherAssert.assertThat((Object)this.executedClassloader.get(), (Matcher)Matchers.instanceOf(MuleArtifactClassLoader.class));
        MatcherAssert.assertThat((Object)this.executedClassloader.get(), (Matcher)Matchers.is((Object)this.artifactClassLoader));
    }

    private final class TestExtensionComponent
    extends ExtensionComponent {
        TestExtensionComponent(ExtensionModel extensionModel, ComponentModel componentModel, ConfigurationProvider configurationProvider, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager) {
            super(extensionModel, componentModel, configurationProvider, cursorProviderFactory, extensionManager);
        }

        protected void doInitialise() throws InitialisationException {
        }

        protected void doStart() throws MuleException {
            ExtensionComponentTestCase.this.executedClassloader.set(Thread.currentThread().getContextClassLoader());
        }

        protected void doStop() throws MuleException {
        }

        protected void doDispose() {
        }

        protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        }

        protected ParameterValueResolver getParameterValueResolver() {
            return null;
        }
    }
}

