/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstanceTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class LifecycleAwareConfigurationInstanceAsyncRetryTestCase
extends LifecycleAwareConfigurationInstanceTestCase {
    public LifecycleAwareConfigurationInstanceAsyncRetryTestCase(String name, ConnectionProvider connectionProvider) {
        super(name, connectionProvider);
    }

    @Override
    protected RetryPolicyTemplate createRetryTemplate() {
        return new AsynchronousRetryTemplate(super.createRetryTemplate());
    }

    @Override
    @Test
    public void testConnectivityFailsUponStart() throws Exception {
        if (this.connectionProvider.isPresent()) {
            ConnectionException connectionException = new ConnectionException("Oops!");
            Mockito.when((Object)this.connectionManager.testConnectivity((ConfigurationInstance)this.configurationInstance)).thenReturn((Object)ConnectionValidationResult.failure((String)connectionException.getMessage(), (Exception)connectionException));
            this.configurationInstance.initialise();
            this.configurationInstance.start();
            new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
                ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.times((int)6))).testConnectivity((ConfigurationInstance)this.configurationInstance);
                return true;
            }));
        }
    }

    @Override
    @Test
    public void valueStarted() throws Exception {
        this.configurationInstance.initialise();
        super.valueStarted();
    }

    @Override
    @Test
    public void valueStopped() throws Exception {
        this.configurationInstance.initialise();
        super.valueStopped();
    }

    @Override
    @Test
    public void connectionUnbound() throws Exception {
        this.configurationInstance.initialise();
        super.connectionUnbound();
    }

    @Override
    @Test
    public void testConnectivityUponStart() throws Exception {
        if (this.connectionProvider.isPresent()) {
            this.valueStarted();
            new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
                ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager)).testConnectivity((ConfigurationInstance)this.configurationInstance);
                return true;
            }));
        }
    }

    @Test
    public void stopWhileConnectivityTestingExecuting() throws Throwable {
        if (this.connectionProvider.isPresent()) {
            Latch testConnectivityInvokedLatch = new Latch();
            Latch interceptableShutdownLatch = new Latch();
            Mockito.reset((Object[])new ConnectionManagerAdapter[]{this.connectionManager});
            AtomicBoolean stopped = new AtomicBoolean();
            AtomicReference thrownByTestConnectivity = new AtomicReference();
            AtomicBoolean testConnectivityFinished = new AtomicBoolean();
            Mockito.when((Object)this.connectionManager.getRetryTemplateFor((ConnectionProvider)this.connectionProvider.get())).thenReturn((Object)this.retryPolicyTemplate);
            Mockito.when((Object)this.connectionManager.testConnectivity((ConfigurationInstance)Mockito.any(ConfigurationInstance.class))).then(inv -> {
                testConnectivityInvokedLatch.countDown();
                try {
                    interceptableShutdownLatch.await(10L, TimeUnit.SECONDS);
                    Assert.assertThat((Object)stopped.get(), (Matcher)Matchers.is((Object)false));
                }
                catch (Throwable t) {
                    thrownByTestConnectivity.set(t);
                }
                testConnectivityFinished.set(true);
                return ConnectionValidationResult.success();
            });
            this.configurationInstance.initialise();
            this.configurationInstance.start();
            Assert.assertThat((Object)testConnectivityInvokedLatch.await(10L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
            this.configurationInstance.stop();
            stopped.set(true);
            interceptableShutdownLatch.countDown();
            new PollingProber(15000L, 1000L).check((Probe)new JUnitLambdaProbe(testConnectivityFinished::get));
            if (thrownByTestConnectivity.get() != null) {
                throw (Throwable)thrownByTestConnectivity.get();
            }
        }
    }
}

