/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.cluster.ClusterService;
import org.mule.runtime.api.notification.ClusterNodeNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.privileged.util.LoggingTestUtils;
import org.mule.runtime.module.extension.internal.runtime.source.AbstractExtensionMessageSourceTestCase;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class ClusterExtensionMessageSourceTestCase
extends AbstractExtensionMessageSourceTestCase {
    protected List<String> debugMessages;
    private Logger oldLogger;

    public ClusterExtensionMessageSourceTestCase() {
        this.primaryNodeOnly = true;
        SimpleRetryPolicyTemplate template = new SimpleRetryPolicyTemplate(0L, 2);
        template.setNotificationFirer(this.notificationDispatcher);
        this.retryPolicyTemplate = template;
    }

    @Before
    public void setUpLogger() throws Exception {
        this.debugMessages = new ArrayList<String>();
        this.oldLogger = LoggingTestUtils.setLogger((Object)this.messageSource, (String)"LOGGER", (Logger)LoggingTestUtils.createMockLogger(this.debugMessages, (Level)Level.DEBUG));
    }

    @After
    public void restoreLogger() throws Exception {
        LoggingTestUtils.setLogger((Object)this.messageSource, (String)"LOGGER", (Logger)this.oldLogger);
    }

    @Override
    public void before() throws Exception {
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("_muleClusterService", (Object)new TestClusterService());
        super.before();
    }

    @Override
    protected SourceAdapter createSourceAdapter() {
        return (SourceAdapter)Mockito.spy((Object)super.createSourceAdapter());
    }

    @Test
    public void dontStartIfNotPrimaryNode() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.never())).initialise();
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void startWhenPrimaryNode() throws Exception {
        this.dontStartIfNotPrimaryNode();
        muleContext.getNotificationManager().fireNotification((Notification)new ClusterNodeNotification((Object)"you're up", 1701));
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.atLeastOnce())).initialise();
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void dontStartIfNotPrimaryNodeLogMessage() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        LoggingTestUtils.verifyLogMessage(this.debugMessages, (String)"Message source 'source' on flow 'appleFlow' cannot initialize. This Message source can only run on the primary node of the cluster", (Object[])new Object[0]);
    }

    @Test
    public void startWhenPrimaryNodeLogMessage() throws Exception {
        this.dontStartIfNotPrimaryNode();
        muleContext.getNotificationManager().fireNotification((Notification)new ClusterNodeNotification((Object)"you're up", 1701));
        LoggingTestUtils.verifyLogMessage(this.debugMessages, (String)"Message source 'source' on flow 'appleFlow' is initializing because the node became cluster's primary.", (Object[])new Object[0]);
    }

    private static class TestClusterService
    implements ClusterService {
        private TestClusterService() {
        }

        public boolean isPrimaryPollingInstance() {
            return false;
        }
    }
}

