/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.internal.error.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.ModelLoaderDelegateUtils;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.RouterModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.AllowedStereotypesModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

final class OperationModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private final Map<OperationModelParser, OperationDeclarer> operationDeclarers = new HashMap<OperationModelParser, OperationDeclarer>();
    private final RouterModelLoaderDelegate routersDelegate;

    OperationModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
        this.routersDelegate = new RouterModelLoaderDelegate(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, List<OperationModelParser> operations) {
        for (OperationModelParser parser : operations) {
            boolean extensionLevelOperation;
            if (parser.isIgnored()) continue;
            boolean requiresConfig = ModelLoaderDelegateUtils.requiresConfig(parser);
            HasOperationDeclarer actualDeclarer = requiresConfig ? ownerDeclarer : extensionDeclarer;
            boolean bl = extensionLevelOperation = actualDeclarer == extensionDeclarer;
            if (extensionLevelOperation && parser.isAutoPaging()) {
                throw new IllegalOperationModelDefinitionException(String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", parser.getName()));
            }
            if (extensionLevelOperation && requiresConfig) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", parser.getName()));
            }
            if (this.operationDeclarers.containsKey(parser)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(parser));
                continue;
            }
            if (parser.isRouter()) {
                this.routersDelegate.declareRouter(extensionDeclarer, (HasConstructDeclarer)ownerDeclarer, parser);
                continue;
            }
            OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(parser.getName()).describedAs(parser.getDescription())).supportsStreaming(parser.supportsStreaming())).transactional(parser.isTransactional())).requiresConnection(parser.isConnected())).blocking(parser.isBlocking()).withVisibility(parser.getComponentVisibility());
            parser.getExecutorModelProperty().ifPresent(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
            parser.getOutputType().applyOn(operation.withOutput());
            parser.getAttributesOutputType().applyOn(operation.withOutputAttributes());
            parser.getMediaTypeModelProperty().ifPresent(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
            parser.getDeprecationModel().ifPresent(arg_0 -> ((OperationDeclarer)operation).withDeprecation(arg_0));
            parser.getDisplayModel().ifPresent(d -> ((OperationDeclaration)operation.getDeclaration()).setDisplayModel(d));
            this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)operation, parser.getParameterGroupModelParsers());
            ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)operation.getDeclaration(), parser);
            parser.getExecutionType().ifPresent(arg_0 -> ((OperationDeclarer)operation).withExecutionType(arg_0));
            parser.getAdditionalModelProperties().forEach(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
            parser.getExceptionHandlerModelProperty().ifPresent(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
            parser.getNestedChainParser().ifPresent(chain -> {
                NestedChainDeclarer chainDeclarer = ((NestedChainDeclarer)operation.withChain(chain.getName()).describedAs(chain.getDescription())).setRequired(chain.isRequired());
                ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)chainDeclarer.getDeclaration(), chain);
                this.getStereotypeModelLoaderDelegate().addAllowedStereotypes((AllowedStereotypesModelParser)chain, (NestedComponentDeclarer)chainDeclarer);
            });
            this.loader.registerOutputTypes((ExecutableComponentDeclaration)operation.getDeclaration());
            this.declareErrorModels(operation, parser);
            this.getStereotypeModelLoaderDelegate().addStereotypes(parser, operation, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultOperationStereotype(parser.getName())));
            NotificationModelParserUtils.declareEmittedNotifications(parser, (ExecutableComponentDeclarer)operation, this.loader::getNotificationModel);
            this.operationDeclarers.put(parser, operation);
        }
    }

    private void declareErrorModels(OperationDeclarer operation, OperationModelParser parser) {
        ErrorsModelFactory errorsModelFactory = this.loader.createErrorModelFactory();
        parser.getErrorModelParsers().stream().map(errorsModelFactory::getErrorModel).forEach(arg_0 -> ((OperationDeclarer)operation).withErrorModel(arg_0));
    }
}

