/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.Optional;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.parser.SemanticTermsParser;
import org.mule.runtime.module.extension.internal.loader.parser.XmlDslConfiguration;

public final class ModelLoaderUtils {
    private ModelLoaderUtils() {
    }

    public static void addSemanticTerms(WithSemanticTermsDeclaration declaration, SemanticTermsParser parser) {
        declaration.getSemanticTerms().addAll(parser.getSemanticTerms());
    }

    public static XmlDslModel getXmlDslModel(String extensionName, String version, Optional<XmlDslConfiguration> xmlDslAnnotationConfiguration) {
        Optional<Object> prefix = Optional.empty();
        Optional<Object> namespace = Optional.empty();
        if (xmlDslAnnotationConfiguration.isPresent()) {
            prefix = Optional.of(xmlDslAnnotationConfiguration.get().getPrefix());
            namespace = Optional.of(xmlDslAnnotationConfiguration.get().getNamespace());
        }
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, (String)extensionName, (String)version);
    }

    public static XmlDslModel getXmlDslModel(ExtensionElement extensionElement, String version, Optional<XmlDslConfiguration> xmlDslAnnotationConfiguration) {
        return ModelLoaderUtils.getXmlDslModel(extensionElement.getName(), version, xmlDslAnnotationConfiguration);
    }
}

