/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.internal.client.ComplexParameter;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.runtime.client.ShutdownExecutor;
import org.mule.runtime.module.extension.internal.runtime.client.operation.DefaultOperationParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.operation.EventedOperationsParameterDecorator;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationClient;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationKey;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionsClient
implements ExtensionsClient,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionsClient.class);
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ExtensionConnectionSupplier extensionConnectionSupplier;
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private MuleContext muleContext;
    private ExecutorService cacheShutdownExecutor;
    private LoadingCache<OperationKey, OperationClient> clientCache;

    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extensionName, String operationName, Consumer<OperationParameterizer> parameters) {
        DefaultOperationParameterizer parameterizer = new DefaultOperationParameterizer();
        parameters.accept(parameterizer);
        OperationKey key = this.toKey(extensionName, operationName, parameterizer);
        return ((OperationClient)this.clientCache.get((Object)key)).execute(key, parameterizer);
    }

    private OperationKey toKey(String extensionName, String operationName, DefaultOperationParameterizer parameterizer) {
        return new OperationKey(extensionName, parameterizer.getConfigRef(), operationName, (CheckedFunction<String, ExtensionModel>)((CheckedFunction)this::findExtension), (CheckedBiFunction<ExtensionModel, String, OperationModel>)((CheckedBiFunction)this::findOperationModel), this.extensionManager);
    }

    private LoadingCache<OperationKey, OperationClient> createClientCache() {
        return Caffeine.newBuilder().executor((Executor)this.cacheShutdownExecutor).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((key, mediator, cause) -> this.disposeClient((OperationKey)key, (OperationClient)mediator)).build(this::createOperationClient);
    }

    private OperationClient createOperationClient(OperationKey key) {
        OperationClient client = OperationClient.from(key, this.extensionManager, this.expressionManager, this.extensionConnectionSupplier, this.errorTypeRepository, this.streamingManager, this.reflectionCache, this.muleContext);
        try {
            LifecycleUtils.initialiseIfNeeded((Object)client);
            LifecycleUtils.startIfNeeded((Object)client);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception found creating operation client: " + e.getMessage())), (Throwable)e);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeClient(OperationKey identifier, OperationClient client) {
        try {
            LifecycleUtils.stopIfNeeded((Object)client);
        }
        catch (Exception e) {
            LOGGER.error("Exception found trying to stop operation client for operation " + identifier);
        }
        finally {
            LifecycleUtils.disposeIfNeeded((Object)client, (Logger)LOGGER);
        }
    }

    private OperationModel findOperationModel(ExtensionModel extensionModel, String operationName) {
        return MuleExtensionUtils.findOperation(extensionModel, operationName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("No Operation [%s] Found", operationName))));
    }

    private ExtensionModel findExtension(String extensionName) {
        return (ExtensionModel)this.extensionManager.getExtension(extensionName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No Extension [" + extensionName + "] Found"))));
    }

    @Deprecated
    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extensionName, String operationName, OperationParameters parameters) {
        ExtensionModel extensionModel = this.findExtension(extensionName);
        OperationModel operationModel = this.findOperationModel(extensionModel, operationName);
        return this.executeAsync(extensionName, operationName, (OperationParameterizer parameterizer) -> {
            this.setContextEvent((OperationParameterizer)parameterizer, parameters);
            parameters.getConfigName().ifPresent(arg_0 -> ((OperationParameterizer)parameterizer).withConfigRef(arg_0));
            this.resolveLegacyParameters((OperationParameterizer)parameterizer, parameters);
            this.configureLegacyRepeatableStreaming((OperationParameterizer)parameterizer, operationModel);
        });
    }

    protected void resolveLegacyParameters(OperationParameterizer parameterizer, OperationParameters legacyParameters) {
        this.resolveLegacyParameters(legacyParameters.get(), (arg_0, arg_1) -> ((OperationParameterizer)parameterizer).withParameter(arg_0, arg_1));
    }

    private void resolveLegacyParameters(Map<String, Object> parameters, BiConsumer<String, Object> resolvedValueConsumer) {
        parameters.forEach((paramName, value) -> {
            if ("config-ref".equals(paramName)) {
                return;
            }
            if (value instanceof ComplexParameter) {
                ComplexParameter complex = (ComplexParameter)value;
                DefaultObjectBuilder builder = new DefaultObjectBuilder(complex.getType(), this.reflectionCache);
                this.resolveLegacyParameters(complex.getParameters(), (String propertyName, Object propertyValue) -> builder.addPropertyResolver((String)propertyName, (ValueResolver<Object>)new StaticValueResolver<Object>(propertyValue)));
                value = FunctionalUtils.withNullEvent(event -> {
                    try (ValueResolvingContext ctx = ValueResolvingContext.builder(event).build();){
                        Object t = builder.build(ctx);
                        return t;
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not construct parameter [%s]", paramName)), (Throwable)e);
                    }
                });
            }
            resolvedValueConsumer.accept((String)paramName, value);
        });
    }

    @Deprecated
    public <T, A> Result<T, A> execute(String extension, String operation, OperationParameters params) throws MuleException {
        try {
            return this.executeAsync(extension, operation, params).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MuleException) {
                throw (MuleException)cause;
            }
            throw new DefaultMuleException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void configureLegacyRepeatableStreaming(OperationParameterizer parameterizer, OperationModel operationModel) {
        if (operationModel.getModelProperty(PagedOperationModelProperty.class).isPresent()) {
            this.setDefaultRepeatableIterables(parameterizer);
        } else if (operationModel.supportsStreaming()) {
            this.setDefaultRepeatableStreaming(parameterizer);
        }
    }

    private void setDefaultRepeatableStreaming(OperationParameterizer parameterizer) {
        parameterizer.withDefaultRepeatableStreaming();
    }

    private void setDefaultRepeatableIterables(OperationParameterizer parameterizer) {
        parameterizer.withDefaultRepeatableIterables();
    }

    private void setContextEvent(OperationParameterizer parameterizer, OperationParameters parameters) {
        if (parameters instanceof EventedOperationsParameterDecorator) {
            parameterizer.inTheContextOf(((EventedOperationsParameterDecorator)parameters).getContextEvent());
        }
    }

    public void initialise() throws InitialisationException {
        this.cacheShutdownExecutor = new ShutdownExecutor();
        this.clientCache = this.createClientCache();
    }

    public void dispose() {
        if (this.clientCache != null) {
            this.clientCache.invalidateAll();
        }
        if (this.cacheShutdownExecutor != null) {
            this.cacheShutdownExecutor.shutdown();
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.cacheShutdownExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

