/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.tracing.event.tracer.CoreEventTracer;
import org.mule.runtime.core.internal.trace.DistributedTraceContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.tracing.InternalDistributedTraceContextManager;
import org.mule.runtime.module.extension.internal.runtime.tracing.InternalDistributedTraceContextVisitor;

public class PropagateAllDistributedTraceContextManager
implements InternalDistributedTraceContextManager {
    private Map<String, String> contextMap;
    private final CoreEvent coreEvent;
    private final CoreEventTracer coreEventTracer;

    public PropagateAllDistributedTraceContextManager(CoreEvent coreEvent, CoreEventTracer coreEventTracer) {
        this.coreEventTracer = coreEventTracer;
        this.coreEvent = coreEvent;
    }

    private void resolveContextMap(DistributedTraceContext distributedTraceContext) {
        HashMap contextMapToBuild = new HashMap(distributedTraceContext.tracingFieldsAsMap());
        contextMapToBuild.putAll(distributedTraceContext.baggageItemsAsMap());
        this.contextMap = Collections.unmodifiableMap(contextMapToBuild);
    }

    public void setRemoteTraceContextMap(Map<String, String> contextMap) {
        this.contextMap = contextMap;
    }

    public Map<String, String> getRemoteTraceContextMap() {
        if (this.contextMap == null) {
            this.resolveContextMap(ResolverUtils.resolveDistributedTraceContext(this.coreEvent, this.coreEventTracer));
        }
        return this.contextMap;
    }

    public void setCurrentSpanName(String name) {
        this.coreEventTracer.setCurrentSpanName(this.coreEvent, name);
    }

    public void addCurrentSpanAttribute(String key, String value) {
        this.coreEventTracer.addCurrentSpanAttribute(this.coreEvent, key, value);
    }

    public void addCurrentSpanAttributes(Map<String, String> attributes) {
        this.coreEventTracer.addCurrentSpanAttributes(this.coreEvent, attributes);
    }

    @Override
    public <T> T visit(InternalDistributedTraceContextVisitor<T> visitor) {
        return visitor.accept(this);
    }
}

