/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import io.qameta.allure.Description;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.drugs.Drug;
import org.mule.test.heisenberg.extension.model.drugs.DrugBatch;
import org.mule.test.heisenberg.extension.model.drugs.Meta;
import org.mule.test.heisenberg.extension.model.types.DEAOfficerAttributes;

@SmallTest
public class ExtensionTypesDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    }

    @Test
    public void assertTypes() throws Exception {
        this.assertTypes(this.extensionModel.getTypes(), true, "Type %s was not present", Ricin.class, KnockeableDoor.class, CarWash.class, Weapon.class, Weapon.WeaponAttributes.class, PersonalInfo.class, Methylamine.class);
        this.assertTypes(this.extensionModel.getTypes(), false, "Invalid type %s was exported", Object.class, Map.class);
    }

    private void assertTypes(Set<ObjectType> extensionTypes, boolean typeShouldBePresent, String message, Class<?> ... expectedTypes) {
        for (Class<?> expectedType : expectedTypes) {
            Optional<ObjectType> extensionType = extensionTypes.stream().filter(type -> ExtensionMetadataTypeUtils.getType((MetadataType)type).map(expectedType::equals).orElse(false)).findFirst();
            Assert.assertThat((String)String.format(message, expectedType.getName()), (Object)extensionType.isPresent(), (Matcher)CoreMatchers.is((Object)typeShouldBePresent));
        }
    }

    @Test
    public void noInfrastructureTypes() throws Exception {
        this.extensionModel.getTypes().forEach(type -> Assert.assertThat((Object)type.getAnnotation(InfrastructureTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)false)));
    }

    @Test
    @Description(value="Checks that types that are declared in the extension but not used explicitly are added")
    public void addsUnusedDeclaredTypes() throws Exception {
        this.assertTypes(this.extensionModel.getTypes(), true, "Type %s was not present", Drug.class, Meta.class);
    }

    @Test
    @Description(value="Checks that POJOs declared in structures like PagingProvider<Connnection C,Result<POJO,Void>> or List<Result<Void,POJO>> are added as Types in the model.")
    public void addsPOJOsInsideAListOfResultsAsTypes() throws Exception {
        this.assertTypes(this.extensionModel.getTypes(), true, "Type %s was not present", DrugBatch.class, DEAOfficerAttributes.class);
    }
}

