/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.CustomStereotypeModelProperty;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.stereotypes.EmpireStereotype;
import org.mule.test.marvel.MarvelExtension;

public class StereotypesDeclarationTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    public static final String MARVEL_NAMESPACE = "Marvel".toUpperCase();
    private final ExtensionModel marvelExtension = MuleExtensionUtils.loadExtension(MarvelExtension.class);
    private final ExtensionModel heisenbergExtension = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    private final ConfigurationModel configuration = (ConfigurationModel)this.marvelExtension.getConfigurationModel("dr-strange").get();

    @Test
    public void connectionProviderWithMultipleConfigReferenceParameter() {
        ParameterModel paramWithReferences = (ParameterModel)((ConnectionProviderModel)this.configuration.getConnectionProviders().get(0)).getAllParameterModels().get(0);
        List allowedStereotypes = paramWithReferences.getAllowedStereotypes();
        MatcherAssert.assertThat((Object)allowedStereotypes, (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.assertStereotype((StereotypeModel)allowedStereotypes.get(0), "Heisenberg", "config", MuleStereotypes.CONFIG);
        this.assertStereotype((StereotypeModel)allowedStereotypes.get(1), "Marvel", "ironMan", MuleStereotypes.CONFIG);
    }

    @Test
    public void configWithObjectStoreReference() {
        ParameterModel osParam = this.configuration.getAllParameterModels().stream().filter(p -> p.getName().equals("spellStore")).findFirst().get();
        MatcherAssert.assertThat((Object)osParam.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        StereotypeModel stereotypeModel = (StereotypeModel)osParam.getAllowedStereotypes().get(0);
        MatcherAssert.assertThat((Object)stereotypeModel, (Matcher)Is.is((Object)MuleStereotypes.OBJECT_STORE));
    }

    @Test
    public void exportedTypesWithStereotypes() {
        Optional<ObjectType> withStereoType = this.marvelExtension.getTypes().stream().filter(type -> type.getAnnotation(StereotypeTypeAnnotation.class).isPresent()).findFirst();
        MatcherAssert.assertThat((Object)withStereoType.isPresent(), (Matcher)Is.is((Object)true));
        Optional stereotype = withStereoType.get().getAnnotation(StereotypeTypeAnnotation.class);
        List allowedStereotypes = ((StereotypeTypeAnnotation)stereotype.get()).getAllowedStereotypes();
        MatcherAssert.assertThat((Object)allowedStereotypes, (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertStereotype((StereotypeModel)allowedStereotypes.get(0), "Marvel", "DR_STRANGE_STEREOTYPE", null);
    }

    @Test
    public void sourceParameterWithCustomReference() {
        SourceModel source = (SourceModel)this.configuration.getSourceModel("bytes-caster").get();
        ParameterModel param = source.getAllParameterModels().stream().filter(p -> p.getName().equals("nextOperationReference")).findFirst().get();
        List stereotypes = param.getAllowedStereotypes();
        MatcherAssert.assertThat((Object)stereotypes, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((StereotypeModel)stereotypes.get(0)).getType(), (Matcher)Is.is((Object)"REFERABLE_OPERATION"));
        MatcherAssert.assertThat((Object)((StereotypeModel)stereotypes.get(0)).getNamespace(), (Matcher)Is.is((Object)"MARVEL"));
    }

    @Test
    public void operationParameterWithFlowReferenceParameter() {
        OperationModel operation = (OperationModel)this.configuration.getOperationModel("withFlowReference").get();
        MatcherAssert.assertThat((Object)operation.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        ParameterModel param = (ParameterModel)operation.getAllParameterModels().get(0);
        List stereotypes = param.getAllowedStereotypes();
        MatcherAssert.assertThat((Object)stereotypes, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(stereotypes.get(0), (Matcher)Is.is((Object)MuleStereotypes.FLOW));
    }

    @Test
    public void configurationWithConfigReferenceParameter() {
        List params = this.configuration.getAllParameterModels();
        MatcherAssert.assertThat((Object)params, (Matcher)IsCollectionWithSize.hasSize((int)4));
        ParameterModel param = (ParameterModel)params.get(0);
        List allowedStereotypes = param.getAllowedStereotypes();
        MatcherAssert.assertThat((Object)allowedStereotypes, (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertStereotype((StereotypeModel)allowedStereotypes.get(0), "Marvel", "ironMan", MuleStereotypes.CONFIG);
    }

    @Test
    public void defaultConfigStereotype() {
        StereotypeModel stereotypeModel = ((ConfigurationModel)this.marvelExtension.getConfigurationModel("ironMan").get()).getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.CONFIG), (Matcher)Is.is((Object)true));
        this.assertStereotype(stereotypeModel, MARVEL_NAMESPACE, "IRON_MAN", MuleStereotypes.CONFIG);
    }

    @Test
    public void defaultConnectionStereotype() {
        StereotypeModel stereotypeModel = ((ConnectionProviderModel)((ConfigurationModel)this.marvelExtension.getConfigurationModel("dr-strange").get()).getConnectionProviderModel("mystic").get()).getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.CONNECTION), (Matcher)Is.is((Object)true));
        this.assertStereotype(stereotypeModel, MARVEL_NAMESPACE, "MYSTIC", MuleStereotypes.CONNECTION);
    }

    @Test
    public void defaultProcessorStereotype() {
        StereotypeModel stereotypeModel = ((OperationModel)((ConfigurationModel)this.marvelExtension.getConfigurationModel("ironMan").get()).getOperationModel("fireMissile").get()).getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.PROCESSOR), (Matcher)Is.is((Object)true));
        StereotypeModel expectedParent = StereotypeModelBuilder.newStereotype((String)MuleStereotypes.PROCESSOR.getType(), (String)MARVEL_NAMESPACE).withParent(MuleStereotypes.PROCESSOR).build();
        this.assertStereotype(stereotypeModel, MARVEL_NAMESPACE, "FIRE_MISSILE", expectedParent);
    }

    @Test
    public void defaultSourceStereotype() {
        StereotypeModel stereotypeModel = ((SourceModel)((ConfigurationModel)this.marvelExtension.getConfigurationModel("dr-strange").get()).getSourceModel("bytes-caster").get()).getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.SOURCE), (Matcher)Is.is((Object)true));
        StereotypeModel expectedParent = StereotypeModelBuilder.newStereotype((String)MuleStereotypes.SOURCE.getType(), (String)MARVEL_NAMESPACE).withParent(MuleStereotypes.SOURCE).build();
        this.assertStereotype(stereotypeModel, MARVEL_NAMESPACE, "BYTES-CASTER", expectedParent);
    }

    @Test
    public void defaultConstructStereotype() {
        StereotypeModel stereotypeModel = ((ConstructModel)this.heisenbergExtension.getConstructModel("simpleRouter").get()).getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.PROCESSOR), (Matcher)Is.is((Object)true));
        String namespace = "Heisenberg".toUpperCase();
        StereotypeModel expectedParent = StereotypeModelBuilder.newStereotype((String)MuleStereotypes.PROCESSOR.getType(), (String)namespace).withParent(MuleStereotypes.PROCESSOR).build();
        this.assertStereotype(stereotypeModel, namespace, "SIMPLE_ROUTER", expectedParent);
    }

    @Test
    public void customStereotype() {
        OperationModel operation = (OperationModel)((ConfigurationModel)this.heisenbergExtension.getConfigurationModels().get(0)).getOperationModel("callSaul").get();
        StereotypeModel stereotypeModel = operation.getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.PROCESSOR), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)stereotypeModel.getType(), (Matcher)Is.is((Object)new EmpireStereotype().getName().toUpperCase()));
        MatcherAssert.assertThat((Object)stereotypeModel.getNamespace(), (Matcher)Is.is((Object)"Heisenberg".toUpperCase()));
        MatcherAssert.assertThat(stereotypeModel.getParent().get(), (Matcher)Is.is((Object)MuleStereotypes.PROCESSOR));
        MatcherAssert.assertThat((Object)operation.getModelProperty(CustomStereotypeModelProperty.class).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validatorStereotype() {
        OperationModel operation = (OperationModel)this.heisenbergExtension.getOperationModel("validateMoney").get();
        StereotypeModel stereotypeModel = operation.getStereotype();
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.PROCESSOR), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)stereotypeModel.isAssignableTo(MuleStereotypes.VALIDATOR), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)stereotypeModel.getType(), (Matcher)Is.is((Object)MuleStereotypes.VALIDATOR_DEFINITION.getName()));
        MatcherAssert.assertThat((Object)stereotypeModel.getNamespace(), (Matcher)Is.is((Object)"Heisenberg".toUpperCase()));
        MatcherAssert.assertThat(stereotypeModel.getParent().get(), (Matcher)Is.is((Object)MuleStereotypes.VALIDATOR));
    }

    @Test
    public void allowedStereotypeOnScopeChain() {
        OperationModel operation = (OperationModel)this.heisenbergExtension.getOperationModel("getChain").get();
        NestedChainModel nestedChain = (NestedChainModel)operation.getNestedComponents().get(0);
        MatcherAssert.assertThat((Object)nestedChain.getAllowedStereotypes().size(), (Matcher)Is.is((Object)1));
        StereotypeModel stereotypeModel = (StereotypeModel)nestedChain.getAllowedStereotypes().iterator().next();
        MatcherAssert.assertThat((String)stereotypeModel.toString(), (Object)stereotypeModel, (Matcher)Is.is((Object)MuleStereotypes.VALIDATOR));
    }

    private void assertStereotype(StereotypeModel stereotypeModel, String ns, String name, StereotypeModel parent) {
        StereotypeModel expected = StereotypeModelBuilder.newStereotype((String)name, (String)ns).withParent(parent).build();
        MatcherAssert.assertThat((Object)stereotypeModel.getNamespace(), (Matcher)Is.is((Object)expected.getNamespace()));
        MatcherAssert.assertThat((Object)stereotypeModel.getType(), (Matcher)Is.is((Object)expected.getType()));
        if (stereotypeModel.getParent().isPresent()) {
            MatcherAssert.assertThat((Object)expected.getParent().isPresent(), (Matcher)Is.is((Object)true));
            this.assertStereotype((StereotypeModel)stereotypeModel.getParent().get(), parent.getNamespace(), parent.getType(), parent.getParent().orElse(null));
        } else {
            MatcherAssert.assertThat((Object)expected.getParent().isPresent(), (Matcher)Is.is((Object)false));
        }
    }
}

