/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.runtime.route.Route;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.sdk.api.annotation.deprecated.Deprecated;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;

public class DeprecatedModelTestCase
extends AbstractMuleTestCase {
    @Test
    public void nonDeprecatedOperationTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "nonDeprecatedOperation");
        Assert.assertFalse((boolean)operationDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedOperationTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "deprecatedOperation");
        Assert.assertTrue((boolean)operationDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use nonDeprecatedOperation instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.2.0"));
        Assert.assertFalse((boolean)((DeprecationModel)operationDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void nonDeprecatedSourceTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        SourceDeclaration sourceDeclaration = (SourceDeclaration)this.getNamedDeclaration(extensionDeclaration.getMessageSources(), "NonDeprecatedSource");
        Assert.assertFalse((boolean)sourceDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedSourceTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        SourceDeclaration sourceDeclaration = (SourceDeclaration)this.getNamedDeclaration(extensionDeclaration.getMessageSources(), "DeprecatedSource");
        Assert.assertTrue((boolean)sourceDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)sourceDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use NonDeprecatedSource instead"));
        MatcherAssert.assertThat((Object)((DeprecationModel)sourceDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"2.4.0"));
        Assert.assertTrue((boolean)((DeprecationModel)sourceDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat(((DeprecationModel)sourceDeclaration.getDeprecation().get()).getToRemoveIn().get(), (Matcher)Matchers.is((Object)"3.0.0"));
    }

    @Test
    public void nonDeprecatedParameterTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "nonDeprecatedOperation");
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)this.getNamedDeclaration(operationDeclaration.getAllParameters(), "echo");
        Assert.assertFalse((boolean)parameterDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedParameterTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "nonDeprecatedOperation");
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)this.getNamedDeclaration(operationDeclaration.getAllParameters(), "badParameter");
        Assert.assertTrue((boolean)parameterDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)parameterDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"This parameter was made redundant"));
        MatcherAssert.assertThat((Object)((DeprecationModel)parameterDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.1.0"));
        Assert.assertFalse((boolean)((DeprecationModel)parameterDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void nonDeprecatedScopeTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "nonDeprecatedScope");
        Assert.assertFalse((boolean)operationDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedScopeTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "deprecatedScope");
        Assert.assertTrue((boolean)operationDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use nonDeprecatedScope instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.7.0"));
        Assert.assertFalse((boolean)((DeprecationModel)operationDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void nonDeprecatedRouterTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        ConstructDeclaration constructDeclaration = (ConstructDeclaration)this.getNamedDeclaration(extensionDeclaration.getConstructs(), "nonDeprecatedRouter");
        Assert.assertFalse((boolean)constructDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedRouterTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        ConstructDeclaration constructDeclaration = (ConstructDeclaration)this.getNamedDeclaration(extensionDeclaration.getConstructs(), "deprecatedRouter");
        Assert.assertTrue((boolean)constructDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)constructDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use nonDeprecatedRouter instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)constructDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.4.0"));
        Assert.assertTrue((boolean)((DeprecationModel)constructDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat(((DeprecationModel)constructDeclaration.getDeprecation().get()).getToRemoveIn().get(), (Matcher)Matchers.is((Object)"2.0.0"));
    }

    @Test
    public void nonDeprecatedFunctionTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getNamedDeclaration(extensionDeclaration.getFunctions(), "nonDeprecatedFunction");
        Assert.assertFalse((boolean)functionDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedFunctionTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getNamedDeclaration(extensionDeclaration.getFunctions(), "deprecatedFunction");
        Assert.assertTrue((boolean)functionDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)functionDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use nonDeprecatedFunction instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)functionDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.4.0"));
        Assert.assertFalse((boolean)((DeprecationModel)functionDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void nonDeprecatedExtensionTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(NonDeprecatedExtension.class);
        Assert.assertFalse((boolean)extensionDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedExtensionTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        Assert.assertTrue((boolean)extensionDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)extensionDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"This extension is deprecated"));
        MatcherAssert.assertThat((Object)((DeprecationModel)extensionDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.2.0"));
        Assert.assertFalse((boolean)((DeprecationModel)extensionDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void nonDeprecatedConfigurationTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(1);
        Assert.assertFalse((boolean)configurationDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedConfigurationTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        Assert.assertTrue((boolean)configurationDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)configurationDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"This configuration is deprecated."));
        MatcherAssert.assertThat((Object)((DeprecationModel)configurationDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.3.0"));
        Assert.assertFalse((boolean)((DeprecationModel)configurationDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void nonDeprecatedConnectionProviderTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(1);
        ConnectionProviderDeclaration connectionProviderDeclaration = (ConnectionProviderDeclaration)configurationDeclaration.getConnectionProviders().get(1);
        Assert.assertFalse((boolean)connectionProviderDeclaration.getDeprecation().isPresent());
    }

    @Test
    public void deprecatedConnectionProviderTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DeprecatedExtension.class);
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(1);
        ConnectionProviderDeclaration connectionProviderDeclaration = (ConnectionProviderDeclaration)configurationDeclaration.getConnectionProviders().get(0);
        Assert.assertTrue((boolean)connectionProviderDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"You should use the new connection provider"));
        MatcherAssert.assertThat((Object)((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.4.0"));
        Assert.assertTrue((boolean)((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat(((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getToRemoveIn().get(), (Matcher)Matchers.is((Object)"2.0.0"));
    }

    @Test
    public void sdkDeprecatedOperationTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "sdkDeprecatedOperation");
        Assert.assertTrue((boolean)operationDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use sdkNonDeprecatedOperation instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.2.0"));
        Assert.assertFalse((boolean)((DeprecationModel)operationDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void sdkDeprecatedSourceTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        SourceDeclaration sourceDeclaration = (SourceDeclaration)this.getNamedDeclaration(extensionDeclaration.getMessageSources(), "SdkDeprecatedSource");
        Assert.assertTrue((boolean)sourceDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)sourceDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use SdkNonDeprecatedSource instead"));
        MatcherAssert.assertThat((Object)((DeprecationModel)sourceDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"2.4.0"));
        Assert.assertTrue((boolean)((DeprecationModel)sourceDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat(((DeprecationModel)sourceDeclaration.getDeprecation().get()).getToRemoveIn().get(), (Matcher)Matchers.is((Object)"3.0.0"));
    }

    @Test
    public void sdkDeprecatedParameterTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "sdkNonDeprecatedOperation");
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)this.getNamedDeclaration(operationDeclaration.getAllParameters(), "badParameter");
        Assert.assertTrue((boolean)parameterDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)parameterDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"This parameter was made redundant"));
        MatcherAssert.assertThat((Object)((DeprecationModel)parameterDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.1.0"));
        Assert.assertFalse((boolean)((DeprecationModel)parameterDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void sdkDeprecatedScopeTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)this.getNamedDeclaration(extensionDeclaration.getOperations(), "sdkDeprecatedScope");
        Assert.assertTrue((boolean)operationDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use sdkNonDeprecatedScope instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)operationDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.7.0"));
        Assert.assertFalse((boolean)((DeprecationModel)operationDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void sdkDeprecatedRouterTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        ConstructDeclaration constructDeclaration = (ConstructDeclaration)this.getNamedDeclaration(extensionDeclaration.getConstructs(), "sdkDeprecatedRouter");
        Assert.assertTrue((boolean)constructDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)constructDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use sdkNonDeprecatedRouter instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)constructDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.4.0"));
        Assert.assertTrue((boolean)((DeprecationModel)constructDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat(((DeprecationModel)constructDeclaration.getDeprecation().get()).getToRemoveIn().get(), (Matcher)Matchers.is((Object)"2.0.0"));
    }

    @Test
    public void sdkDeprecatedFunctionTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getNamedDeclaration(extensionDeclaration.getFunctions(), "sdkDeprecatedFunction");
        Assert.assertTrue((boolean)functionDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)functionDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"Use sdkNonDeprecatedFunction instead."));
        MatcherAssert.assertThat((Object)((DeprecationModel)functionDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.4.0"));
        Assert.assertFalse((boolean)((DeprecationModel)functionDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void sdkDeprecatedExtensionTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        Assert.assertTrue((boolean)extensionDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)extensionDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"This extension is deprecated"));
        MatcherAssert.assertThat((Object)((DeprecationModel)extensionDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.2.0"));
        Assert.assertFalse((boolean)((DeprecationModel)extensionDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void sdkDeprecatedConfigurationTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        Assert.assertTrue((boolean)configurationDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)configurationDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"This configuration is deprecated."));
        MatcherAssert.assertThat((Object)((DeprecationModel)configurationDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.3.0"));
        Assert.assertFalse((boolean)((DeprecationModel)configurationDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void sdkDeprecatedConnectionProviderTestCase() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(SdkDeprecatedExtension.class);
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(1);
        ConnectionProviderDeclaration connectionProviderDeclaration = (ConnectionProviderDeclaration)configurationDeclaration.getConnectionProviders().get(0);
        Assert.assertTrue((boolean)connectionProviderDeclaration.getDeprecation().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getMessage(), (Matcher)Matchers.is((Object)"You should use the new connection provider"));
        MatcherAssert.assertThat((Object)((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.4.0"));
        Assert.assertTrue((boolean)((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat(((DeprecationModel)connectionProviderDeclaration.getDeprecation().get()).getToRemoveIn().get(), (Matcher)Matchers.is((Object)"2.0.0"));
    }

    private ExtensionDeclaration getExtensionDeclaration(Class<?> extensionClass) {
        return (ExtensionDeclaration)ExtensionDeclarationTestUtils.declarerFor(extensionClass, "1.0.0-dev").getDeclaration();
    }

    private NamedDeclaration getNamedDeclaration(List<? extends NamedDeclaration> namedDeclarationList, String name) {
        for (NamedDeclaration namedDeclaration : namedDeclarationList) {
            if (!namedDeclaration.getName().equals(name)) continue;
            return namedDeclaration;
        }
        Assert.fail((String)("No namedDeclaration with name " + name + " was found in list."));
        return null;
    }

    @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="Use SdkNonDeprecatedSource instead", since="2.4.0", toRemoveIn="3.0.0")
    public static class SdkDeprecatedSource
    extends Source<String, String> {
        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public static class SdkDeprecatedExtensionFunctions {
        @Deprecated(message="Use sdkNonDeprecatedFunction instead.", since="1.4.0")
        public String sdkDeprecatedFunction(String echo) {
            return echo;
        }

        public String sdkNonDeprecatedFunction(String echo, @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="This parameter was made redundant", since="1.8.0") String badParameter) {
            return echo;
        }
    }

    public static class SdkDeprecatedExtensionOperations {
        @Deprecated(message="Use sdkNonDeprecatedOperation instead.", since="1.2.0")
        public String sdkDeprecatedOperation(String echo) {
            return echo;
        }

        public String sdkNonDeprecatedOperation(String echo, @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="This parameter was made redundant", since="1.1.0") String badParameter) {
            return echo;
        }

        @Deprecated(message="Use sdkNonDeprecatedScope instead.", since="1.7.0")
        public void sdkDeprecatedScope(Chain chain, CompletionCallback<Void, Void> cb) {
        }

        public void sdkNonDeprecatedScope(Chain chain, CompletionCallback<Void, Void> cb) {
        }

        @Deprecated(message="Use sdkNonDeprecatedRouter instead.", since="1.4.0", toRemoveIn="2.0.0")
        public void sdkDeprecatedRouter(Route route, RouterCompletionCallback callback) {
        }

        public void sdkNonDeprecatedRouter(Route route, RouterCompletionCallback callback) {
        }
    }

    @Deprecated(message="You should use the new connection provider", since="1.4.0", toRemoveIn="2.0.0")
    public static class SdkDeprecatedConnectionProvider
    implements ConnectionProvider<Connection> {
        public Connection connect() throws ConnectionException {
            return new Connection("Your house");
        }

        public void disconnect(Connection connection) {
        }

        public ConnectionValidationResult validate(Connection connection) {
            return null;
        }
    }

    @Configuration
    @Sources(value={SdkDeprecatedSource.class})
    @ConnectionProviders(value={SdkDeprecatedConnectionProvider.class, NonDeprecatedConnectionProvider.class})
    public static class SdkNonDeprecatedConfiguration {
    }

    @Configuration
    @Sources(value={NonDeprecatedSource.class})
    @Operations(value={SdkDeprecatedExtensionOperations.class})
    @Deprecated(message="This configuration is deprecated.", since="1.3.0")
    public static class SdkDeprecatedConfiguration {
    }

    @Deprecated(message="This extension is deprecated", since="1.2.0")
    @Extension(name="Deprecated")
    @ExpressionFunctions(value={SdkDeprecatedExtensionFunctions.class})
    @Configurations(value={SdkDeprecatedConfiguration.class, SdkNonDeprecatedConfiguration.class})
    public static class SdkDeprecatedExtension {
    }

    @Extension(name="Not Deprecated")
    public static class NonDeprecatedExtension {
    }

    public static class NonDeprecatedSource
    extends Source<String, String> {
        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="Use NonDeprecatedSource instead", since="2.4.0", toRemoveIn="3.0.0")
    public static class DeprecatedSource
    extends Source<String, String> {
        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public static class DeprecatedExtensionFunctions {
        @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="Use nonDeprecatedFunction instead.", since="1.4.0")
        public String deprecatedFunction(String echo) {
            return echo;
        }

        public String nonDeprecatedFunction(String echo, @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="This parameter was made redundant", since="1.8.0") String badParameter) {
            return echo;
        }
    }

    public static class DeprecatedExtensionOperations {
        @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="Use nonDeprecatedOperation instead.", since="1.2.0")
        public String deprecatedOperation(String echo) {
            return echo;
        }

        public String nonDeprecatedOperation(String echo, @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="This parameter was made redundant", since="1.1.0") String badParameter) {
            return echo;
        }

        @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="Use nonDeprecatedScope instead.", since="1.7.0")
        public void deprecatedScope(Chain chain, CompletionCallback<Void, Void> cb) {
        }

        public void nonDeprecatedScope(Chain chain, CompletionCallback<Void, Void> cb) {
        }

        @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="Use nonDeprecatedRouter instead.", since="1.4.0", toRemoveIn="2.0.0")
        public void deprecatedRouter(Route route, RouterCompletionCallback callback) {
        }

        public void nonDeprecatedRouter(Route route, RouterCompletionCallback callback) {
        }
    }

    public static class Connection {
        private String address;

        public Connection(String address) {
            this.address = address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }
    }

    public static class NonDeprecatedConnectionProvider
    implements ConnectionProvider<Connection> {
        public Connection connect() throws ConnectionException {
            return new Connection("Your new house");
        }

        public void disconnect(Connection connection) {
        }

        public ConnectionValidationResult validate(Connection connection) {
            return null;
        }
    }

    @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="You should use the new connection provider", since="1.4.0", toRemoveIn="2.0.0")
    public static class DeprecatedConnectionProvider
    implements ConnectionProvider<Connection> {
        public Connection connect() throws ConnectionException {
            return new Connection("Your house");
        }

        public void disconnect(Connection connection) {
        }

        public ConnectionValidationResult validate(Connection connection) {
            return null;
        }
    }

    @Configuration
    @Sources(value={DeprecatedSource.class})
    @ConnectionProviders(value={DeprecatedConnectionProvider.class, NonDeprecatedConnectionProvider.class})
    public static class NonDeprecatedConfiguration {
    }

    @Configuration
    @Sources(value={NonDeprecatedSource.class})
    @Operations(value={DeprecatedExtensionOperations.class})
    @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="This configuration is deprecated.", since="1.3.0")
    public static class DeprecatedConfiguration {
    }

    @org.mule.runtime.extension.api.annotation.deprecated.Deprecated(message="This extension is deprecated", since="1.2.0")
    @Extension(name="Deprecated")
    @ExpressionFunctions(value={DeprecatedExtensionFunctions.class})
    @Configurations(value={DeprecatedConfiguration.class, NonDeprecatedConfiguration.class})
    public static class DeprecatedExtension {
    }
}

