/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;

public class DisplayModelTestCase
extends AbstractMuleTestCase {
    private static final String PARAMETER_GROUP_DISPLAY_NAME = "Date of decease";
    private static final String PARAMETER_GROUP_ORIGINAL_DISPLAY_NAME = "dateOfDeath";
    private ExtensionDeclarer heisenbergDeclarer;
    private ExtensionDeclarer marvelDeclarer;

    @Before
    public void setUp() {
        String version = MuleManifest.getProductVersion();
        this.heisenbergDeclarer = ExtensionDeclarationTestUtils.declarerFor(HeisenbergExtension.class, version);
        this.marvelDeclarer = ExtensionDeclarationTestUtils.declarerFor(MarvelExtension.class, version);
    }

    @Test
    public void parseDisplayAnnotationsOnParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterDisplayName(this.findParameter(parameters, "weaponValueMap"), "Parameter Custom Display Name");
    }

    @Test
    public void parseDisplayNameAnnotationOnParameterGroup() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterDisplayName(this.findParameter(parameters, PARAMETER_GROUP_ORIGINAL_DISPLAY_NAME), PARAMETER_GROUP_DISPLAY_NAME);
    }

    @Test
    public void parseDisplayNameAnnotationOnOperationParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "resolverEcho");
        MatcherAssert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List parameters = operation.getAllParameters();
        this.assertParameterDisplayName(this.findParameter(parameters, "literalExpression"), "Custom overrided display name");
    }

    @Test
    public void parseSummaryAnnotationOnConfigParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterSummary(this.findParameter(parameters, "ricinPacks"), "A set of ricin packs");
    }

    @Test
    public void parseSummaryAnnotationOnOperationParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "knockMany");
        MatcherAssert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List parameters = operation.getAllParameters();
        this.assertParameterSummary(this.findParameter(parameters, "doors"), "List of Knockeable Doors");
    }

    @Test
    public void parseExampleAnnotationOnConfigParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterExample(this.findParameter(parameters, "labAddress"), "308 Negra Arroyo Lane, Albuquerque, New Mexico, 87104");
    }

    @Test
    public void parseExampleAnnotationOnOperationParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.heisenbergDeclarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "alias");
        MatcherAssert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List parameters = operation.getAllParameters();
        this.assertParameterExample(this.findParameter(parameters, "greeting"), "Hello my friend!");
    }

    @Test
    public void parseClassParameterInOperation() {
        ExtensionDeclaration declaration = (ExtensionDeclaration)this.marvelDeclarer.getDeclaration();
        OperationDeclaration findInstructionsOperation = this.getOperation((WithOperationsDeclaration)declaration, "findInstructions");
        List params = findInstructionsOperation.getAllParameters();
        MatcherAssert.assertThat((Object)params, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterDeclaration pathParam = (ParameterDeclaration)params.get(1);
        Optional classValueModel = pathParam.getDisplayModel().getClassValueModel();
        MatcherAssert.assertThat((Object)classValueModel.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ClassValueModel)classValueModel.get()).getAssignableFrom(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(((ClassValueModel)classValueModel.get()).getAssignableFrom().get(0), (Matcher)CoreMatchers.equalTo((Object)"com.starkindustries.Reader"));
    }

    @Test
    public void parsePathParameterWithFileExtensions() {
        ExtensionDeclaration declaration = (ExtensionDeclaration)this.marvelDeclarer.getDeclaration();
        OperationDeclaration findInstructionsOperation = this.getOperation((WithOperationsDeclaration)declaration, "findInstructions");
        List params = findInstructionsOperation.getAllParameters();
        MatcherAssert.assertThat((Object)params, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterDeclaration pathParam = (ParameterDeclaration)params.get(0);
        Optional pathModel = pathParam.getDisplayModel().getPathModel();
        MatcherAssert.assertThat((Object)pathModel.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).getType(), (Matcher)CoreMatchers.is((Object)PathModel.Type.ANY));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).acceptsUrls(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).getFileExtensions(), (Matcher)CoreMatchers.hasItem((Object)"xml"));
    }

    @Test
    public void parsePathParameterThatIsDirectory() {
        ExtensionDeclaration declaration = (ExtensionDeclaration)this.marvelDeclarer.getDeclaration();
        ConfigurationDeclaration config = this.findConfigByName(declaration, "ironMan");
        ConnectionProviderDeclaration missileProvider = this.findProviderByName((ConnectedDeclaration<?>)config, "missile");
        List params = missileProvider.getAllParameters();
        MatcherAssert.assertThat((Object)params, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ParameterDeclaration pathParam = (ParameterDeclaration)params.get(0);
        Optional pathModel = pathParam.getDisplayModel().getPathModel();
        MatcherAssert.assertThat((Object)pathModel.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).getType(), (Matcher)CoreMatchers.is((Object)PathModel.Type.DIRECTORY));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).acceptsUrls(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).getFileExtensions(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void parseSimplePathParameter() {
        ExtensionDeclaration declaration = (ExtensionDeclaration)this.marvelDeclarer.getDeclaration();
        ConfigurationDeclaration config = this.findConfigByName(declaration, "ironMan");
        List params = config.getAllParameters();
        MatcherAssert.assertThat((Object)params, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterDeclaration pathParam = (ParameterDeclaration)params.get(0);
        Optional pathModel = pathParam.getDisplayModel().getPathModel();
        MatcherAssert.assertThat((Object)pathModel.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).getType(), (Matcher)CoreMatchers.is((Object)PathModel.Type.ANY));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).acceptsUrls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PathModel)pathModel.get()).getFileExtensions(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void parseClassParameter() {
        ExtensionDeclaration declaration = (ExtensionDeclaration)this.marvelDeclarer.getDeclaration();
        ConfigurationDeclaration config = this.findConfigByName(declaration, "ironMan");
        List params = config.getAllParameters();
        MatcherAssert.assertThat((Object)params, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterDeclaration pathParam = (ParameterDeclaration)params.get(1);
        Optional classValueModel = pathParam.getDisplayModel().getClassValueModel();
        MatcherAssert.assertThat((Object)classValueModel.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ClassValueModel)classValueModel.get()).getAssignableFrom(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(((ClassValueModel)classValueModel.get()).getAssignableFrom().get(0), (Matcher)CoreMatchers.equalTo((Object)"com.starkindustries.AIEngine"));
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void parseLegacyAndSdkDisplayNameAnnotationsOnParameter() {
        ExtensionDeclarationTestUtils.declarerFor(ExtensionWithInvalidUseOfDisplayNameAnnotation.class, "1.0.0-dev");
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void parseLegacyAndSdkExampleAnnotationsOnParameter() {
        ExtensionDeclarationTestUtils.declarerFor(ExtensionWithInvalidUseOfExampleAnnotation.class, "1.0.0-dev");
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void parseLegacyAndSdkSummaryAnnotationsOnParameter() {
        ExtensionDeclarationTestUtils.declarerFor(ExtensionWithInvalidUseOfSummaryAnnotation.class, "1.0.0-dev");
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void parseLegacyAndSdkClassValueAnnotationsOnParameter() {
        ExtensionDeclarationTestUtils.declarerFor(ExtensionWithInvalidUseOfClassValueAnnotation.class, "1.0.0-dev");
    }

    @Test
    public void parseConfigurationWithDisplayName() {
        ExtensionDeclarer extensionDeclarer = ExtensionDeclarationTestUtils.declarerFor(ExtensionWithConfigWithDisplayName.class, "1.0.0-dev");
        ConfigurationDeclaration configurationDeclaration = this.findConfigByName((ExtensionDeclaration)extensionDeclarer.getDeclaration(), "configurationWithDisplayName");
        MatcherAssert.assertThat((Object)configurationDeclaration.getDisplayModel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)configurationDeclaration.getDisplayModel().getDisplayName(), (Matcher)CoreMatchers.is((Object)"Config display name"));
    }

    private ConfigurationDeclaration findConfigByName(ExtensionDeclaration declaration, String name) {
        return declaration.getConfigurations().stream().filter(c -> c.getName().equals(name)).findAny().get();
    }

    private ConnectionProviderDeclaration findProviderByName(ConnectedDeclaration<?> declaration, String name) {
        return declaration.getConnectionProviders().stream().filter(c -> c.getName().equals(name)).findAny().get();
    }

    private void assertParameterDisplayName(ParameterDeclaration param, String displayName) {
        DisplayModel display = param.getDisplayModel();
        MatcherAssert.assertThat((Object)display.getDisplayName(), (Matcher)CoreMatchers.is((Object)displayName));
    }

    private void assertParameterSummary(ParameterDeclaration param, String summary) {
        DisplayModel display = param.getDisplayModel();
        MatcherAssert.assertThat((Object)display.getSummary(), (Matcher)CoreMatchers.is((Object)summary));
    }

    private void assertParameterExample(ParameterDeclaration param, String example) {
        DisplayModel display = param.getDisplayModel();
        MatcherAssert.assertThat((Object)display.getExample(), (Matcher)CoreMatchers.is((Object)example));
    }

    private OperationDeclaration getOperation(WithOperationsDeclaration declaration, String operationName) {
        List operations = declaration.getOperations();
        return operations.stream().filter(operation -> operation.getName().equals(operationName)).findAny().orElse(null);
    }

    private ParameterDeclaration findParameter(List<ParameterDeclaration> parameters, String name) {
        return parameters.stream().filter(param -> param.getName().equals(name)).findAny().orElse(null);
    }

    @Configuration(name="configurationWithDisplayName")
    @org.mule.runtime.extension.api.annotation.param.display.DisplayName(value="Config display name")
    public static class ConfigurationWithDisplayName {
    }

    @Extension(name="extensionWithConfigWithDisplayName")
    @Configurations(value={ConfigurationWithDisplayName.class})
    public static class ExtensionWithConfigWithDisplayName {
    }

    @Extension(name="extensionWithInvalidUseOfClassValueAnnotation")
    public static class ExtensionWithInvalidUseOfClassValueAnnotation {
        @Parameter
        @ClassValue
        @org.mule.sdk.api.annotation.param.display.ClassValue
        public String firstParameter;
    }

    @Extension(name="extensionWithInvalidUseOfSummaryAnnotation")
    public static class ExtensionWithInvalidUseOfSummaryAnnotation {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.display.Summary(value="This is a test parameter")
        @Summary(value="This is a test parameter")
        public String firstParameter;
    }

    @Extension(name="extensionWithInvalidUseOfExampleAnnotation")
    public static class ExtensionWithInvalidUseOfExampleAnnotation {
        @Parameter
        @Example(value="parameter")
        @org.mule.sdk.api.annotation.param.display.Example(value="parameter")
        public String firstParameter;
    }

    @Extension(name="extensionWithInvalidUseOfDisplayNameAnnotation")
    public static class ExtensionWithInvalidUseOfDisplayNameAnnotation {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.display.DisplayName(value="niceFirstParameter")
        @DisplayName(value="niceFirstParameter")
        public String firstParameter;
    }
}

