/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultBinaryType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.test.metadata.extension.MetadataExtension;

public class ExtensionWithCustomStaticTypesTestCase
extends AbstractMuleTestCase {
    private static final String PERSON_TYPE_ID = "http://example.com/example.json";
    private static final String PERSONS_TYPE_ID = "http://example.com/persons.json";
    private ExtensionModel extension = MuleExtensionUtils.loadExtension(MetadataExtension.class);

    @Test
    public void withInputXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlInput");
        ParameterModel param = (ParameterModel)o.getAllParameterModels().get(0);
        this.assertXmlOrder((Typed)param);
    }

    @Test
    public void withOutputXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlOutput");
        this.assertXmlOrder((Typed)o.getOutput());
    }

    @Test
    public void withOutputXmlStaticTypeSchemaWithImport() throws Exception {
        OperationModel o = this.getOperation("xmlOutputSchemaWithImport");
        this.assertXmlOrder((Typed)o.getOutput());
    }

    @Test
    public void withListOutputXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlOutputList");
        MetadataType type = o.getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MetadataType innerType = ((ArrayType)type).getType();
        MatcherAssert.assertThat((Object)innerType.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.XML));
        MatcherAssert.assertThat((Object)innerType.toString(), (Matcher)CoreMatchers.is((Object)"#root:shiporder"));
    }

    @Test
    public void withListOutputAndEmptySchemaXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlOutputListWithEmptySchema");
        MetadataType type = o.getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MetadataType innerType = ((ArrayType)type).getType();
        MatcherAssert.assertThat((Object)innerType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(DefaultBinaryType.class)));
    }

    @Test
    public void withOutputAttributesXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlAttributes");
        this.assertXmlOrder((Typed)o.getOutputAttributes());
    }

    @Test
    public void withInputJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonInputStream");
        ParameterModel param = (ParameterModel)o.getAllParameterModels().get(0);
        this.assertJsonPerson((Typed)param);
    }

    @Test
    public void withInputJsonMapType() throws Exception {
        OperationModel o = this.getOperation("jsonInputMap");
        MetadataType type = ((ParameterModel)o.getAllParameterModels().get(0)).getType();
        this.assertJsonPerson(type);
    }

    @Test
    public void withInputJsonListType() throws Exception {
        OperationModel o = this.getOperation("jsonInputList");
        MetadataType type = ((ParameterModel)o.getAllParameterModels().get(0)).getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertJsonPerson(((ArrayType)type).getType());
    }

    @Test
    public void withOutputJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonOutput");
        this.assertJsonPerson((Typed)o.getOutput());
    }

    @Test
    public void withArrayOutputJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonOutputArray");
        MetadataType type = o.getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)type).get(), (Matcher)CoreMatchers.equalTo((Object)PERSONS_TYPE_ID));
        this.assertJsonPerson(((ArrayType)type).getType());
    }

    @Test
    public void withOutputJsonTypeList() throws Exception {
        OperationModel o = this.getOperation("jsonOutputList");
        MetadataType type = o.getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertJsonPerson(((ArrayType)type).getType());
    }

    @Test
    public void withOutputJsonTypePagingProvider() throws Exception {
        OperationModel o = this.getOperationFromDefaultConfig("jsonOutputPagingProvider");
        MetadataType type = o.getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertJsonPerson(((ArrayType)type).getType());
    }

    @Test
    public void withOutputJsonArrayTypeList() throws Exception {
        OperationModel o = this.getOperation("jsonArrayOutputList");
        MetadataType type = o.getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MetadataType innerType = ((ArrayType)type).getType();
        MatcherAssert.assertThat((Object)innerType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)innerType).get(), (Matcher)CoreMatchers.equalTo((Object)PERSONS_TYPE_ID));
        this.assertJsonPerson(((ArrayType)innerType).getType());
    }

    @Test
    public void withOutputAttributesJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonAttributes");
        this.assertJsonPerson((Typed)o.getOutputAttributes());
    }

    @Test
    public void withOutputAttributesJsonArrayType() throws Exception {
        OperationModel o = this.getOperation("jsonArrayAttributes");
        MetadataType type = o.getOutputAttributes().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)type).get(), (Matcher)CoreMatchers.equalTo((Object)PERSONS_TYPE_ID));
        this.assertJsonPerson(((ArrayType)type).getType());
    }

    @Test
    public void withOutputAttributesJsonTypeList() throws Exception {
        OperationModel o = this.getOperation("jsonAttributesList");
        MetadataType type = o.getOutputAttributes().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertJsonPerson(((ArrayType)type).getType());
    }

    @Test
    public void withOutputAttributesJsonArrayTypeList() throws Exception {
        OperationModel o = this.getOperation("jsonArrayAttributesList");
        MetadataType type = o.getOutputAttributes().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MetadataType innerType = ((ArrayType)type).getType();
        MatcherAssert.assertThat((Object)innerType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)innerType).get(), (Matcher)CoreMatchers.equalTo((Object)PERSONS_TYPE_ID));
        this.assertJsonPerson(((ArrayType)innerType).getType());
    }

    @Test
    public void withOutputAttributesJsonTypePagingProviderWithResult() throws Exception {
        OperationModel o = this.getOperationFromDefaultConfig("jsonAttributesPagingProviderWithResult");
        this.assertJsonPerson(o.getOutputAttributes().getType());
    }

    @Test
    public void customTypeOutput() throws Exception {
        OperationModel o = this.getOperation("customTypeOutput");
        OutputModel output = o.getOutput();
        MetadataType type = output.getType();
        MatcherAssert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.CSV));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"csv-object"));
    }

    @Test
    public void customTypeListOutput() throws Exception {
        OperationModel o = this.getOperation("customTypeListOutput");
        OutputModel output = o.getOutput();
        MetadataType type = output.getType();
        MatcherAssert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.CSV));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"csv-object"));
    }

    @Test
    public void customTypeInput() throws Exception {
        OperationModel o = this.getOperation("customTypeInput");
        ParameterModel param = (ParameterModel)o.getAllParameterModels().get(0);
        this.assertCustomJsonType((Typed)param);
    }

    @Test
    public void customTypeAttributes() throws Exception {
        OperationModel o = this.getOperation("customAttributesOutput");
        this.assertCustomJsonType((Typed)o.getOutputAttributes());
    }

    @Test
    public void customTypeInputAndOutput() throws Exception {
        OperationModel o = this.getOperation("customInputAndOutput");
        this.assertCustomJsonType((Typed)o.getAllParameterModels().get(0));
        this.assertCustomJavaType((Typed)o.getOutput());
    }

    @Test
    public void customTypeOutputWithStaticAttributes() throws Exception {
        OperationModel o = this.getOperation("customTypeOutputWithStaticAttributes");
        this.assertJsonPerson((Typed)o.getOutput());
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)o.getOutputAttributes().getType()).get(), (Matcher)CoreMatchers.is((Object)Banana.class.getName()));
    }

    @Test
    public void sourceXmlOutput() {
        SourceModel s = this.getSource("xml-static-metadata");
        this.assertXmlOrder((Typed)s.getOutput());
        this.assertXmlOrder((Typed)s.getOutputAttributes());
    }

    @Test
    public void sourceCustomOutput() {
        SourceModel s = this.getSource("custom-static-metadata");
        this.assertCustomJavaType((Typed)s.getOutput());
    }

    @Test
    public void sourceOnErrorCustomType() {
        SourceModel s = this.getSource("custom-static-metadata");
        this.assertJsonPerson((Typed)((SourceCallbackModel)s.getErrorCallback().get()).getAllParameterModels().get(0));
    }

    @Test
    public void sourceOnSuccessCustomType() {
        SourceModel s = this.getSource("custom-static-metadata");
        this.assertXmlOrder((Typed)((SourceCallbackModel)s.getSuccessCallback().get()).getAllParameterModels().get(0));
    }

    private SourceModel getSource(String name) {
        return (SourceModel)this.extension.getSourceModel(name).orElseThrow(() -> new RuntimeException("Source Not found"));
    }

    private void assertCustomJavaType(Typed t) {
        MatcherAssert.assertThat((Object)t.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)t.getType().getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)((TypeIdAnnotation)t.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)"custom-java"));
        MatcherAssert.assertThat((Object)t.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    private void assertXmlOrder(Typed typed) {
        MetadataType type = typed.getType();
        MatcherAssert.assertThat((Object)typed.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.XML));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"#root:shiporder"));
        Object[] typeFields = ((DefaultObjectType)type).getFields().toArray();
        DefaultObjectFieldType fieldOrder = (DefaultObjectFieldType)typeFields[0];
        DefaultObjectType order = (DefaultObjectType)fieldOrder.getValue();
        MatcherAssert.assertThat((Object)order.getFields().toArray().length, (Matcher)CoreMatchers.is((Object)3));
        DefaultObjectFieldType fieldPerson = (DefaultObjectFieldType)order.getFieldByName("orderperson").get();
        MatcherAssert.assertThat((Object)fieldPerson.getValue(), (Matcher)CoreMatchers.instanceOf(DefaultStringType.class));
        DefaultObjectFieldType fieldShipTo = (DefaultObjectFieldType)order.getFieldByName("shipto").get();
        DefaultObjectType shipTo = (DefaultObjectType)fieldShipTo.getValue();
        MatcherAssert.assertThat((Object)shipTo.getFields().toArray().length, (Matcher)CoreMatchers.is((Object)4));
        DefaultObjectFieldType fieldItem = (DefaultObjectFieldType)order.getFieldByName("item").get();
        DefaultObjectType item = (DefaultObjectType)fieldItem.getValue();
        MatcherAssert.assertThat((Object)item.getFields().toArray().length, (Matcher)CoreMatchers.is((Object)4));
    }

    private void assertJsonPerson(Typed typed) {
        this.assertJsonPerson(typed.getType());
        MatcherAssert.assertThat((Object)typed.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertJsonPerson(MetadataType type) {
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)type).get(), (Matcher)CoreMatchers.equalTo((Object)PERSON_TYPE_ID));
        MatcherAssert.assertThat((Object)((ObjectType)type).getFields(), (Matcher)Matchers.hasSize((int)3));
    }

    private OperationModel getOperation(String ope) {
        return (OperationModel)this.extension.getOperationModel(ope).orElseThrow(() -> new RuntimeException(ope + " not found"));
    }

    private OperationModel getOperationFromDefaultConfig(String ope) {
        return (OperationModel)((ConfigurationModel)this.extension.getConfigurationModel("config").get()).getOperationModel(ope).orElseThrow(() -> new RuntimeException(ope + " not found"));
    }

    private void assertCustomJsonType(Typed typed) {
        MetadataType type = typed.getType();
        MatcherAssert.assertThat((Object)typed.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"json-object"));
    }
}

