/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.oauth.TestOAuthExtension;

@SmallTest
public class OAuthConnectionProviderModelLoaderTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    private ExtensionDeclaration extensionDeclaration;

    @Before
    public void setUp() {
        this.setDeclarer(this.declarerFor(TestOAuthExtension.class));
        this.extensionDeclaration = (ExtensionDeclaration)this.declareExtension().getDeclaration();
    }

    @Test
    public void credentialsPlacementSettingForAuthorizationCodeIsLoaded() {
        ConfigurationDeclaration configuration = this.getConfiguration(this.extensionDeclaration, "auth-code");
        ConnectionProviderDeclaration connectionProviderDeclaration = ExtensionsTestUtils.findConnectionProvider(configuration, "with-credentials-placement");
        AuthorizationCodeGrantType authorizationCodeGrantType = this.getAuthorizationCodeGrantType(connectionProviderDeclaration);
        Assert.assertThat((Object)authorizationCodeGrantType.getCredentialsPlacement(), (Matcher)CoreMatchers.is((Object)CredentialsPlacement.BASIC_AUTH_HEADER));
    }

    @Test
    public void credentialsPlacementDefaultForAuthorizationCodeIsLoaded() {
        ConfigurationDeclaration configuration = this.getConfiguration(this.extensionDeclaration, "auth-code");
        ConnectionProviderDeclaration connectionProviderDeclaration = ExtensionsTestUtils.findConnectionProvider(configuration, "scopeless");
        AuthorizationCodeGrantType authorizationCodeGrantType = this.getAuthorizationCodeGrantType(connectionProviderDeclaration);
        Assert.assertThat((Object)authorizationCodeGrantType.getCredentialsPlacement(), (Matcher)CoreMatchers.is((Object)CredentialsPlacement.BODY));
    }

    @Test
    public void includeRedirectUriInRefreshTokenRequestSettingForAuthorizationCodeIsLoaded() {
        ConfigurationDeclaration configuration = this.getConfiguration(this.extensionDeclaration, "auth-code");
        ConnectionProviderDeclaration connectionProviderDeclaration = ExtensionsTestUtils.findConnectionProvider(configuration, "do-not-include-redirect-uri-in-refresh-token");
        AuthorizationCodeGrantType authorizationCodeGrantType = this.getAuthorizationCodeGrantType(connectionProviderDeclaration);
        Assert.assertThat((Object)authorizationCodeGrantType.includeRedirectUriInRefreshTokenRequest(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void includeRedirectUriInRefreshTokenRequestDefaultForAuthorizationCodeIsLoaded() {
        ConfigurationDeclaration configuration = this.getConfiguration(this.extensionDeclaration, "auth-code");
        ConnectionProviderDeclaration connectionProviderDeclaration = ExtensionsTestUtils.findConnectionProvider(configuration, "scopeless");
        AuthorizationCodeGrantType authorizationCodeGrantType = this.getAuthorizationCodeGrantType(connectionProviderDeclaration);
        Assert.assertThat((Object)authorizationCodeGrantType.includeRedirectUriInRefreshTokenRequest(), (Matcher)CoreMatchers.is((Object)true));
    }

    private AuthorizationCodeGrantType getAuthorizationCodeGrantType(ConnectionProviderDeclaration connectionProviderDeclaration) {
        Optional oAuthModelProperty = connectionProviderDeclaration.getModelProperty(OAuthModelProperty.class);
        Assert.assertThat((Object)oAuthModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        List grantTypes = ((OAuthModelProperty)oAuthModelProperty.get()).getGrantTypes();
        Assert.assertThat((Object)grantTypes.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(grantTypes.get(0), (Matcher)CoreMatchers.instanceOf(AuthorizationCodeGrantType.class));
        return (AuthorizationCodeGrantType)grantTypes.get(0);
    }
}

