/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithDeclaringClass;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;

@SmallTest
public class SubTypesJavaModelLoaderTestCase
extends AbstractMuleTestCase {
    private static final String BASE_TYPE_ID = BaseType.class.getName();
    private static final String SUBTYPE_ID = SubType.class.getName();
    private static final String VERSION = "1.0.0";
    private ExtensionDeclarer pluginDeclarer;
    private ObjectType baseMetadataType;
    private ObjectType subMetadataType;
    private AnnotationValueFetcher<SubTypeMapping> typeMapping;
    private ExtensionLoadingContext pluginCtx;
    private TypeCatalog typeCatalog;

    @Before
    public void before() {
        this.pluginDeclarer = (ExtensionDeclarer)Mockito.spy((Object)new ExtensionDeclarer());
        ExtensionElement extensionElement = (ExtensionElement)Mockito.mock(ExtensionElement.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)extensionElement.getName()).thenReturn((Object)"LoaderTest");
        Mockito.when((Object)extensionElement.getConfigurations()).thenReturn(Collections.emptyList());
        Mockito.when((Object)extensionElement.getConnectionProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)extensionElement.getSources()).thenReturn(Collections.emptyList());
        Mockito.when((Object)extensionElement.getOperations()).thenReturn(Collections.emptyList());
        Mockito.when((Object)extensionElement.getOperationContainers()).thenReturn(Collections.emptyList());
        Mockito.when((Object)extensionElement.getFunctionContainers()).thenReturn(Collections.emptyList());
        Mockito.when((Object)extensionElement.getFunctions()).thenReturn(Collections.emptyList());
        this.baseMetadataType = this.createMetadataType(BASE_TYPE_ID);
        this.subMetadataType = this.createMetadataType(SUBTYPE_ID);
        this.typeMapping = (AnnotationValueFetcher)Mockito.mock(AnnotationValueFetcher.class);
        Mockito.when((Object)extensionElement.getValueFromAnnotation(SubTypeMapping.class)).thenReturn(Optional.of(this.typeMapping));
        this.pluginDeclarer.withModelProperty((ModelProperty)new ExtensionTypeDescriptorModelProperty((Type)extensionElement));
        this.typeCatalog = (TypeCatalog)Mockito.mock(TypeCatalog.class);
        DslResolvingContext dslResolvingCtx = (DslResolvingContext)Mockito.mock(DslResolvingContext.class);
        Mockito.when((Object)dslResolvingCtx.getTypeCatalog()).thenReturn((Object)this.typeCatalog);
        this.pluginCtx = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        Mockito.when((Object)this.pluginCtx.getExtensionDeclarer()).thenReturn((Object)this.pluginDeclarer);
        Mockito.when((Object)this.pluginCtx.getDslResolvingContext()).thenReturn((Object)dslResolvingCtx);
        Mockito.when((Object)this.pluginCtx.getExtensionClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
    }

    @Test
    @Issue(value="MULE-18581")
    @Description(value="Simulate the scenario of different plugins declaring subtypes from an underlying lib (Plugin A depends on lib X, plugin B also depends ob lib X), assert that the types from the lib are NOT imported, since they live twice, on each plugin classloader.")
    public void noImportForSubtypesFromLocalLib() throws ClassNotFoundException {
        Type baseAType = this.createType((MetadataType)this.baseMetadataType, BaseType.class);
        Type subAType = this.createType((MetadataType)this.subMetadataType, SubType.class);
        Mockito.when((Object)this.typeMapping.getClassValue((Function)ArgumentMatchers.any())).thenReturn((Object)baseAType);
        Mockito.when((Object)this.typeMapping.getClassArrayValue((Function)ArgumentMatchers.any())).thenReturn(Arrays.asList(subAType));
        Mockito.when((Object)this.typeCatalog.getType((String)ArgumentMatchers.any())).thenReturn(Optional.empty());
        ExtensionDeclarationTestUtils.javaDeclarerFor(VERSION, this.pluginCtx);
        ((ExtensionDeclarer)Mockito.verify((Object)this.pluginDeclarer, (VerificationMode)Mockito.never())).withImportedType((ImportedTypeModel)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="MULE-18581")
    @Description(value="Simulate the scenario of a plugins declaring subtypes from another plugin (Plugin A depends on plugin B), assert that the types from the plugin B are marked as imported on plugin A.")
    public void importForSubtypesFromOtherPlugin() throws ClassNotFoundException {
        Type baseAType = this.createType((MetadataType)this.baseMetadataType, BaseType.class);
        Type subAType = this.createType((MetadataType)this.subMetadataType, SubType.class);
        Mockito.when((Object)this.pluginCtx.getExtensionClassLoader()).thenReturn(Mockito.mock(ClassLoader.class));
        Mockito.when((Object)this.typeMapping.getClassValue((Function)ArgumentMatchers.any())).thenReturn((Object)baseAType);
        Mockito.when((Object)this.typeMapping.getClassArrayValue((Function)ArgumentMatchers.any())).thenReturn(Arrays.asList(subAType));
        Mockito.when((Object)this.typeCatalog.getType(BASE_TYPE_ID)).thenReturn(Optional.of(this.baseMetadataType));
        Mockito.when((Object)this.typeCatalog.getType(SUBTYPE_ID)).thenReturn(Optional.of(this.subMetadataType));
        ExtensionDeclarationTestUtils.javaDeclarerFor(VERSION, this.pluginCtx);
        ((ExtensionDeclarer)Mockito.verify((Object)this.pluginDeclarer, (VerificationMode)Mockito.times((int)2))).withImportedType((ImportedTypeModel)ArgumentMatchers.any());
    }

    private Type createType(MetadataType metadataType, Class declaringClass) {
        Type type = (Type)Mockito.mock(Type.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{WithDeclaringClass.class}));
        Mockito.when((Object)type.asMetadataType()).thenReturn((Object)metadataType);
        Mockito.when((Object)type.getDeclaringClass()).thenReturn(Optional.of(declaringClass));
        return type;
    }

    private ObjectType createMetadataType(String typeId) {
        ObjectType metadataType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)metadataType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation(typeId)));
        ((ObjectType)Mockito.doAnswer(inv -> {
            MetadataTypeVisitor visitor = (MetadataTypeVisitor)inv.getArgument(0);
            visitor.visitObject(metadataType);
            return null;
        }).when((Object)metadataType)).accept((MetadataTypeVisitor)ArgumentMatchers.any());
        return metadataType;
    }

    public static class SubType {
    }

    public static class BaseType {
    }
}

