/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.sdk.api.annotation.Configuration;
import org.mule.sdk.api.annotation.Configurations;
import org.mule.sdk.api.annotation.Extension;

public class ExtensionTypeWrapperTestCase {
    @Test
    public void getConfigurationsFromExtensionWithConfigurationsUsingTheSkApiAndTheLegacyApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleSdkExtension.class, typeLoader);
        List configurationElements = extensionTypeWrapper.getConfigurations();
        MatcherAssert.assertThat((Object)configurationElements.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(((ConfigurationElement)configurationElements.get(0)).getDeclaringClass().get(), (Matcher)CoreMatchers.equalTo(SimpleSdkConfiguration.class));
        MatcherAssert.assertThat(((ConfigurationElement)configurationElements.get(1)).getDeclaringClass().get(), (Matcher)CoreMatchers.equalTo(SimpleLegacyConfiguration.class));
    }

    @org.mule.runtime.extension.api.annotation.Configuration(name="oldLegacyConfiguration")
    private static class SimpleLegacyConfiguration {
        private SimpleLegacyConfiguration() {
        }
    }

    @Configuration(name="newSdkConfiguration")
    private static class SimpleSdkConfiguration {
        private SimpleSdkConfiguration() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @Configurations(value={SimpleSdkConfiguration.class, SimpleLegacyConfiguration.class})
    private static class SimpleSdkExtension {
        private SimpleSdkExtension() {
        }
    }
}

