/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

public class TypeWrapperTestCase {
    @Test
    public void enumParameterType() {
        TypeWrapper type = new TypeWrapper(TestEnum.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        for (ExtensionParameter parameter : type.getMethod("compareTo", new Class[]{Enum.class}).map(WithParameters::getParameters).get()) {
            MatcherAssert.assertThat((Object)parameter.getType().getTypeName(), (Matcher)CoreMatchers.is((Object)"java.lang.Enum"));
        }
    }

    @Test
    public void recursiveParameterType() {
        TypeWrapper type = new TypeWrapper(SomeClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        for (ExtensionParameter parameter : type.getMethod("someMethod", new Class[]{SomeClass.class}).map(WithParameters::getParameters).get()) {
            MatcherAssert.assertThat((Object)parameter.getType().getTypeName(), (Matcher)CoreMatchers.is((Object)"org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapperTestCase$SomeClass"));
        }
    }

    public static enum TestEnum {
        SOME_VALUE,
        ANOTHER_VALUE;

    }

    public class SomeClass<T extends SomeClass> {
        public void someMethod(T someParameter) {
        }
    }
}

