/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.extension.api.annotation.NoImplicit;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.sdk.api.annotation.Configuration;
import org.mule.sdk.api.annotation.Configurations;
import org.mule.sdk.api.annotation.Extension;

public class JavaConfigurationModelParserTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void getConfigurationNameFromConfigurationUsingSdkApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtension.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.getName(), (Matcher)CoreMatchers.is((Object)"newSdkConfiguration"));
    }

    @Test
    public void getConfigurationNameFromConfigurationUsingLegacyApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.getName(), (Matcher)CoreMatchers.is((Object)"oldLegacyConfiguration"));
    }

    @Test
    public void getConfigurationNameFromConfigurationUsingSdkAndLegacyApi() {
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalModelDefinitionException.class));
        this.expectedException.expectMessage("Annotations org.mule.runtime.extension.api.annotation.Configuration and org.mule.sdk.api.annotation.Configuration are both present at the same time on Configuration SimpleWronglyAnnotatedConfiguration");
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtensionWithWronglyAnnotatedConfiguration.class);
        javaConfigurationModelParser.getName();
    }

    @Test
    public void isForceNoImplicitOnConfigurationUsingTheSdkApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtension.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.isForceNoImplicit(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isForceNoImplicitOnConfigurationUsingTheLegacyApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.isForceNoImplicit(), (Matcher)CoreMatchers.is((Object)true));
    }

    private JavaConfigurationModelParser getParser(Class<?> extension) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionElement = new ExtensionTypeWrapper(extension, typeLoader);
        ConfigurationElement configurationElement = (ConfigurationElement)extensionElement.getConfigurations().get(0);
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionElement, (ExtensionLoadingContext)ctx);
        return new JavaConfigurationModelParser(javaExtensionModelParser, (ExtensionElement)extensionElement, (ComponentElement)configurationElement, (ExtensionLoadingContext)ctx);
    }

    @Configuration(name="wronglySdkConfiguration")
    @org.mule.runtime.extension.api.annotation.Configuration(name="wronglyLegacyConfiguration")
    private static class SimpleWronglyAnnotatedConfiguration {
        private SimpleWronglyAnnotatedConfiguration() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @Configurations(value={SimpleWronglyAnnotatedConfiguration.class})
    private static class SimpleSdkExtensionWithWronglyAnnotatedConfiguration {
        private SimpleSdkExtensionWithWronglyAnnotatedConfiguration() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Configuration(name="oldLegacyConfiguration")
    @NoImplicit
    private static class SimpleLegacyConfiguration {
        private SimpleLegacyConfiguration() {
        }
    }

    @Extension(name="SimpleLegacyExtension")
    @Configurations(value={SimpleLegacyConfiguration.class})
    private static class SimpleLegacyExtension {
        private SimpleLegacyExtension() {
        }
    }

    @Configuration(name="newSdkConfiguration")
    @org.mule.sdk.api.annotation.NoImplicit
    private static class SimpleSdkConfiguration {
        private SimpleSdkConfiguration() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @Configurations(value={SimpleSdkConfiguration.class})
    private static class SimpleSdkExtension {
        private SimpleSdkExtension() {
        }
    }
}

