/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Method;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConnectionProviderModelParserTestCase;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOperationModelParser;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class JavaOperationModelParserTestCase {
    private JavaOperationModelParser parser;
    private OperationElement operationElement;

    @Test
    public void parseTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation(this.getMethod());
    }

    @Test
    public void parseSdkTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation(this.getSdkMethod());
    }

    public void parseOperation(Method method) {
        this.operationElement = new OperationWrapper(method, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        ExtensionElement extensionElement = (ExtensionElement)Mockito.mock(ExtensionElement.class);
        Mockito.when((Object)extensionElement.getParametersAnnotatedWith(Connection.class)).thenReturn(Collections.singletonList(new ParameterWrapper(method, 0, ExtensionsTestUtils.TYPE_LOADER)));
        this.parser = new JavaOperationModelParser((JavaExtensionModelParser)Mockito.mock(JavaExtensionModelParser.class), (ExtensionElement)Mockito.mock(ExtensionElement.class), (OperationContainerElement)Mockito.mock(OperationContainerElement.class), this.operationElement, (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class));
        MatcherAssert.assertThat((Object)this.parser.isTransactional(), (Matcher)Matchers.is((Object)true));
    }

    public Method getMethod() throws NoSuchMethodException {
        return TransactionalOperations.class.getMethod("transactionalOperation", JavaConnectionProviderModelParserTestCase.TestTransactionalConnection.class);
    }

    public Method getSdkMethod() throws NoSuchMethodException {
        return SdkTransactionalOperations.class.getMethod("transactionalOperation", JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection.class);
    }

    private class SdkTransactionalOperations {
        private SdkTransactionalOperations() {
        }

        public void transactionalOperation(@Connection JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection connection) {
        }
    }

    private class TransactionalOperations {
        private TransactionalOperations() {
        }

        public void transactionalOperation(@Connection JavaConnectionProviderModelParserTestCase.TestTransactionalConnection connection) {
        }
    }
}

