/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.lib;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.lib.JavaExternalLibModelParserUtils;
import org.mule.sdk.api.annotation.Export;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.ExternalLib;
import org.mule.test.module.extension.internal.util.extension.SimpleExportedType;

public class JavaExternalLIbModelParserUtilsTestCase {
    public static final String EXTERNAL_LIB_NAME = "SimpleExtension.so";
    public static final String EXTERNAL_LIB_DESCRIPTION = "Cool lib description";
    public static final String EXTERNAL_LIB_FILE_NAME = "SimpleExtension.so";
    public static final String EXTERNAL_LIB_CLASS_NAME = "org.java.Main";

    @Test
    public void getExternalLibraryFromExtensionUsingTheSdkApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleExtensionUsingSdkApi.class, typeLoader);
        List externalLibraryModelList = JavaExternalLibModelParserUtils.parseExternalLibraryModels((WithAnnotations)extensionTypeWrapper);
        MatcherAssert.assertThat((Object)externalLibraryModelList.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getDescription(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_DESCRIPTION));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(0)).getRegexMatcher().get(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(0)).getRequiredClassName().get(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_CLASS_NAME));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getType(), (Matcher)CoreMatchers.equalTo((Object)ExternalLibraryType.NATIVE));
    }

    @Test
    public void getExternalLibraryFromExtensionUsingTheLegacyApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleExtensionUsingLegacyApi.class, typeLoader);
        List externalLibraryModelList = JavaExternalLibModelParserUtils.parseExternalLibraryModels((WithAnnotations)extensionTypeWrapper);
        MatcherAssert.assertThat((Object)externalLibraryModelList.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getDescription(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_DESCRIPTION));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(0)).getRegexMatcher().get(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(0)).getRequiredClassName().get(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_CLASS_NAME));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getType(), (Matcher)CoreMatchers.equalTo((Object)ExternalLibraryType.NATIVE));
    }

    @Test
    public void getExternalLibraryFromExtensionUsingBothTheLegacyAndTheSdkApi() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(SimpleMixedApiExtension.class, typeLoader);
        List externalLibraryModelList = JavaExternalLibModelParserUtils.parseExternalLibraryModels((WithAnnotations)extensionTypeWrapper);
        MatcherAssert.assertThat((Object)externalLibraryModelList.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getDescription(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_DESCRIPTION));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(0)).getRegexMatcher().get(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(0)).getRequiredClassName().get(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_CLASS_NAME));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(0)).getType(), (Matcher)CoreMatchers.equalTo((Object)ExternalLibraryType.NATIVE));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(1)).getName(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(1)).getDescription(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_DESCRIPTION));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(1)).getRegexMatcher().get(), (Matcher)CoreMatchers.is((Object)"SimpleExtension.so"));
        MatcherAssert.assertThat(((ExternalLibraryModel)externalLibraryModelList.get(1)).getRequiredClassName().get(), (Matcher)CoreMatchers.is((Object)EXTERNAL_LIB_CLASS_NAME));
        MatcherAssert.assertThat((Object)((ExternalLibraryModel)externalLibraryModelList.get(1)).getType(), (Matcher)CoreMatchers.equalTo((Object)ExternalLibraryType.NATIVE));
    }

    @Extension(name="SimpleExtension")
    @Export(classes={SimpleExportedType.class}, resources={"simpleResource.json"})
    @ExternalLib(name="SimpleExtension.so", description="Cool lib description", nameRegexpMatcher="SimpleExtension.so", requiredClassName="org.java.Main", type=org.mule.sdk.api.meta.ExternalLibraryType.NATIVE)
    @org.mule.runtime.extension.api.annotation.ExternalLib(name="SimpleExtension.so", description="Cool lib description", nameRegexpMatcher="SimpleExtension.so", requiredClassName="org.java.Main", type=ExternalLibraryType.NATIVE)
    private static class SimpleMixedApiExtension {
        private SimpleMixedApiExtension() {
        }
    }

    @Extension(name="SimpleExtension")
    @Export(classes={SimpleExportedType.class}, resources={"simpleResource.json"})
    @org.mule.runtime.extension.api.annotation.ExternalLib(name="SimpleExtension.so", description="Cool lib description", nameRegexpMatcher="SimpleExtension.so", requiredClassName="org.java.Main", type=ExternalLibraryType.NATIVE)
    private static class SimpleExtensionUsingLegacyApi {
        private SimpleExtensionUsingLegacyApi() {
        }
    }

    @Extension(name="SimpleExtension")
    @Export(classes={SimpleExportedType.class}, resources={"simpleResource.json"})
    @ExternalLib(name="SimpleExtension.so", description="Cool lib description", nameRegexpMatcher="SimpleExtension.so", requiredClassName="org.java.Main", type=org.mule.sdk.api.meta.ExternalLibraryType.NATIVE)
    private static class SimpleExtensionUsingSdkApi {
        private SimpleExtensionUsingSdkApi() {
        }
    }
}

