/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SampleDataProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaSampleDataModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.annotation.param.Config;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.streaming.PagingProvider;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class SampleDataProviderModelValidatorTestCase {
    private static Result<String, String> OUTPUT_RESULT;
    private final JavaTypeLoader loader = new JavaTypeLoader(this.getClass().getClassLoader());
    private final MetadataType STRING_TYPE = this.loader.load(String.class);
    private final MetadataType NUMBER_TYPE = this.loader.load(Integer.class);
    private final ReflectionCache reflectionCache = new ReflectionCache();
    private JavaSampleDataModelValidator validator;
    private ProblemsReporter problemsReporter;
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true, answer=Answers.RETURNS_DEEP_STUBS)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel parameterModel;
    @Mock(lenient=true)
    private ConfigurationModel configurationModel;
    @Mock(lenient=true)
    private ParameterGroupModel parameterGroupModel;
    @Mock(lenient=true)
    private ParameterGroupModel configurationParameterGroupModel;
    @Mock(lenient=true, answer=Answers.RETURNS_DEEP_STUBS)
    private SourceModel sourceModel;
    private SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder providerBuilder;
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void setUp() {
        OUTPUT_RESULT = (Result)Mockito.mock(Result.class);
        this.validator = new JavaSampleDataModelValidator();
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        this.providerBuilder = SampleDataProviderFactoryModelProperty.builder(ConnectedSampleDataProvider.class);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)"SomeConfig");
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.configurationParameterGroupModel.getParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"myOp");
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"superOperation");
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"listener");
        Mockito.when((Object)this.sourceModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.parameterModel.getModelProperty(ImplementingParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterModel.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"someName");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.STRING_TYPE);
        this.mockOutput((ConnectableComponentModel)this.operationModel);
        this.mockOutput((ConnectableComponentModel)this.sourceModel);
    }

    private void mockOutput(ConnectableComponentModel model) {
        Mockito.when((Object)model.getOutput().getType()).thenReturn((Object)this.typeLoader.load(String.class));
        Mockito.when((Object)model.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(String.class));
    }

    private void mockOperationProvider() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, this.providerBuilder, ConnectedSampleDataProvider.class.getSimpleName());
    }

    private void mockSourceProvider() {
        this.mockComponent((ConnectableComponentModel)this.sourceModel, SampleDataProviderFactoryModelProperty.builder(ConnectedSampleDataProvider.class), ConfigAwareSampleDataProvider.class.getSimpleName());
    }

    @After
    public void tearDown() {
        OUTPUT_RESULT = null;
    }

    @Test
    public void providerShouldBeInstantiable() {
        SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder builder = SampleDataProviderFactoryModelProperty.builder(NonInstantiableProvider.class);
        this.mockComponent((ConnectableComponentModel)this.operationModel, builder, "anotherId");
        this.validate();
        this.assertProblems("The SampleDataProvider [NonInstantiableProvider] is not instantiable");
    }

    @Test
    public void parameterShouldExist() {
        this.providerBuilder.withInjectableParameter("someParam", this.STRING_TYPE, true);
        Mockito.when((Object)this.operationModel.getModelProperty(SampleDataProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.providerBuilder.build()));
        this.mockOperationProvider();
        this.validate();
        this.assertProblems("The SampleDataProvider [ConnectedSampleDataProvider] declares to use a parameter 'someParam' which doesn't exist in the operation 'superOperation'");
    }

    @Test
    public void parameterShouldBeOfSameType() {
        this.providerBuilder.withInjectableParameter("someName", this.NUMBER_TYPE, true);
        this.mockOperationProvider();
        this.validate();
        this.assertProblems("The SampleDataProvider [ConnectedSampleDataProvider] defines a parameter 'someName' of type 'class java.lang.Integer' but in the operation 'superOperation' is of type 'class java.lang.String'");
    }

    @Test
    public void injectConnectionInConnectionLessComponent() {
        this.providerBuilder.withConnection((Field)IntrospectionUtils.getField(ConnectedSampleDataProvider.class, (String)"connection", (ReflectionCache)this.reflectionCache).get());
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)false);
        this.mockOperationProvider();
        this.validate();
        this.assertProblems("The SampleDataProvider [ConnectedSampleDataProvider] defines that it requires a connection, but is used in the operation 'superOperation' which is connection less");
    }

    @Test
    public void injectConfigInConfigLessComponent() {
        this.providerBuilder.withConfig((Field)IntrospectionUtils.getField(ConfigAwareSampleDataProvider.class, (String)"config", (ReflectionCache)this.reflectionCache).get());
        this.mockOperationProvider();
        this.validate();
        this.assertProblems("The SampleDataProvider [ConnectedSampleDataProvider] defines that it requires a config, but is used in the operation 'superOperation' which is config less");
    }

    @Test
    public void injectConfigInConfigAwareComponent() {
        this.providerBuilder.withConfig((Field)IntrospectionUtils.getField(ConfigAwareSampleDataProvider.class, (String)"config", (ReflectionCache)this.reflectionCache).get());
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        this.mockOperationProvider();
        this.validate();
    }

    @Test
    public void duplicateProviderId() {
        this.mockOperationProvider();
        String id = ConnectedSampleDataProvider.class.getSimpleName();
        this.mockComponent((ConnectableComponentModel)this.sourceModel, SampleDataProviderFactoryModelProperty.builder(ConfigAwareSampleDataProvider.class), id);
        this.validate();
        this.assertProblems(String.format("The following SampleDataProvider implementations [%s, %s] use the same id [%s]. SampleDataProvider ids must be unique.", ConfigAwareSampleDataProvider.class.getName(), ConnectedSampleDataProvider.class.getName(), id));
    }

    @Test
    public void legalComponent() {
        this.mockOperationProvider();
        this.mockSourceProvider();
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void operationWithWrongPayloadTypeSampleDataProvider() {
        this.assertWrongGenerics((ConnectableComponentModel)this.operationModel, MapSampleDataProvider.class, "SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$MapSampleDataProvider] is used at component 'superOperation' which outputs a Result<java.lang.String, java.lang.String>, but the provider generic signature is '<java.util.Map<java.lang.String, java.lang.String>, java.lang.String>'");
    }

    @Test
    public void operationWithWrongAttributesTypeSampleDataProvider() {
        this.assertWrongGenerics((ConnectableComponentModel)this.operationModel, MapAttributesSampleDataProvider.class, "SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$MapAttributesSampleDataProvider] is used at component 'superOperation' which outputs a Result<java.lang.String, java.lang.String>, but the provider generic signature is '<java.lang.String, java.util.Map<java.lang.String, java.lang.String>>'");
    }

    @Test
    public void sourceWithWrongPayloadTypeSampleDataProvider() {
        this.assertWrongGenerics((ConnectableComponentModel)this.sourceModel, MapSampleDataProvider.class, "SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$MapSampleDataProvider] is used at component 'listener' which outputs a Result<java.lang.String, java.lang.String>, but the provider generic signature is '<java.util.Map<java.lang.String, java.lang.String>, java.lang.String>'");
    }

    @Test
    public void sourceWithWrongAttributesTypeSampleDataProvider() {
        this.assertWrongGenerics((ConnectableComponentModel)this.sourceModel, MapAttributesSampleDataProvider.class, "SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$MapAttributesSampleDataProvider] is used at component 'listener' which outputs a Result<java.lang.String, java.lang.String>, but the provider generic signature is '<java.lang.String, java.util.Map<java.lang.String, java.lang.String>>'");
    }

    @Test
    public void operationWithBoxedVoidAttributes() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(VoidAttributesSampleDataProvider.class), VoidAttributesSampleDataProvider.class.getSimpleName());
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(Void.class));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void operationWithNativeVoidAttributes() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(VoidAttributesSampleDataProvider.class), VoidAttributesSampleDataProvider.class.getSimpleName());
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(Void.TYPE));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void operationWithBoxedVoidReturnType() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(VoidReturnTypeSampleDataProvider.class), VoidAttributesSampleDataProvider.class.getSimpleName());
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)"SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$VoidReturnTypeSampleDataProvider] cannot have a Void return type"));
    }

    @Test
    public void pagingOperationWithInputStreamPayload() {
        Method method = this.getPagedOperationMethod();
        this.mockInputStreamPaging(method);
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(PagedInputStreamSampleDataProvider.class), PagedInputStreamSampleDataProvider.class.getSimpleName());
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void pagingOperationWithSampleProviderWhichDoesNotReturnCollection() {
        Method method = this.getPagedOperationMethod();
        this.mockInputStreamPaging(method);
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(TestSampleDataProvider.class), TestSampleDataProvider.class.getSimpleName());
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)"SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$TestSampleDataProvider] is used on component 'superOperation' which is paged. The SampleDataProvider is thus expected to provide a payload of type 'Collection<java.io.InputStream>' but it returns a payload of type 'java.lang.String' instead"));
    }

    @Test
    public void pagingOperationWithSampleProviderWhichReturnsCollectionOfWrongType() {
        Method method = this.getPagedOperationMethod();
        this.mockInputStreamPaging(method);
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(PagedStringSampleDataProvider.class), PagedStringSampleDataProvider.class.getSimpleName());
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)"SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$PagedStringSampleDataProvider] is used on component 'superOperation' which is paged. The SampleDataProvider is thus expected to provide a payload of type 'Collection<java.io.InputStream>', but a Collection<java.lang.String> was found instead."));
    }

    @Test
    public void pagingOperationWithUnboundedSampleProvider() {
        Method method = this.getPagedOperationMethod();
        this.mockInputStreamPaging(method);
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(UnboundedPagingSampleDataProvider.class), UnboundedPagingSampleDataProvider.class.getSimpleName());
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)"SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$UnboundedPagingSampleDataProvider] is used on component 'superOperation' which is paged. The SampleDataProvider is thus expected to provide a payload of type 'Collection<java.io.InputStream>', but an unbounded Collection was found instead. Please provide the proper generic"));
    }

    @Test
    public void pagingOperationWithSampleProviderWhichReturnsAttributesOfWrongType() {
        Method method = this.getPagedOperationMethod();
        this.mockInputStreamPaging(method);
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(PagingSampleDataProviderWithWrongAttributesType.class), PagingSampleDataProviderWithWrongAttributesType.class.getSimpleName());
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)"SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$PagingSampleDataProviderWithWrongAttributesType] is used on component 'superOperation' which is paged. The SampleDataProvider is thus expected to provide attributes of type 'java.lang.String' but it returns attributes of type 'void' instead"));
    }

    @Test
    public void operationSamePayloadTypeUsingGenericsSampleDataProvider() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(SampleDataProviderWithGenerics.class), SampleDataProviderWithGenerics.class.getSimpleName());
        ParameterizedType outputType = TypeUtils.parameterize(Map.class, (Type[])new Type[]{String.class, Object.class});
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)this.typeLoader.load((Type)outputType));
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(String.class));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void operationSamePayloadTypeUsingNestedGenericsSampleDataProvider() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(SampleDataProviderWithNestedGenerics.class), SampleDataProviderWithNestedGenerics.class.getSimpleName());
        ParameterizedType listType = TypeUtils.parameterize(List.class, (Type[])new Type[]{String.class});
        ParameterizedType outputType = TypeUtils.parameterize(Map.class, (Type[])new Type[]{String.class, listType});
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)this.typeLoader.load((Type)outputType));
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(String.class));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void operationSamePayloadTypeUsingWrongGenericsSampleDataProvider() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(SampleDataProviderWithGenerics.class), SampleDataProviderWithGenerics.class.getSimpleName());
        ParameterizedType outputType = TypeUtils.parameterize(Map.class, (Type[])new Type[]{Integer.class, Object.class});
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)this.typeLoader.load((Type)outputType));
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(String.class));
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)"SampleDataProvider [org.mule.runtime.module.extension.internal.loader.validation.SampleDataProviderModelValidatorTestCase$SampleDataProviderWithGenerics] is used at component 'superOperation' which outputs a Result<java.util.Map<java.lang.Integer, java.lang.Object>, java.lang.String>, but the provider generic signature is '<java.util.Map<java.lang.String, java.lang.Object>, java.lang.String>'"));
    }

    @Test
    public void operationSamePayloadTypeUsingWrongNestedGenericsSampleDataProvider() {
        this.mockComponent((ConnectableComponentModel)this.operationModel, SampleDataProviderFactoryModelProperty.builder(SampleDataProviderWithNestedGenerics.class), SampleDataProviderWithNestedGenerics.class.getSimpleName());
        ParameterizedType listType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Object.class});
        ParameterizedType outputType = TypeUtils.parameterize(Map.class, (Type[])new Type[]{String.class, listType});
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)this.typeLoader.load((Type)outputType));
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)this.typeLoader.load(String.class));
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void boundParameterExists() {
        this.providerBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "someName");
        Mockito.when((Object)this.operationModel.getModelProperty(SampleDataProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.providerBuilder.build()));
        this.mockOperationProvider();
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void boundParameterShouldExist() {
        this.providerBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "anotherName");
        Mockito.when((Object)this.operationModel.getModelProperty(SampleDataProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.providerBuilder.build()));
        this.mockOperationProvider();
        this.validate();
        this.assertProblems("The SampleDataProvider [ConnectedSampleDataProvider] declares to use a parameter 'anotherName' which doesn't exist in the operation 'superOperation'");
    }

    @Test
    public void boundParameterFromExtractionExpressionExists() {
        this.providerBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "someName.someTag.@attribute");
        Mockito.when((Object)this.operationModel.getModelProperty(SampleDataProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.providerBuilder.build()));
        this.mockOperationProvider();
        this.validate();
        this.assertNoErrors();
    }

    @Test
    public void boundParameterFromExtractionExpressionShouldExist() {
        this.providerBuilder.withInjectableParameter("actingParameter", this.STRING_TYPE, true, "anotherName.nested.fields");
        Mockito.when((Object)this.operationModel.getModelProperty(SampleDataProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.providerBuilder.build()));
        this.mockOperationProvider();
        this.validate();
        this.assertProblems("The SampleDataProvider [ConnectedSampleDataProvider] declares to use a parameter 'anotherName' which doesn't exist in the operation 'superOperation'");
    }

    private void assertWrongGenerics(ConnectableComponentModel model, Class<? extends SampleDataProvider> providerClass, String expectedError) {
        this.mockComponent(model, SampleDataProviderFactoryModelProperty.builder(providerClass), providerClass.getSimpleName());
        this.validate();
        this.assertErrorMessages(CoreMatchers.equalTo((Object)expectedError));
    }

    private void assertProblems(String errorMessage) {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Problem)errors.get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)errorMessage));
    }

    private void assertNoErrors() {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    private void assertErrorMessages(Matcher<String> ... matchers) {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)matchers.length));
        for (int i = 0; i < matchers.length; ++i) {
            MatcherAssert.assertThat((Object)((Problem)errors.get(i)).getMessage(), matchers[i]);
        }
    }

    private void validate() {
        this.validator.validate(this.extensionModel, this.problemsReporter);
    }

    private void mockComponent(ConnectableComponentModel componentModel, SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder builder, String providerId) {
        Mockito.when((Object)componentModel.getModelProperty(SampleDataProviderFactoryModelProperty.class)).thenReturn(Optional.of(builder.build()));
        Mockito.when((Object)componentModel.getModelProperty(ImplementingParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)componentModel.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)componentModel.getSampleDataProviderModel()).thenReturn(Optional.of(new SampleDataProviderModel(Collections.emptyList(), providerId, true, true)));
    }

    private void mockInputStreamPaging(Method method) {
        ArrayType type = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().with((TypeAnnotation)new ClassInformationAnnotation(PagingProvider.class, Arrays.asList(Object.class, InputStream.class))).of(this.typeLoader.load(InputStream.class)).build();
        Mockito.when((Object)this.operationModel.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(Optional.of(new ImplementingMethodModelProperty(method)));
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)type);
    }

    private Method getPagedOperationMethod() {
        return ClassUtils.getMethod(PagedInputStreamOperationStub.class, (String)"paged", (Class[])new Class[0]);
    }

    public static class SampleDataProviderWithNestedGenerics
    implements SampleDataProvider<Map<String, List<String>>, String> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<Map<String, List<String>>, String> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class SampleDataProviderWithGenerics
    implements SampleDataProvider<Map<String, Object>, String> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<Map<String, Object>, String> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class PagingSampleDataProviderWithWrongAttributesType
    implements SampleDataProvider<List<InputStream>, Void> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<List<InputStream>, Void> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class UnboundedPagingSampleDataProvider
    implements SampleDataProvider<List, String> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<List, String> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class PagedStringSampleDataProvider
    implements SampleDataProvider<List<String>, String> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<List<String>, String> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class PagedInputStreamSampleDataProvider
    implements SampleDataProvider<List<InputStream>, String> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<List<InputStream>, String> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class VoidReturnTypeSampleDataProvider
    implements SampleDataProvider<Void, Void> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<Void, Void> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class VoidAttributesSampleDataProvider
    implements SampleDataProvider<String, Void> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<String, Void> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class MapAttributesSampleDataProvider
    implements SampleDataProvider<String, Map<String, String>> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<String, Map<String, String>> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class MapSampleDataProvider
    implements SampleDataProvider<Map<String, String>, String> {
        public String getId() {
            return this.getClass().getSimpleName();
        }

        public Result<Map<String, String>, String> getSample() throws SampleDataException {
            return null;
        }
    }

    public static class NonInstantiableProvider
    extends TestSampleDataProvider {
        private NonInstantiableProvider() {
        }
    }

    public static class ConfigAwareSampleDataProvider
    extends TestSampleDataProvider {
        @Config
        private Object config;
    }

    public static class ConnectedSampleDataProvider
    extends TestSampleDataProvider {
    }

    public static class TestSampleDataProvider
    implements SampleDataProvider<String, String> {
        @Connection
        protected String connection;

        public Result<String, String> getSample() throws SampleDataException {
            return OUTPUT_RESULT;
        }

        public String getId() {
            return this.getClass().getSimpleName();
        }
    }

    public static class PagedInputStreamOperationStub {
        public PagingProvider<Object, InputStream> paged() {
            return null;
        }
    }
}

