/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import io.qameta.allure.Issue;
import io.qameta.allure.Issues;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.privileged.transaction.XaTransaction;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionContextConfigurationDecorator;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=Parameterized.class)
public class ExtensionConnectionSupplierTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Inject
    private ExtensionConnectionSupplier adapter;
    @Inject
    private ConnectionManager connectionManager;
    private XaTransaction transaction;
    private Object config;
    private ExecutionContextAdapter operationContext;
    private ConnectionProvider connectionProvider;
    private ConfigurationInstance configurationInstance;
    private final boolean lazyConnections;

    @Parameterized.Parameters(name="lazyConnections: {0}")
    public static Collection<Boolean> params() {
        return Arrays.asList(true, false);
    }

    public ExtensionConnectionSupplierTestCase(boolean lazyConnections) {
        this.lazyConnections = lazyConnections;
    }

    protected boolean doTestClassInjection() {
        return true;
    }

    protected Optional<Properties> getDeploymentProperties() {
        Properties deploymentProps = new Properties();
        deploymentProps.put("mule.application.deployment.lazyConnections", Boolean.toString(this.lazyConnections));
        return Optional.of(deploymentProps);
    }

    @Before
    public void before() throws Exception {
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        muleContext.setTransactionManager(transactionManager);
        this.transaction = (XaTransaction)Mockito.spy((Object)new XaTransaction("appName", transactionManager, MuleContextUtils.getNotificationDispatcher((MuleContext)muleContext)));
        XATransactionalConnection connection = (XATransactionalConnection)Mockito.mock(XATransactionalConnection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = new Object();
        this.operationContext = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        this.configurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(Optional.of(this.connectionProvider));
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(this.config);
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn((Object)connection);
        TransactionConfig transactionConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)transactionConfig.getAction()).thenReturn((Object)3);
        Mockito.when((Object)transactionConfig.isTransacted()).thenReturn((Object)true);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.of(transactionConfig));
        Mockito.when((Object)this.operationContext.getComponentModel()).thenReturn(Mockito.mock(OperationModel.class));
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void xaTransaction() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        this.bindAndVerify();
    }

    @Test
    public void xaTransactionWithDecoratedConfig() throws Exception {
        ExecutionContextConfigurationDecorator configurationInstanceDecorator = (ExecutionContextConfigurationDecorator)Mockito.mock(ExecutionContextConfigurationDecorator.class);
        Mockito.when((Object)configurationInstanceDecorator.getDecorated()).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)configurationInstanceDecorator.getConnectionProvider()).thenReturn(Optional.of(this.connectionProvider));
        Mockito.when((Object)configurationInstanceDecorator.getValue()).thenReturn(this.config);
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(configurationInstanceDecorator));
        this.bindAndVerify();
    }

    @Test
    @Issues(value={@Issue(value="MULE-19288"), @Issue(value="MULE-17900")})
    public void xaTransactionNotSupports() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.transaction.supports(ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)false);
        if (this.lazyConnections) {
            this.expected.expect(MuleRuntimeException.class);
            this.expected.expectCause(Matchers.instanceOf(TransactionException.class));
            this.expected.expectMessage("but the current transaction doesn't support it and could not be bound");
        } else {
            this.expected.expect(TransactionException.class);
            this.expected.expectMessage("but the current transaction doesn't support it and could not be bound");
        }
        this.bindAndVerify();
    }

    @Test
    @Issues(value={@Issue(value="MULE-19288"), @Issue(value="MULE-17900")})
    public void xaTransactionBindResourceFails() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        TransactionException txExceptionExpected = new TransactionException((Throwable)new Exception());
        ((XaTransaction)Mockito.doThrow((Throwable[])new Throwable[]{txExceptionExpected}).when((Object)this.transaction)).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any());
        if (this.lazyConnections) {
            this.expected.expect(MuleRuntimeException.class);
            this.expected.expectCause(Matchers.sameInstance((Object)txExceptionExpected));
        } else {
            this.expected.expect(Matchers.sameInstance((Object)txExceptionExpected));
        }
        this.bindAndVerify();
    }

    @Test
    @Issue(value="MULE-19289")
    public void xaTransactionBindResourceFailsReleaseFails() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        TransactionException txExceptionExpected = new TransactionException((Throwable)new Exception());
        ((XaTransaction)Mockito.doThrow((Throwable[])new Throwable[]{txExceptionExpected}).when((Object)this.transaction)).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any());
        ((ConnectionProvider)Mockito.doThrow(IllegalStateException.class).when((Object)this.connectionProvider)).disconnect(ArgumentMatchers.any());
        if (this.lazyConnections) {
            this.expected.expect(MuleRuntimeException.class);
            this.expected.expectCause(Matchers.sameInstance((Object)txExceptionExpected));
        } else {
            this.expected.expect(Matchers.sameInstance((Object)txExceptionExpected));
        }
        this.bindAndVerify();
    }

    @Test
    @Issue(value="MULE-17900")
    public void transactionResourceBindWithLazyConnections() throws Exception {
        Assume.assumeThat((Object)this.lazyConnections, (Matcher)Matchers.is((Object)true));
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.connectionProvider.connect()).thenThrow(new Throwable[]{new AssertionError((Object)"Should not have tried to establish a connection")});
        this.connectionManager.bind(this.config, this.connectionProvider);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.transaction);
        this.adapter.getConnection(this.operationContext);
        ((XaTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any(XAExtensionTransactionalResource.class));
    }

    @Test
    @Issue(value="MULE-19347")
    public void ifXATransactionBindResourceFailsWithConnectionExceptionThenHandlerIsInvalidated() throws Exception {
        ConnectionException expectedConnectionException = new ConnectionException("Failed to bind tx due to connectivity issue.");
        TransactionException expectedTxException = new TransactionException((Throwable)expectedConnectionException);
        Assume.assumeThat((Object)this.lazyConnections, (Matcher)Matchers.is((Object)false));
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        ((XaTransaction)Mockito.doThrow((Throwable[])new Throwable[]{expectedTxException}).when((Object)this.transaction)).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any());
        this.expected.expect(TransactionException.class);
        this.expected.expectCause(Matchers.sameInstance((Object)expectedConnectionException));
        try {
            this.connectionManager.bind(this.config, this.connectionProvider);
            TransactionCoordination.getInstance().bindTransaction((Transaction)this.transaction);
            this.adapter.getConnection(this.operationContext);
        }
        finally {
            ((XaTransaction)Mockito.verify((Object)this.transaction)).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any(XAExtensionTransactionalResource.class));
            ((ConnectionProvider)Mockito.verify((Object)this.connectionProvider)).disconnect(ArgumentMatchers.any(XATransactionalConnection.class));
        }
    }

    private void bindAndVerify() throws TransactionException, ConnectionException {
        this.connectionManager.bind(this.config, this.connectionProvider);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.transaction);
        ConnectionHandler connection = this.adapter.getConnection(this.operationContext);
        if (this.lazyConnections) {
            connection.getConnection();
        }
        ((XaTransaction)Mockito.verify((Object)this.transaction)).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any(XAExtensionTransactionalResource.class));
    }

    @Test
    @Issue(value="MULE-19288")
    public void doNotRetryOnTxException() {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        TransactionException txExceptionExpected = new TransactionException((Throwable)new ConnectionException("expected!"));
        Assert.assertThat((Object)ReconnectionUtils.shouldRetry((Throwable)txExceptionExpected, (ExecutionContextAdapter)this.operationContext), (Matcher)Matchers.is((Object)false));
    }
}

