/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.runtime.module.extension.internal.runtime.operation.ImmutableProcessorChildContextChainExecutor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
@Feature(value="Correlation ID")
@Story(value="Correlation id modification in child context in chains")
public class ProcessorChildContextChainExecutorTestCase
extends AbstractMuleContextTestCase {
    private static final String TEST_CORRELATION_ID = "messirve";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock(lenient=true)
    private MessageProcessorChain chain;
    private final CorrelationIdProcessor processor = new CorrelationIdProcessor();
    private CoreEvent coreEvent;
    private Latch latch;

    @Before
    public void setUp() throws Exception {
        this.coreEvent = this.testEvent();
        DefaultComponentLocation someLocation = new DefaultComponentLocation(Optional.empty(), Collections.emptyList());
        SdkInternalContext content = new SdkInternalContext();
        ((InternalEvent)this.coreEvent).setSdkInternalContext((EventInternalContext)content);
        content.putContext((ComponentLocation)someLocation, this.coreEvent.getCorrelationId());
        Mockito.when((Object)this.chain.getLocation()).thenReturn((Object)someLocation);
        Mockito.when((Object)this.chain.apply((Publisher)ArgumentMatchers.any())).thenAnswer(inv -> Mono.from((Publisher)((Publisher)inv.getArgument(0))).map(event -> {
            try {
                return this.processor.process((CoreEvent)event);
            }
            catch (MuleException e) {
                return null;
            }
        }));
        Mockito.when((Object)this.chain.getMessageProcessors()).thenReturn(Collections.singletonList(this.processor));
    }

    @Test
    public void testDoProcessSuccessOnce() throws InterruptedException {
        ImmutableProcessorChildContextChainExecutor chainExecutor = new ImmutableProcessorChildContextChainExecutor((StreamingManager)Mockito.mock(StreamingManager.class), this.coreEvent, this.chain);
        AtomicInteger successCalls = new AtomicInteger(0);
        AtomicInteger errorCalls = new AtomicInteger(0);
        Reference propagatedEvent = new Reference();
        this.doProcessAndWait(chainExecutor, TEST_CORRELATION_ID, r -> {
            successCalls.incrementAndGet();
            propagatedEvent.set((Object)((EventedResult)r).getEvent());
        }, (t, r) -> errorCalls.incrementAndGet());
        MatcherAssert.assertThat((Object)successCalls.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)errorCalls.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.processor.correlationID, (Matcher)Matchers.is((Object)TEST_CORRELATION_ID));
        MatcherAssert.assertThat((Object)((CoreEvent)propagatedEvent.get()).getCorrelationId(), (Matcher)Matchers.is((Object)this.coreEvent.getCorrelationId()));
        MatcherAssert.assertThat((Object)((CoreEvent)propagatedEvent.get()).getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)this.processor.rootId, (Matcher)Matchers.is((Object)this.coreEvent.getContext().getRootId()));
        MatcherAssert.assertThat((Object)((CoreEvent)propagatedEvent.get()).getContext().getRootId(), (Matcher)Matchers.is((Object)this.coreEvent.getContext().getRootId()));
    }

    @Test
    public void testDoProcessOnErrorGenericException() throws InterruptedException {
        ImmutableProcessorChildContextChainExecutor chainExecutor = new ImmutableProcessorChildContextChainExecutor((StreamingManager)Mockito.mock(StreamingManager.class), this.coreEvent, this.chain);
        Reference parentIsFinished = new Reference((Object)false);
        ((BaseEventContext)this.coreEvent.getContext()).onComplete((ev, t) -> {
            Boolean cfr_ignored_0 = (Boolean)parentIsFinished.set((Object)true);
        });
        this.processor.throwError();
        AtomicInteger successCalls = new AtomicInteger(0);
        AtomicInteger errorCalls = new AtomicInteger(0);
        Reference errorEvent = new Reference();
        this.doProcessAndWait(chainExecutor, TEST_CORRELATION_ID, r -> successCalls.incrementAndGet(), (t, r) -> {
            errorCalls.incrementAndGet();
            errorEvent.set((Object)((EventedResult)r).getEvent());
        });
        MatcherAssert.assertThat((Object)successCalls.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)errorCalls.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Event)errorEvent.get()).getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)this.processor.correlationID, (Matcher)Matchers.is((Object)TEST_CORRELATION_ID));
        MatcherAssert.assertThat((Object)((Event)errorEvent.get()).getCorrelationId(), (Matcher)Matchers.is((Object)this.coreEvent.getCorrelationId()));
        MatcherAssert.assertThat((Object)parentIsFinished.get(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void contextFinished() throws InterruptedException {
        Reference parentFinished = new Reference((Object)false);
        Reference newFinished = new Reference((Object)false);
        Reference correctCompletionOrder = new Reference((Object)false);
        this.processor.setConsumer((ev, t) -> {
            Boolean cfr_ignored_0 = (Boolean)correctCompletionOrder.set((Object)((Boolean)newFinished.get() == false ? 1 : 0));
        });
        ((BaseEventContext)this.coreEvent.getContext()).onComplete((ev, t) -> {
            Boolean cfr_ignored_0 = (Boolean)parentFinished.set((Object)true);
        });
        ImmutableProcessorChildContextChainExecutor chainExecutor = new ImmutableProcessorChildContextChainExecutor((StreamingManager)Mockito.mock(StreamingManager.class), this.coreEvent, this.chain);
        this.doProcessAndWait(chainExecutor, TEST_CORRELATION_ID, r -> newFinished.set((Object)true), (t, r) -> {});
        MatcherAssert.assertThat((Object)parentFinished.get(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)newFinished.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.processor.context.isComplete(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)correctCompletionOrder.get(), (Matcher)Matchers.is((Object)true));
    }

    private void doProcessAndWait(ImmutableProcessorChildContextChainExecutor chainExecutor, String expectedCorrelationId, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) throws InterruptedException {
        this.latch = new Latch();
        chainExecutor.process(expectedCorrelationId, onSuccess, onError);
        this.latch.await(300L, TimeUnit.MILLISECONDS);
    }

    private static class CorrelationIdProcessor
    implements Processor {
        public String correlationID = null;
        public String rootId = null;
        public BaseEventContext context = null;
        private BiConsumer<CoreEvent, Throwable> consumer = null;
        private boolean throwError = false;

        private CorrelationIdProcessor() {
        }

        public void throwError() {
            this.throwError = true;
        }

        public void setConsumer(BiConsumer<CoreEvent, Throwable> consumer) {
            this.consumer = consumer;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            this.context = (BaseEventContext)event.getContext();
            this.correlationID = event.getCorrelationId();
            this.rootId = event.getContext().getRootId();
            if (this.consumer != null) {
                this.context.onComplete(this.consumer);
            }
            if (this.throwError) {
                throw new MessagingException(I18nMessageFactory.createStaticMessage((String)"some exception"), event);
            }
            return event;
        }
    }
}

