/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.MessageProcessingManager;
import org.mule.runtime.core.internal.streaming.bytes.SimpleByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.factory.NullCursorStreamProviderFactory;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.source.BackPressureAction;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.mule.test.metadata.extension.resolver.TestNoConfigMetadataResolver;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public abstract class AbstractExtensionMessageSourceTestCase
extends AbstractMuleContextTestCase {
    protected static final String LOGGER_FIELD_NAME = "LOGGER";
    protected static final String CONFIG_NAME = "myConfig";
    protected static final String ERROR_MESSAGE = "ERROR";
    protected static final String SOURCE_NAME = "source";
    protected static final String METADATA_KEY = "metadataKey";
    protected final JavaTypeLoader typeLoader = new JavaTypeLoader(((Object)((Object)this)).getClass().getClassLoader());
    protected CursorStreamProviderFactory cursorStreamProviderFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    protected ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected SourceModel sourceModel;
    @Mock
    protected SourceAdapterFactory sourceAdapterFactory;
    @Mock
    protected SourceCallbackFactory sourceCallbackFactory;
    @Mock
    protected MessageProcessContext messageProcessContext;
    @Mock
    protected TransactionConfig transactionConfig;
    @Mock
    protected Scheduler ioScheduler;
    @Mock
    protected Scheduler cpuLightScheduler;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected Processor messageProcessor;
    @Mock
    protected SourceCompletionHandlerFactory completionHandlerFactory;
    @Mock
    protected FlowConstruct flowConstruct;
    @Mock(extraInterfaces={Lifecycle.class})
    protected Source source;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ExtensionManager extensionManager;
    @Mock
    protected MetadataCacheIdGeneratorFactory<ComponentAst> cacheIdGeneratorFactory;
    @Mock
    protected MetadataCacheIdGenerator<ComponentAst> cacheIdGenerator;
    @Mock
    protected MessageProcessingManager messageProcessingManager;
    @Mock
    protected ExceptionCallback exceptionCallback;
    @Mock
    protected SdkExceptionHandlerFactory enricherFactory;
    @Mock
    protected ConfigurationProvider configurationProvider;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ConfigurationModel configurationModel;
    @Mock
    protected ConfigurationInstance configurationInstance;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ResolverSet callbackParameters;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected Result result;
    @Mock
    private ConfigurationComponentLocator componentLocator;
    @Mock
    protected MetadataResolverFactory metadataResolverFactory;
    @Inject
    private ProfilingService profilingService;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected boolean primaryNodeOnly = false;
    protected SourceAdapter sourceAdapter;
    protected SourceCallback sourceCallback;
    protected ExtensionMessageSource messageSource;
    protected StreamingManager streamingManager = (StreamingManager)Mockito.spy((Object)new DefaultStreamingManager());
    protected NotificationDispatcher notificationDispatcher;

    protected boolean doTestClassInjection() {
        return true;
    }

    @Before
    public void before() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        MuleTestUtils.spyInjector((MuleContext)muleContext);
        this.notificationDispatcher = MuleContextUtils.getNotificationDispatcher((MuleContext)muleContext);
        Mockito.reset((Object[])new SchedulerService[]{muleContext.getSchedulerService()});
        Mockito.when((Object)this.result.getMediaType()).thenReturn(Optional.of(MediaType.ANY));
        Mockito.when((Object)this.result.getAttributes()).thenReturn(Optional.empty());
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("_muleStreamingManager", (Object)this.streamingManager);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        this.cursorStreamProviderFactory = ExtensionsTestUtils.getDefaultCursorStreamProviderFactory(this.streamingManager);
        this.sourceAdapter = this.createSourceAdapter();
        Mockito.when((Object)this.sourceAdapterFactory.createAdapter((Optional)ArgumentMatchers.any(), (SourceCallbackFactory)ArgumentMatchers.any(), (Component)ArgumentMatchers.any(), (SourceConnectionManager)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)this.sourceAdapter);
        Mockito.when((Object)this.sourceAdapterFactory.getSourceParameters()).thenReturn((Object)new ResolverSet(muleContext));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, null);
        Mockito.when((Object)this.sourceModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getModelProperty(SourceCallbackModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.setRequires((EnrichableModel)this.sourceModel, true, true);
        Mockito.when((Object)this.sourceModel.getOutput().getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.sourceModel.getNotificationModels()).thenReturn(Collections.emptySet());
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, null);
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel, ((Object)((Object)this)).getClass().getClassLoader());
        LifecycleUtils.initialiseIfNeeded((Object)this.retryPolicyTemplate, (MuleContext)muleContext);
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("_muleExtensionManager", (Object)this.extensionManager);
        Mockito.when((Object)this.flowConstruct.getMuleContext()).thenReturn((Object)muleContext);
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel[0]);
        Mockito.when((Object)this.configurationModel.getSourceModel(SOURCE_NAME)).thenReturn(Optional.of(this.sourceModel));
        Mockito.when((Object)this.extensionManager.getConfigurationProvider(CONFIG_NAME)).thenReturn(Optional.of(this.configurationProvider));
        Mockito.when((Object)this.extensionManager.getExtensions()).thenReturn(Collections.singleton(this.extensionModel));
        Mockito.when((Object)this.configurationProvider.get((Event)ArgumentMatchers.any())).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)this.configurationProvider.getConfigurationModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.configurationProvider.getName()).thenReturn((Object)CONFIG_NAME);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, this.metadataResolverFactory);
        Mockito.when((Object)this.metadataResolverFactory.getKeyResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getInputResolver("content")).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getInputResolver("type")).thenReturn((Object)new NullMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getOutputResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getOutputAttributesResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("metadata.cache.id.model.generator.factory", this.cacheIdGeneratorFactory);
        Mockito.when((Object)this.cacheIdGeneratorFactory.create((DslResolvingContext)ArgumentMatchers.any(), (ComponentLocator)ArgumentMatchers.any())).thenReturn(this.cacheIdGenerator);
        Mockito.when((Object)this.cacheIdGenerator.getIdForComponentMetadata(ArgumentMatchers.any())).then(invocation -> Optional.of(new MetadataCacheId(UUID.getUUID(), null)));
        Mockito.when((Object)this.cacheIdGenerator.getIdForGlobalMetadata(ArgumentMatchers.any())).then(invocation -> Optional.of(new MetadataCacheId(UUID.getUUID(), null)));
        Mockito.when((Object)this.cacheIdGenerator.getIdForMetadataKeys(ArgumentMatchers.any())).then(invocation -> Optional.of(new MetadataCacheId(UUID.getUUID(), null)));
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Output", (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build(), true, Collections.emptySet()));
        Mockito.when((Object)this.sourceModel.getOutputAttributes()).thenReturn((Object)new ImmutableOutputModel("Output", (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build(), false, Collections.emptySet()));
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(this.typeLoader.load(String.class), METADATA_KEY)));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.messageProcessContext.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentLocator.find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.of(this.flowConstruct));
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("_muleConfigurationComponentLocator", (Object)this.componentLocator);
        this.messageSource = this.getNewExtensionMessageSourceInstance();
        this.sourceCallback = DefaultSourceCallback.builder((ProfilingService)this.profilingService).setSourceModel(this.sourceModel).setProcessingManager(this.messageProcessingManager).setListener(this.messageProcessor).setSource(this.messageSource).setProcessContext(this.messageProcessContext).setApplicationName(muleContext.getConfiguration().getId()).setNotificationDispatcher(this.notificationDispatcher).setTransactionFactoryManager(muleContext.getTransactionFactoryManager()).setCompletionHandlerFactory(this.completionHandlerFactory).setExceptionCallback(this.exceptionCallback).setCursorStreamProviderFactory((CursorProviderFactory)this.cursorStreamProviderFactory).setMuleContext(muleContext).build();
        Mockito.when((Object)this.sourceCallbackFactory.createSourceCallback((SourceCompletionHandlerFactory)ArgumentMatchers.any())).thenReturn((Object)this.sourceCallback);
    }

    @After
    public void after() throws MuleException {
        try {
            if (this.messageSource.getLifecycleState().isStarted()) {
                this.messageSource.stop();
            }
        }
        finally {
            if (this.messageSource.getLifecycleState().isStopped() || this.messageSource.getLifecycleState().isInitialised()) {
                this.messageSource.dispose();
            }
        }
    }

    protected SourceAdapter createSourceAdapter() {
        return new SourceAdapter(this.extensionModel, this.sourceModel, this.source, Optional.of(this.configurationInstance), (CursorProviderFactory)new NullCursorStreamProviderFactory((ByteBufferManager)new SimpleByteBufferManager(), this.streamingManager), this.sourceCallbackFactory, (Component)Mockito.mock(Component.class), (SourceConnectionManager)Mockito.mock(SourceConnectionManager.class), null, this.callbackParameters, null, Optional.of(BackPressureAction.FAIL));
    }

    protected ExtensionMessageSource getNewExtensionMessageSourceInstance() throws MuleException {
        ExtensionMessageSource messageSource = new ExtensionMessageSource(this.extensionModel, this.sourceModel, this.sourceAdapterFactory, this.configurationProvider, this.primaryNodeOnly, this.retryPolicyTemplate, (CursorProviderFactory)this.cursorStreamProviderFactory, MessageSource.BackPressureStrategy.FAIL, this.extensionManager, this.notificationDispatcher, muleContext.getTransactionFactoryManager(), muleContext.getConfiguration().getId());
        messageSource.setListener(this.messageProcessor);
        messageSource.setAnnotations(AbstractExtensionMessageSourceTestCase.getAppleFlowComponentLocationAnnotations());
        muleContext.getInjector().inject((Object)messageSource);
        return messageSource;
    }
}

