/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractPipeline;
import org.mule.runtime.core.internal.exception.ExceptionRouter;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.FlowProcessMediator;
import org.mule.runtime.core.internal.execution.FlowProcessTemplate;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.SourcePolicyTestUtils;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionsFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
public class ModuleFlowProcessingTemplateTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private SourceResultAdapter message;
    @Mock
    private DistributedTraceContextGetter distributedTraceContextGetter;
    @Mock
    private CoreEvent event;
    @Mock
    private Processor messageProcessor;
    @Mock
    private SourceCompletionHandler completionHandler;
    @Mock(lenient=true)
    private MessagingException messagingException;
    @Mock
    private Map<String, Object> mockParameters;
    private final RuntimeException runtimeException = new RuntimeException();
    private ExtensionsFlowProcessingTemplate template;
    private final AtomicReference<CoreEvent> atomicEvent = new AtomicReference();
    private FlowProcessMediator flowProcessMediator;
    private MessageProcessContext context;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.distributedTraceContextGetter.get((String)ArgumentMatchers.any(String.class))).thenReturn(Optional.empty());
        Mockito.when((Object)this.message.getDistributedTraceContextGetter()).thenReturn((Object)this.distributedTraceContextGetter);
        this.template = new ExtensionsFlowProcessingTemplate(this.message, this.messageProcessor, Collections.emptyList(), this.completionHandler);
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> callback.complete(null))).when((Object)this.completionHandler)).onCompletion((CoreEvent)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (CompletableCallback)ArgumentMatchers.any());
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> callback.complete(null))).when((Object)this.completionHandler)).onFailure((MessagingException)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (CompletableCallback)ArgumentMatchers.any());
    }

    @Test
    public void getMuleEvent() throws Exception {
        Assert.assertThat((Object)this.template.getSourceMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.message)));
    }

    @Test
    public void routeEvent() throws Exception {
        this.template.routeEvent(this.event);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).process(this.event);
    }

    @Test
    public void routeEventAsync() throws Exception {
        Mockito.when((Object)this.messageProcessor.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.event));
        this.template.routeEventAsync(this.event);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).apply((Publisher)ArgumentMatchers.any(Publisher.class));
    }

    @Test
    public void sendResponseToClient() throws Throwable {
        Reference callbackReference = new Reference();
        SourcePolicyTestUtils.block(callback -> {
            callbackReference.set(callback);
            this.template.sendResponseToClient(this.event, this.mockParameters, callback);
        });
        Assert.assertThat((Object)callbackReference, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler)).onCompletion((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.same((Object)callbackReference.get()));
    }

    @Test
    public void failedToSendResponseToClient() throws Throwable {
        final Reference exceptionReference = new Reference();
        Reference callbackReference = new Reference();
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> {
            callbackReference.set(callback);
            callback.error((Throwable)this.runtimeException);
        })).when((Object)this.completionHandler)).onCompletion((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.any());
        try {
            SourcePolicyTestUtils.block(callback -> {
                callback = callback.before((CompletableCallback)new CompletableCallback<Void>(){

                    public void complete(Void value) {
                    }

                    public void error(Throwable e) {
                        exceptionReference.set((Object)e);
                    }
                });
                this.template.sendResponseToClient(this.event, this.mockParameters, callback);
            });
            Assert.fail((String)"This should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.runtimeException)));
        }
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler, (VerificationMode)Mockito.never())).onFailure((MessagingException)ArgumentMatchers.any(MessagingException.class), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.any());
        Assert.assertThat((Object)exceptionReference.get(), (Matcher)CoreMatchers.equalTo((Object)this.runtimeException));
    }

    @Test
    public void sendFailureResponseToClient() throws Throwable {
        Reference callbackReference = new Reference();
        SourcePolicyTestUtils.block(callback -> {
            callbackReference.set(callback);
            this.template.sendFailureResponseToClient(this.messagingException, this.mockParameters, callback);
        });
        Assert.assertThat((Object)callbackReference.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler)).onFailure(this.messagingException, this.mockParameters, (CompletableCallback)callbackReference.get());
    }

    @Test
    public void failedToSendFailureResponseToClient() throws Throwable {
        final Reference exceptionReference = new Reference();
        Mockito.when((Object)this.messagingException.getEvent()).thenReturn((Object)this.event);
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> callback.error((Throwable)this.runtimeException))).when((Object)this.completionHandler)).onFailure((MessagingException)ArgumentMatchers.same((Object)this.messagingException), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.any());
        try {
            SourcePolicyTestUtils.block(callback -> {
                callback = callback.before((CompletableCallback)new CompletableCallback<Void>(){

                    public void complete(Void value) {
                    }

                    public void error(Throwable e) {
                        exceptionReference.set((Object)e);
                    }
                });
                this.template.sendFailureResponseToClient(this.messagingException, this.mockParameters, callback);
            });
            Assert.fail((String)"This should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.runtimeException)));
        }
        Assert.assertThat((Object)exceptionReference.get(), (Matcher)CoreMatchers.equalTo((Object)this.runtimeException));
    }

    @Test
    @Issue(value="MULE-19869")
    @Description(value="Set template field to null after phase execution to avoid a leak when creating reactor chains")
    public void templateSetToNullAfterPhaseExecution() throws Exception {
        this.initFlowProcessMediator();
        this.flowProcessMediator.process((FlowProcessTemplate)this.template, this.context);
        Assert.assertThat((Object)this.template.getSourceMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void initFlowProcessMediator() throws Exception {
        PolicyManager policyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        SourcePolicy sourcePolicy = (SourcePolicy)Mockito.mock(SourcePolicy.class);
        Mockito.when((Object)policyManager.createSourcePolicyInstance((Component)ArgumentMatchers.any(), (CoreEvent)ArgumentMatchers.any(), (ReactiveProcessor)ArgumentMatchers.any(), (MessageSourceResponseParametersProcessor)ArgumentMatchers.any())).thenReturn((Object)sourcePolicy);
        Mockito.when((Object)policyManager.addSourcePointcutParametersIntoEvent((Component)ArgumentMatchers.any(), (TypedValue)ArgumentMatchers.any(), (InternalEvent)ArgumentMatchers.any())).thenAnswer(inv -> {
            PolicyPointcutParameters pointcutParams = (PolicyPointcutParameters)Mockito.mock(PolicyPointcutParameters.class);
            SourcePolicyContext sourcePolicyCtx = new SourcePolicyContext(pointcutParams);
            InternalEvent invEvent = (InternalEvent)inv.getArgument(2, InternalEvent.class);
            invEvent.setSourcePolicyContext((EventInternalContext)sourcePolicyCtx);
            this.atomicEvent.set((CoreEvent)inv.getArgument(2, InternalEvent.class));
            return pointcutParams;
        });
        SourcePolicySuccessResult successResult = (SourcePolicySuccessResult)Mockito.mock(SourcePolicySuccessResult.class);
        Mockito.when((Object)successResult.getResult()).then(invocation -> this.atomicEvent.get());
        Mockito.when((Object)successResult.getResponseParameters()).thenReturn(Collections::emptyMap);
        Mockito.when((Object)successResult.createErrorResponseParameters()).thenReturn(event -> Collections.emptyMap());
        SourcePolicyFailureResult failureResult = (SourcePolicyFailureResult)Mockito.mock(SourcePolicyFailureResult.class);
        Mockito.when((Object)failureResult.getMessagingException()).then(invocation -> this.messagingException);
        Mockito.when((Object)failureResult.getResult()).then(invocation -> this.messagingException.getEvent());
        Mockito.when((Object)failureResult.getErrorResponseParameters()).thenReturn(Collections::emptyMap);
        ((SourcePolicy)Mockito.doAnswer(inv -> {
            CoreEvent event = (CoreEvent)inv.getArgument(0);
            CompletableCallback callback = (CompletableCallback)inv.getArgument(2);
            SourcePolicyContext.from((CoreEvent)event).configure((MessageSourceResponseParametersProcessor)inv.getArgument(1), callback);
            callback.complete((Object)Either.right((Object)successResult));
            return null;
        }).when((Object)sourcePolicy)).process((CoreEvent)ArgumentMatchers.any(), (MessageSourceResponseParametersProcessor)ArgumentMatchers.any(), (CompletableCallback)ArgumentMatchers.any());
        PhaseResultNotifier notifier = (PhaseResultNotifier)Mockito.mock(PhaseResultNotifier.class);
        this.flowProcessMediator = new FlowProcessMediator(policyManager, notifier);
        LifecycleUtils.initialiseIfNeeded((Object)this.flowProcessMediator, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded((Object)this.flowProcessMediator);
        AbstractPipeline flow = (AbstractPipeline)Mockito.mock(AbstractPipeline.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        Mockito.when((Object)flow.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)"flow"));
        FlowExceptionHandler exceptionHandler = (FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class);
        ArgumentCaptor propagateConsumerCaptor = ArgumentCaptor.forClass(Consumer.class);
        ExceptionRouter flowErrorHandlerRouter = (ExceptionRouter)Mockito.mock(ExceptionRouter.class);
        ((ExceptionRouter)Mockito.doAnswer(inv -> {
            ((Consumer)propagateConsumerCaptor.getValue()).accept(inv.getArgument(0));
            return null;
        }).when((Object)flowErrorHandlerRouter)).accept(ArgumentMatchers.any(Exception.class));
        Mockito.when((Object)exceptionHandler.router((Function)ArgumentMatchers.any(Function.class), (Consumer)ArgumentMatchers.any(Consumer.class), (Consumer)propagateConsumerCaptor.capture())).thenReturn((Object)flowErrorHandlerRouter);
        MessageSource source = (MessageSource)Mockito.mock(MessageSource.class);
        Mockito.when((Object)source.getRootContainerLocation()).thenReturn((Object)Location.builder().globalName("root").build());
        Mockito.when((Object)source.getLocation()).thenReturn(Mockito.mock(ComponentLocation.class));
        Mockito.when((Object)flow.errorRouterForSourceResponseError((Function)ArgumentMatchers.any())).thenAnswer(inv -> exceptionHandler.router(Function.identity(), event -> ((Consumer)((Function)inv.getArgument(0, Function.class)).apply(flow)).accept((Exception)((Error)event.getError().get()).getCause()), error -> ((Consumer)((Function)inv.getArgument(0, Function.class)).apply(flow)).accept((Exception)error)));
        Mockito.when((Object)flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        Mockito.when((Object)flow.getSource()).thenReturn((Object)source);
        Mockito.when((Object)flow.getMuleContext()).thenReturn((Object)muleContext);
        Mockito.when((Object)flow.getStatistics()).thenReturn((Object)new DefaultFlowConstructStatistics("Flow", "flow"));
        this.context = (MessageProcessContext)Mockito.mock(MessageProcessContext.class);
        Mockito.when((Object)this.context.getMessageSource()).thenReturn((Object)source);
        Mockito.when((Object)this.context.getMessagingExceptionResolver()).thenReturn((Object)new MessagingExceptionResolver((Component)source));
        Mockito.when((Object)this.context.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getFlowConstruct()).thenReturn((Object)flow);
        SourceResultAdapter resultAdapter = (SourceResultAdapter)Mockito.mock(SourceResultAdapter.class);
        Mockito.when((Object)resultAdapter.getResult()).thenReturn((Object)Result.builder().build());
        Mockito.when((Object)resultAdapter.getMediaType()).thenReturn((Object)MediaType.ANY);
        Mockito.when((Object)resultAdapter.getDistributedTraceContextGetter()).thenReturn((Object)this.distributedTraceContextGetter);
        this.template = new ExtensionsFlowProcessingTemplate(resultAdapter, this.messageProcessor, Collections.emptyList(), this.completionHandler);
    }
}

