/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.store;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreAdapter;
import org.mule.sdk.api.store.ObjectStore;

public class SdkObjectStoreAdapterTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private org.mule.runtime.api.store.ObjectStore muleObjectStore;

    @Before
    public void setup() {
        this.muleObjectStore = (org.mule.runtime.api.store.ObjectStore)Mockito.mock(org.mule.runtime.api.store.ObjectStore.class);
    }

    @Test
    public void nullValueCannotBeAdaptedAndThrowsException() {
        this.expectedException.expect(IllegalArgumentException.class);
        SdkObjectStoreAdapter.from(null);
    }

    @Test
    public void muleObjectStoreIsAdaptedToSdkObjectStore() {
        MatcherAssert.assertThat((Object)SdkObjectStoreAdapter.from((Object)this.muleObjectStore), (Matcher)CoreMatchers.instanceOf(ObjectStore.class));
    }

    @Test
    public void sdkObjectStoreIsNotAdapted() {
        ObjectStore objectStore = SdkObjectStoreAdapter.from((Object)this.muleObjectStore);
        MatcherAssert.assertThat((Object)SdkObjectStoreAdapter.from((Object)objectStore), (Matcher)CoreMatchers.sameInstance((Object)objectStore));
    }

    @Test
    public void muleObjectStoreExceptionIsThrown() throws Exception {
        ((org.mule.runtime.api.store.ObjectStore)Mockito.doThrow(ObjectStoreException.class).when((Object)this.muleObjectStore)).clear();
        this.expectedException.expect(ObjectStoreException.class);
        SdkObjectStoreAdapter.from((Object)this.muleObjectStore).clear();
    }

    @Test
    public void muleObjectAlreadyExistsExceptionIsThrown() throws Exception {
        ((org.mule.runtime.api.store.ObjectStore)Mockito.doThrow(ObjectAlreadyExistsException.class).when((Object)this.muleObjectStore)).store("key", (Serializable)((Object)"value"));
        this.expectedException.expect(ObjectAlreadyExistsException.class);
        SdkObjectStoreAdapter.from((Object)this.muleObjectStore).store("key", (Serializable)((Object)"value"));
    }

    @Test
    public void muleObjectDoesNotExistExceptionIsThrown() throws Exception {
        ((org.mule.runtime.api.store.ObjectStore)Mockito.doThrow(ObjectDoesNotExistException.class).when((Object)this.muleObjectStore)).remove("key");
        this.expectedException.expect(ObjectDoesNotExistException.class);
        SdkObjectStoreAdapter.from((Object)this.muleObjectStore).remove("key");
    }

    @Test
    public void muleObjectStoreNotAvailableExceptionIsThrown() throws Exception {
        ((org.mule.runtime.api.store.ObjectStore)Mockito.doThrow(ObjectStoreNotAvailableException.class).when((Object)this.muleObjectStore)).contains("key");
        this.expectedException.expect(ObjectStoreNotAvailableException.class);
        SdkObjectStoreAdapter.from((Object)this.muleObjectStore).contains("key");
    }
}

