/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.store;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreAdapter;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreManagerAdapter;
import org.mule.sdk.api.store.ObjectStore;
import org.mule.sdk.api.store.ObjectStoreSettings;

public class SdkObjectStoreManagerAdapterTestCase {
    private static final String OS_NAME = "test-os";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ObjectStoreManager muleObjectStoreManager;
    private org.mule.runtime.api.store.ObjectStore muleObjectStore;
    private SdkObjectStoreManagerAdapter sdkObjectStoreManagerAdapter;

    @Before
    public void setup() {
        this.muleObjectStoreManager = (ObjectStoreManager)Mockito.mock(ObjectStoreManager.class);
        this.muleObjectStore = (org.mule.runtime.api.store.ObjectStore)Mockito.mock(org.mule.runtime.api.store.ObjectStore.class);
        Mockito.when((Object)this.muleObjectStoreManager.createObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME), (org.mule.runtime.api.store.ObjectStoreSettings)ArgumentMatchers.any())).thenReturn((Object)this.muleObjectStore);
        Mockito.when((Object)this.muleObjectStoreManager.getObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME))).thenReturn((Object)this.muleObjectStore);
        Mockito.when((Object)this.muleObjectStoreManager.getOrCreateObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME), (org.mule.runtime.api.store.ObjectStoreSettings)ArgumentMatchers.any())).thenReturn((Object)this.muleObjectStore);
        this.sdkObjectStoreManagerAdapter = new SdkObjectStoreManagerAdapter();
        this.sdkObjectStoreManagerAdapter.setDelegate(this.muleObjectStoreManager);
    }

    @Test
    public void adapterIsAnSdkObjectStoreManager() {
        MatcherAssert.assertThat((Object)this.sdkObjectStoreManagerAdapter, (Matcher)CoreMatchers.instanceOf(org.mule.sdk.api.store.ObjectStoreManager.class));
    }

    @Test
    public void muleObjectStoreIsCreatedAndAdaptedToSdkObjectStore() {
        ObjectStore sdkObjectStore = this.sdkObjectStoreManagerAdapter.createObjectStore(OS_NAME, ObjectStoreSettings.builder().build());
        MatcherAssert.assertThat((Object)sdkObjectStore, (Matcher)CoreMatchers.instanceOf(SdkObjectStoreAdapter.class));
        ((ObjectStoreManager)Mockito.verify((Object)this.muleObjectStoreManager, (VerificationMode)Mockito.times((int)1))).createObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME), (org.mule.runtime.api.store.ObjectStoreSettings)ArgumentMatchers.any());
    }

    @Test
    public void muleObjectStoreIsRetrievedAndAdaptedToSdkObjectStore() {
        ObjectStore sdkObjectStore = this.sdkObjectStoreManagerAdapter.getObjectStore(OS_NAME);
        MatcherAssert.assertThat((Object)sdkObjectStore, (Matcher)CoreMatchers.instanceOf(SdkObjectStoreAdapter.class));
        ((ObjectStoreManager)Mockito.verify((Object)this.muleObjectStoreManager, (VerificationMode)Mockito.times((int)1))).getObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME));
    }

    @Test
    public void muleObjectStoreIsCreatedOrRetrievedAndAdaptedToSdkObjectStore() {
        ObjectStore sdkObjectStore = this.sdkObjectStoreManagerAdapter.getOrCreateObjectStore(OS_NAME, ObjectStoreSettings.builder().build());
        MatcherAssert.assertThat((Object)sdkObjectStore, (Matcher)CoreMatchers.instanceOf(SdkObjectStoreAdapter.class));
        ((ObjectStoreManager)Mockito.verify((Object)this.muleObjectStoreManager, (VerificationMode)Mockito.times((int)1))).getOrCreateObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME), (org.mule.runtime.api.store.ObjectStoreSettings)ArgumentMatchers.any());
    }

    @Test
    public void muleObjectStoreIsDisposed() throws Exception {
        this.sdkObjectStoreManagerAdapter.disposeStore(OS_NAME);
        ((ObjectStoreManager)Mockito.verify((Object)this.muleObjectStoreManager, (VerificationMode)Mockito.times((int)1))).disposeStore((String)ArgumentMatchers.eq((Object)OS_NAME));
    }

    @Test
    public void sdkObjectStoreSettingsAreConvertedToMuleObjectStoreSettings() {
        ObjectStoreSettings sdkObjectStoreSettings = ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(100)).entryTtl(Long.valueOf(1000L)).expirationInterval(Long.valueOf(5000L)).build();
        this.sdkObjectStoreManagerAdapter.createObjectStore(OS_NAME, sdkObjectStoreSettings);
        ArgumentCaptor settingsArgumentCaptor = ArgumentCaptor.forClass(org.mule.runtime.api.store.ObjectStoreSettings.class);
        ((ObjectStoreManager)Mockito.verify((Object)this.muleObjectStoreManager, (VerificationMode)Mockito.times((int)1))).createObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME), (org.mule.runtime.api.store.ObjectStoreSettings)settingsArgumentCaptor.capture());
        org.mule.runtime.api.store.ObjectStoreSettings muleObjectStoreSettings = (org.mule.runtime.api.store.ObjectStoreSettings)settingsArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)muleObjectStoreSettings.isPersistent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(muleObjectStoreSettings.getMaxEntries().get(), (Matcher)CoreMatchers.is((Object)100));
        MatcherAssert.assertThat(muleObjectStoreSettings.getEntryTTL().get(), (Matcher)CoreMatchers.is((Object)1000L));
        MatcherAssert.assertThat((Object)muleObjectStoreSettings.getExpirationInterval(), (Matcher)CoreMatchers.is((Object)5000L));
    }

    @Test
    public void defaultSdkObjectStoreSettingsAreConvertedToDefaultMuleObjectStoreSettings() {
        this.sdkObjectStoreManagerAdapter.createObjectStore(OS_NAME, ObjectStoreSettings.builder().build());
        ArgumentCaptor settingsArgumentCaptor = ArgumentCaptor.forClass(org.mule.runtime.api.store.ObjectStoreSettings.class);
        ((ObjectStoreManager)Mockito.verify((Object)this.muleObjectStoreManager, (VerificationMode)Mockito.times((int)1))).createObjectStore((String)ArgumentMatchers.eq((Object)OS_NAME), (org.mule.runtime.api.store.ObjectStoreSettings)settingsArgumentCaptor.capture());
        org.mule.runtime.api.store.ObjectStoreSettings muleObjectStoreSettings = (org.mule.runtime.api.store.ObjectStoreSettings)settingsArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)muleObjectStoreSettings.isPersistent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)muleObjectStoreSettings.getMaxEntries().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)muleObjectStoreSettings.getEntryTTL().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)muleObjectStoreSettings.getExpirationInterval(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.store.ObjectStoreSettings.DEFAULT_EXPIRATION_INTERVAL));
    }

    @Test
    public void onFailureMuleObjectStoreExceptionIsThrown() throws Exception {
        ((ObjectStoreManager)Mockito.doThrow(ObjectStoreException.class).when((Object)this.muleObjectStoreManager)).disposeStore((String)ArgumentMatchers.eq((Object)OS_NAME));
        this.expectedException.expect(ObjectStoreException.class);
        this.sdkObjectStoreManagerAdapter.disposeStore(OS_NAME);
    }
}

