/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.testing.compile.CompilationRule;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.meta.ExpressionSupport;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBox;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PhoneNumber;
import org.mule.test.petstore.extension.TransactionalPetStoreClient;
import org.mule.test.petstore.extension.TransactionalPetStoreConnectionProvider;
import org.springframework.core.ResolvableType;

@SmallTest
@RunWith(value=Parameterized.class)
public class IntrospectionUtilsTestCase
extends AbstractMuleTestCase {
    private static final String CLASS = "CLASS";
    public static final String OPERATION_RESULT = "operationResult";
    public static final String PAGING_PROVIDER = "pagingProvider";
    public static final String PAGING_PROVIDER_OPERATION_RESULT = "pagingProviderOperationResult";
    public static final String FOO = "foo";
    public static final String LIST_RESULT_STRING = "listResultStringObject";
    public static ProcessingEnvironment processingEnvironment;
    private List<FruitBasket> baskets;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    @Rule
    public CompilationRule compilationRule = new CompilationRule();
    private final ReflectionCache reflectionCache = new ReflectionCache();
    @Parameterized.Parameter
    public String mode;
    @Parameterized.Parameter(value=1)
    public BiFunction<String, Class[], OperationElement> operationSupplier;
    @Parameterized.Parameter(value=2)
    public Function<Class, Type> typeSupplier;
    @Parameterized.Parameter(value=3)
    public Function<Class, SourceElement> sourceSupplier;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        Function<Class, Type> javaTypeSupplier = aClass -> new TypeWrapper(aClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader());
        objects.add(new Object[]{CLASS, new ClassOperationSupplier(), javaTypeSupplier, new ClassSourceSupplier()});
        return objects;
    }

    @Before
    public void setUp() {
        processingEnvironment = (ProcessingEnvironment)Mockito.mock(ProcessingEnvironment.class);
        Mockito.when((Object)processingEnvironment.getTypeUtils()).thenReturn((Object)this.compilationRule.getTypes());
        Mockito.when((Object)processingEnvironment.getElementUtils()).thenReturn((Object)this.compilationRule.getElements());
    }

    @Test
    public void getMethodReturnType() throws Exception {
        MetadataType metadataType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(FOO, new Class[0]));
        this.assertDictionary(metadataType, Apple.class);
    }

    @Test
    public void getObjectMethodReturnType() throws Exception {
        MetadataType metadataType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod("methodReturnObject", new Class[0]));
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
    }

    @Test
    public void getGenericsFromReturnType() throws Exception {
        OperationElement listResultStringObject = this.getMethod(LIST_RESULT_STRING, null);
        Type returnType = listResultStringObject.getReturnType();
        List listGeneric = returnType.getSuperTypeGenerics(Collection.class);
        Assert.assertThat((Object)((Type)listGeneric.get(0)).getTypeName(), (Matcher)CoreMatchers.containsString((String)"Result"));
        List resultGenerics = ((Type)listGeneric.get(0)).getSuperTypeGenerics(Result.class);
        Assert.assertThat((Object)((Type)resultGenerics.get(0)).getTypeName(), (Matcher)CoreMatchers.containsString((String)"String"));
    }

    @Test
    public void getGenericsFromIndirectInterface() throws Exception {
        Type classType = this.typeSupplier.apply(OtherClass.class);
        List listGeneric = classType.getSuperTypeGenerics(RootInterface.class);
        Assert.assertThat((Object)((Type)listGeneric.get(0)).getTypeName(), (Matcher)CoreMatchers.containsString((String)"Integer"));
        Assert.assertThat((Object)((Type)listGeneric.get(1)).getTypeName(), (Matcher)CoreMatchers.containsString((String)"String"));
    }

    @Test
    public void getOperationResultReturnType() throws Exception {
        this.assertReturnType(OPERATION_RESULT);
        this.assertAttributesType(OPERATION_RESULT);
    }

    @Test
    public void getPagingProviderReturnType() throws Exception {
        this.assertPagingProviderReturnType(PAGING_PROVIDER);
        this.assertVoidAttributesType(PAGING_PROVIDER);
    }

    @Test
    public void getPagingProviderOperationResultReturnType() throws Exception {
        this.assertPagingProviderReturnResultType(PAGING_PROVIDER_OPERATION_RESULT);
        this.assertVoidAttributesType(PAGING_PROVIDER_OPERATION_RESULT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodReturnType() {
        IntrospectionUtils.getMethodReturnType(null);
    }

    @Test
    public void getArgumentlessMethodArgumentTypes() throws Exception {
        Assume.assumeThat((Object)this.mode, (Matcher)CoreMatchers.is((Object)CLASS));
        MetadataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)((Method)this.getMethod(FOO, new Class[0]).getMethod().get()), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        junit.framework.Assert.assertNotNull((Object)types);
        junit.framework.Assert.assertEquals((int)0, (int)types.length);
    }

    @Test
    public void getMethodArgumentTypes() throws Exception {
        Assume.assumeThat((Object)this.mode, (Matcher)CoreMatchers.is((Object)CLASS));
        MetadataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)((Method)this.getMethod("bar", String.class, Long.class, Apple.class, Map.class).getMethod().get()), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        junit.framework.Assert.assertNotNull((Object)types);
        junit.framework.Assert.assertEquals((int)4, (int)types.length);
        this.assertType(types[0], String.class);
        this.assertType(types[1], Long.class);
        this.assertType(types[2], Apple.class);
        this.assertDictionary(types[3], Kiwi.class);
    }

    @Test
    public void getInterfaceGenerics() {
        Type connectionProvider = this.typeSupplier.apply(TransactionalPetStoreConnectionProvider.class);
        List interfaceGenerics = connectionProvider.getSuperTypeGenerics(ConnectionProvider.class);
        Assert.assertThat((Object)interfaceGenerics.size(), (Matcher)CoreMatchers.is((Object)1));
        Type type = (Type)interfaceGenerics.get(0);
        Assert.assertThat((Object)type.isSameType(TransactionalPetStoreClient.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void resultWithNoGenericsIsAnyType() throws Exception {
        MetadataType resultWithNoGenerics = this.getMethod("resultWithNoGenerics", new Class[0]).getReturnMetadataType();
        MetadataType resultWithWildcardGenerics = this.getMethod("resultWithWildcardGenerics", new Class[0]).getReturnMetadataType();
        Assert.assertThat((Object)resultWithNoGenerics, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
        Assert.assertThat((Object)resultWithWildcardGenerics, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodArgumentTypes() throws Exception {
        IntrospectionUtils.getMethodArgumentTypes(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getFieldDataType() throws Exception {
        MetadataType type = IntrospectionUtils.getFieldMetadataType((Field)IntrospectionUtilsTestCase.class.getDeclaredField("baskets"), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        this.assertList(type, FruitBasket.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullFieldDataType() throws Exception {
        IntrospectionUtils.getFieldMetadataType(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getEmptyExposedPojoFields() {
        Collection exposedFields = IntrospectionUtils.getExposedFields(FruitBasket.class, (ReflectionCache)this.reflectionCache);
        Assert.assertThat((Object)exposedFields, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void getFieldsWithGettersOnly() {
        Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(PhoneNumber.class, (ReflectionCache)this.reflectionCache);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void getRawListReturnTypeNoGenerics() {
        Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(PhoneNumber.class, (ReflectionCache)this.reflectionCache);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void getWildCardFieldsDataTypes() {
        Set exposedFields = IntrospectionUtils.getFieldsWithGetters(FruitBox.class, (ReflectionCache)this.reflectionCache);
        junit.framework.Assert.assertNotNull((Object)exposedFields);
        junit.framework.Assert.assertEquals((int)6, (int)exposedFields.size());
        this.assertField("fruitLikeList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Fruit.class)), exposedFields);
        this.assertField("wildCardList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("rawList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("wildCardMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("rawMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("fruitLikeMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Fruit.class)), exposedFields);
    }

    @Test
    public void getDataTypeFromList() {
        Class<List> listClass = List.class;
        Class<Integer> integerClass = Integer.class;
        ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().with((TypeAnnotation)new ClassInformationAnnotation(listClass));
        arrayTypeBuilder.of().numberType().integer();
        CollectionDataType dataType = (CollectionDataType)IntrospectionUtils.toDataType((MetadataType)arrayTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(listClass)));
        Assert.assertThat((Object)dataType.getItemDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(integerClass)));
    }

    @Test
    public void getDataTypeFromMap() {
        Class<Date> dateClass = Date.class;
        Class<Map> mapClass = Map.class;
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class));
        objectTypeBuilder.openWith().objectType().id(dateClass.getName()).with((TypeAnnotation)new ClassInformationAnnotation(dateClass));
        MapDataType dataType = (MapDataType)IntrospectionUtils.toDataType((MetadataType)objectTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(mapClass)));
        Assert.assertThat((Object)dataType.getKeyDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
        Assert.assertThat((Object)dataType.getValueDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(dateClass)));
    }

    @Test
    public void getDataTypeFromObject() {
        Class<Object> objectClass = Object.class;
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(objectClass.getName());
        DataType dataType = IntrospectionUtils.toDataType((MetadataType)objectTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(objectClass)));
    }

    @Test
    public void getDataTypeFromString() {
        StringTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType();
        DataType dataType = IntrospectionUtils.toDataType((MetadataType)typeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
    }

    @Test
    public void getPagingProviderImplementationTypes() {
        ResolvableType pagingProvider = ResolvableType.forClass(TestPagingProvider.class);
        Pair pagingProviderTypes = IntrospectionUtils.getPagingProviderTypes((Type)new TypeWrapper(pagingProvider, ExtensionsTestUtils.TYPE_LOADER));
        Assert.assertThat(((Type)pagingProviderTypes.getFirst()).getDeclaringClass().get(), (Matcher)CoreMatchers.equalTo(Object.class));
        Assert.assertThat(((Type)pagingProviderTypes.getSecond()).getDeclaringClass().get(), (Matcher)CoreMatchers.equalTo(Result.class));
    }

    @Test
    public void getPagingProviderImplementationTypesReturnType() throws Exception {
        OperationElement getPagingProvider = this.getMethod("getPagingProvider", new Class[0]);
        MetadataType methodReturnType = IntrospectionUtils.getMethodReturnType((MethodElement)getPagingProvider);
        Assert.assertThat((Object)methodReturnType, (Matcher)CoreMatchers.instanceOf(ArrayType.class));
        MetadataType valueType = ((ArrayType)methodReturnType).getType();
        Assert.assertThat((Object)valueType, (Matcher)CoreMatchers.instanceOf(MessageMetadataType.class));
        MessageMetadataType messageType = (MessageMetadataType)valueType;
        MetadataType payloadType = (MetadataType)messageType.getPayloadType().get();
        MetadataType attributesTypes = (MetadataType)messageType.getAttributesType().get();
        Assert.assertThat((Object)((TypeIdAnnotation)payloadType.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)Banana.class.getName()));
        Assert.assertThat((Object)((TypeIdAnnotation)attributesTypes.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)Apple.class.getName()));
    }

    @Test
    public void getProperties() {
        Set fields = IntrospectionUtils.getFieldsWithGetters(SomePojo.class, (ReflectionCache)this.reflectionCache);
        Type somePojo = this.typeSupplier.apply(SomePojo.class);
        List fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters((Type)somePojo);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)fields.size()));
    }

    @Test
    public void listWithNoGenerics() throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod("listNoGenerics", new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.instanceOf(ArrayType.class));
        Assert.assertThat((Object)((ArrayType)returnType).getType(), (Matcher)CoreMatchers.instanceOf(ObjectType.class));
    }

    @Test
    public void mapWithNoGenerics() throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod("mapNoGenerics", new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        Assert.assertThat(((ObjectType)returnType).getOpenRestriction().get(), (Matcher)CoreMatchers.instanceOf(AnyType.class));
    }

    @Test
    public void getSourceGenerics() {
        Type type = this.typeSupplier.apply(ThirdLevelSource.class);
        List superTypeGenerics = type.getSuperTypeGenerics(Source.class);
        Assert.assertThat((Object)superTypeGenerics.size(), (Matcher)CoreMatchers.is((Object)2));
        Type stringListType = (Type)superTypeGenerics.get(0);
        Assert.assertThat((Object)stringListType.isSameType(List.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((TypeGeneric)stringListType.getGenerics().get(0)).getConcreteType().isSameType(String.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Type)superTypeGenerics.get(1)).isSameType(Integer.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetMethodFromType() {
        Type pojoWithEqualsAndHashCode = this.typeSupplier.apply(PojoWithEqualsAndHashCode.class);
        java.util.Optional equals = pojoWithEqualsAndHashCode.getMethod("equals", new Class[]{Object.class});
        java.util.Optional equalsWithoutParams = pojoWithEqualsAndHashCode.getMethod("equals", new Class[0]);
        java.util.Optional hashCode = pojoWithEqualsAndHashCode.getMethod("hashCode", new Class[0]);
        java.util.Optional otherMethod = pojoWithEqualsAndHashCode.getMethod("otherMethod", new Class[0]);
        java.util.Optional parametersWithoutOrder = pojoWithEqualsAndHashCode.getMethod("someMethod", new Class[]{String.class, Object.class});
        Assert.assertThat((Object)equals.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)equalsWithoutParams.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)hashCode.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)otherMethod.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parametersWithoutOrder.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetMethodFromTypeWithInheritance() {
        Type extendsPojoWithEqualsAndHashCode = this.typeSupplier.apply(ExtendsPojoWithEqualsAndHashCode.class);
        java.util.Optional equals = extendsPojoWithEqualsAndHashCode.getMethod("equals", new Class[]{Object.class});
        java.util.Optional hashCode = extendsPojoWithEqualsAndHashCode.getMethod("hashCode", new Class[0]);
        java.util.Optional otherMethod = extendsPojoWithEqualsAndHashCode.getMethod("otherMethod", new Class[0]);
        Assert.assertThat((Object)equals.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)hashCode.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)otherMethod.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetMethodFromTypeDefinedInObject() {
        Type type = this.typeSupplier.apply(SomePojo.class);
        java.util.Optional equals = type.getMethod("equals", new Class[]{Object.class});
        Assert.assertThat((Object)equals.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getSourceMetadataType() {
        SourceElement source = this.sourceSupplier.apply(ThirdLevelSource.class);
        MetadataType returnType = source.getReturnMetadataType();
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ArrayType arrayType = (ArrayType)returnType;
        MetadataType itemType = arrayType.getType();
        Assert.assertThat((Object)itemType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
    }

    @Test
    public void getByteArrayOutputType() throws Exception {
        OperationElement operation = this.getMethod("byteArray", new Class[0]);
        MetadataType metadataType = operation.getOperationReturnMetadataType();
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.instanceOf(AnyType.class));
    }

    @Test
    public void isRequired() {
        AccessibleObject object = (AccessibleObject)Mockito.mock(AccessibleObject.class);
        Assert.assertThat((Object)IntrospectionUtils.isRequired((AccessibleObject)object), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isNotRequired() {
        org.mule.sdk.api.annotation.param.Optional optional = (org.mule.sdk.api.annotation.param.Optional)Mockito.mock(org.mule.sdk.api.annotation.param.Optional.class);
        AccessibleObject object = (AccessibleObject)Mockito.mock(AccessibleObject.class);
        Mockito.when((Object)object.getAnnotation(org.mule.sdk.api.annotation.param.Optional.class)).thenReturn((Object)optional);
        Assert.assertThat((Object)IntrospectionUtils.isRequired((AccessibleObject)object), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isNotRequiredDeprecatedAnnotation() {
        Optional optional = (Optional)Mockito.mock(Optional.class);
        AccessibleObject object = (AccessibleObject)Mockito.mock(AccessibleObject.class);
        Mockito.when((Object)object.getAnnotation(Optional.class)).thenReturn((Object)optional);
        Assert.assertThat((Object)IntrospectionUtils.isRequired((AccessibleObject)object), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getAlias() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("sdkField");
        Field legacyField = WithFields.class.getDeclaredField("legacyField");
        Assert.assertThat((Object)IntrospectionUtils.getAlias((Field)sdkField), (Matcher)CoreMatchers.is((Object)"newSdkField"));
        Assert.assertThat((Object)IntrospectionUtils.getAlias((Field)legacyField), (Matcher)CoreMatchers.is((Object)"oldLegacyField"));
    }

    @Test
    public void getRequiredExpressionSupportFromFieldUsingTheSdkApi() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("sdkExpressionRequired");
        FieldWrapper fieldWrapper = new FieldWrapper(sdkField, this.typeLoader);
        Assert.assertThat(IntrospectionUtils.getExpressionSupport((WithAnnotations)fieldWrapper, (String)"parameter", (String)"sdkExpressionRequired").get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.ExpressionSupport.REQUIRED));
    }

    @Test
    public void getNotSupportedExpressionSupportFromFieldUsingTheSdkApi() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("sdkExpressionNotSupported");
        FieldWrapper fieldWrapper = new FieldWrapper(sdkField, this.typeLoader);
        Assert.assertThat(IntrospectionUtils.getExpressionSupport((WithAnnotations)fieldWrapper, (String)"parameter", (String)"sdkExpressionNotSupported").get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED));
    }

    @Test
    public void getSupportedExpressionSupportFromFieldUsingTheSdkApi() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("sdkExpressionSupported");
        FieldWrapper fieldWrapper = new FieldWrapper(sdkField, this.typeLoader);
        Assert.assertThat(IntrospectionUtils.getExpressionSupport((WithAnnotations)fieldWrapper, (String)"parameter", (String)"sdkExpressionSupported").get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.ExpressionSupport.SUPPORTED));
    }

    @Test
    public void getRequiredExpressionSupportFromFieldUsingTheLegacyApi() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("legacyExpressionRequired");
        FieldWrapper fieldWrapper = new FieldWrapper(sdkField, this.typeLoader);
        Assert.assertThat(IntrospectionUtils.getExpressionSupport((WithAnnotations)fieldWrapper, (String)"parameter", (String)"legacyExpressionRequired").get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.ExpressionSupport.REQUIRED));
    }

    @Test
    public void getNotSupportedExpressionSupportFromFieldUsingTheLegacyApi() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("legacyExpressionNotSupported");
        FieldWrapper fieldWrapper = new FieldWrapper(sdkField, this.typeLoader);
        Assert.assertThat(IntrospectionUtils.getExpressionSupport((WithAnnotations)fieldWrapper, (String)"parameter", (String)"legacyExpressionNotSupported").get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED));
    }

    @Test
    public void getSupportedExpressionSupportFromFieldUsingTheLegacyApi() throws Exception {
        Field sdkField = WithFields.class.getDeclaredField("legacyExpressionSupported");
        FieldWrapper fieldWrapper = new FieldWrapper(sdkField, this.typeLoader);
        Assert.assertThat(IntrospectionUtils.getExpressionSupport((WithAnnotations)fieldWrapper, (String)"parameter", (String)"legacyExpressionSupported").get(), (Matcher)CoreMatchers.is((Object)org.mule.runtime.api.meta.ExpressionSupport.SUPPORTED));
    }

    private void assertField(String name, MetadataType metadataType, Collection<Field> fields) {
        Field field = this.findField(name, fields);
        Assert.assertThat((Object)field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)field.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat(field.getType(), (Matcher)CoreMatchers.equalTo((Object)JavaTypeUtils.getType((MetadataType)metadataType)));
    }

    private Field findField(String name, Collection<Field> fields) {
        return fields.stream().filter(f -> name.equals(f.getName())).findAny().orElse(null);
    }

    private void assertType(MetadataType type, Class<?> rawType) {
        Assert.assertThat((Object)rawType.isAssignableFrom(JavaTypeUtils.getType((MetadataType)type)), (Matcher)CoreMatchers.is((Object)true));
    }

    private OperationElement getMethod(String methodName, Class<?> ... parameterTypes) throws Exception {
        return this.operationSupplier.apply(methodName, parameterTypes);
    }

    private void assertDictionary(MetadataType metadataType, Class<?> valueType) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        ObjectType dictionaryType = (ObjectType)metadataType;
        this.assertType((MetadataType)dictionaryType, Map.class);
        Assert.assertThat((Object)dictionaryType.getOpenRestriction().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertType((MetadataType)dictionaryType.getOpenRestriction().get(), valueType);
    }

    private void assertList(MetadataType metadataType, Class<?> listItemType) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertType(metadataType, List.class);
        MetadataType itemMetadataType = ((ArrayType)metadataType).getType();
        this.assertType(itemMetadataType, listItemType);
    }

    public Map<String, Apple> foo() {
        return new HashMap<String, Apple>();
    }

    public Object methodReturnObject() {
        return this;
    }

    public List<Result<String, Object>> listResultStringObject() {
        return null;
    }

    public List listNoGenerics() {
        return new ArrayList();
    }

    public Map mapNoGenerics() {
        return new LinkedHashMap();
    }

    public Result<String, Object> operationResult() {
        return null;
    }

    public Result resultWithNoGenerics() {
        return null;
    }

    public Result<?, ?> resultWithWildcardGenerics() {
        return null;
    }

    public PagingProvider<Object, String> pagingProvider() {
        return null;
    }

    public PagingProvider<Object, Result<String, Object>> pagingProviderOperationResult() {
        return null;
    }

    public int bar(String s, Long l, Apple apple, Map<Banana, Kiwi> fruits) {
        return Objects.hash(s, l, apple, fruits);
    }

    public TestPagingProvider getPagingProvider() {
        return null;
    }

    public List<FruitBasket> getBaskets() {
        return this.baskets;
    }

    public void setBaskets(List<FruitBasket> baskets) {
        this.baskets = baskets;
    }

    public Byte[] byteArray() {
        return null;
    }

    private void assertAttributesType(String method) throws Exception {
        MetadataType attributesType = IntrospectionUtils.getMethodReturnAttributesType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)attributesType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        this.assertType(attributesType, Object.class);
    }

    private void assertVoidAttributesType(String method) throws Exception {
        MetadataType attributesType = IntrospectionUtils.getMethodReturnAttributesType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)attributesType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
    }

    private void assertReturnType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        this.assertType(returnType, String.class);
    }

    private void assertPagingProviderReturnType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        Assert.assertThat((Object)((ArrayType)returnType).getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        this.assertType(((ArrayType)returnType).getType(), String.class);
    }

    private void assertPagingProviderReturnResultType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType(((ArrayType)returnType).getType(), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    private static class WithFields {
        @Alias(value="newSdkField")
        public String sdkField;
        @org.mule.runtime.extension.api.annotation.Alias(value="oldLegacyField")
        public String legacyField;
        @Expression(value=ExpressionSupport.REQUIRED)
        public String sdkExpressionRequired;
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        public String sdkExpressionNotSupported;
        @Expression(value=ExpressionSupport.SUPPORTED)
        public String sdkExpressionSupported;
        @org.mule.runtime.extension.api.annotation.Expression(value=org.mule.runtime.api.meta.ExpressionSupport.REQUIRED)
        public String legacyExpressionRequired;
        @org.mule.runtime.extension.api.annotation.Expression(value=org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED)
        public String legacyExpressionNotSupported;
        @org.mule.runtime.extension.api.annotation.Expression(value=org.mule.runtime.api.meta.ExpressionSupport.SUPPORTED)
        public String legacyExpressionSupported;

        private WithFields() {
        }
    }

    private static class ClassOperationSupplier
    implements BiFunction<String, Class[], OperationElement> {
        private ClassOperationSupplier() {
        }

        @Override
        public OperationElement apply(String methodName, Class[] paramTypes) {
            try {
                return new OperationWrapper(IntrospectionUtilsTestCase.class.getMethod(methodName, paramTypes), ExtensionsTestUtils.TYPE_LOADER);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException();
            }
        }
    }

    private static class ClassSourceSupplier
    implements Function<Class<?>, SourceElement> {
        private ClassSourceSupplier() {
        }

        @Override
        public SourceElement apply(Class className) {
            return new SourceTypeWrapper(className, ExtensionsTestUtils.TYPE_LOADER);
        }
    }

    private class TestPagingProvider
    implements PagingProvider<Object, Result<Banana, Apple>> {
        private TestPagingProvider() {
        }

        public List<Result<Banana, Apple>> getPage(Object connection) {
            return null;
        }

        public java.util.Optional<Integer> getTotalResults(Object connection) {
            return null;
        }

        public void close(Object connection) throws MuleException {
        }
    }

    public static class ExtendsPojoWithEqualsAndHashCode
    extends PojoWithEqualsAndHashCode {
    }

    public static class PojoWithEqualsAndHashCode {
        private String name;

        public boolean someMethod(Object object, String string) {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithEqualsAndHashCode that = (PojoWithEqualsAndHashCode)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class SomePojo {
        private String aString;
        private Integer someNumber;
        private String nonProperty;

        public String getaString() {
            return this.aString;
        }

        public void setaString(String aString) {
            this.aString = aString;
        }

        public Integer getSomeNumber() {
            return this.someNumber;
        }

        public void setSomeNumber(Integer someNumber) {
            this.someNumber = someNumber;
        }
    }

    public static class OtherClass
    extends BaseClass {
    }

    public static class BaseClass
    implements ThirdInterface {
        @Override
        public void doSomething() {
        }

        @Override
        public void doSomethingElse() {
        }

        @Override
        public void doNothing() {
        }
    }

    public static interface ThirdInterface
    extends SecondInterface<String> {
        public void doNothing();
    }

    public static interface SecondInterface<K>
    extends RootInterface<Integer, K> {
        public void doSomethingElse();
    }

    public static interface RootInterface<T, A> {
        public void doSomething();
    }

    public static class SimpleSource
    extends Source<List<String>, Integer> {
        public void onStart(SourceCallback<List<String>, Integer> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public static class FirstLevelSource<P, A>
    extends Source<P, A> {
        public void onStart(SourceCallback<P, A> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public static class SecondLevelSource<T extends Serializable>
    extends FirstLevelSource<List<String>, T> {
    }

    public static class ThirdLevelSource
    extends SecondLevelSource<Integer> {
    }
}

