/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Optional;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.ConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParser;

final class ConfigModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    ConfigModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareConfigurations(ExtensionDeclarer declarer, ExtensionModelParser extensionModelParser) {
        for (ConfigurationModelParser configParser : extensionModelParser.getConfigurationParsers()) {
            String configName = this.resolveConfigName(configParser);
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(configName).describedAs(this.resolveConfigDescription(configParser, configName)).withModelProperty((ModelProperty)configParser.getConfigurationFactoryModelProperty());
            if (configParser.isForceNoImplicit()) {
                configurationDeclarer.withModelProperty((ModelProperty)new NoImplicitModelProperty());
            }
            configParser.getDeprecationModel().ifPresent(dm -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).withDeprecation(dm));
            configParser.getDisplayModel().ifPresent(d -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).setDisplayModel(d));
            configParser.getExternalLibraryModels().forEach(arg_0 -> ((ConfigurationDeclarer)configurationDeclarer).withExternalLibrary(arg_0));
            configParser.getAdditionalModelProperties().forEach(arg_0 -> ((ConfigurationDeclarer)configurationDeclarer).withModelProperty(arg_0));
            this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)configurationDeclarer, configParser.getParameterGroupParsers());
            this.getOperationLoaderDelegate().declareOperations(declarer, (HasOperationDeclarer)configurationDeclarer, configParser.getOperationParsers());
            this.getSourceModelLoaderDelegate().declareMessageSources(declarer, (HasSourceDeclarer)configurationDeclarer, configParser.getSourceModelParsers());
            this.getFunctionModelLoaderDelegate().declareFunctions(declarer, configParser.getFunctionModelParsers());
            this.getConnectionProviderModelLoaderDelegate().declareConnectionProviders((HasConnectionProviderDeclarer)configurationDeclarer, configParser.getConnectionProviderModelParsers());
            this.getStereotypeModelLoaderDelegate().addStereotypes(configParser, configurationDeclarer, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultConfigStereotype(configParser.getName())));
        }
    }

    private String resolveConfigName(ConfigurationModelParser parser) {
        return StringUtils.isBlank((String)parser.getName()) ? "config" : parser.getName();
    }

    private String resolveConfigDescription(ConfigurationModelParser parser, String configName) {
        String description = parser.getDescription();
        if (StringUtils.isBlank((String)description) && "config".equals(configName)) {
            description = "Default configuration";
        }
        return description;
    }
}

