/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.metadata.resolving.StaticResolver;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaInputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.sdk.api.annotation.metadata.TypeResolver;

public class JavaInputResolverModelParserUtils {
    public static List<JavaInputResolverModelParser> parseInputResolversModelParser(OperationDeclaration declaration) {
        return declaration.getAllParameters().stream().map(param -> param.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).filter(Optional::isPresent).map(modelProperty -> ((ExtensionParameterDescriptorModelProperty)modelProperty.get()).getExtensionParameter()).map(JavaInputResolverModelParserUtils::getResolverParser).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static List<JavaInputResolverModelParser> parseInputResolversModelParser(SourceCallbackDeclaration sourceCallbackDeclaration) {
        return sourceCallbackDeclaration.getAllParameters().stream().map(param -> param.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).filter(Optional::isPresent).map(modelProperty -> ((ExtensionParameterDescriptorModelProperty)modelProperty.get()).getExtensionParameter()).map(JavaInputResolverModelParserUtils::getResolverParser).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<JavaInputResolverModelParser> getResolverParser(ExtensionParameter extensionParameter) {
        Optional<Type> type = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionParameter, "parameter", extensionParameter.getName(), org.mule.runtime.extension.api.annotation.metadata.TypeResolver.class, TypeResolver.class, value -> value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.TypeResolver::value), value -> value.getClassValue(TypeResolver::value));
        return type.flatMap(t -> JavaInputResolverModelParserUtils.getJavaInputResolverParser(extensionParameter.getName(), t));
    }

    private static Optional<JavaInputResolverModelParser> getJavaInputResolverParser(String parameterName, Type type) {
        if (!type.getDeclaringClass().isPresent()) {
            return Optional.empty();
        }
        Class<?> resolverClazz = type.getDeclaringClass().get();
        if (JavaInputResolverModelParserUtils.isStaticResolver(resolverClazz)) {
            return Optional.empty();
        }
        return Optional.of(new JavaInputResolverModelParser(parameterName, resolverClazz));
    }

    private static boolean isStaticResolver(Class<?> resolverClazz) {
        return StaticResolver.class.isAssignableFrom(resolverClazz) || org.mule.sdk.api.metadata.resolving.StaticResolver.class.isAssignableFrom(resolverClazz);
    }
}

