/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.operation;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.streaming.CursorProviderDecorator;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.client.NullComponent;
import org.mule.runtime.module.extension.internal.runtime.client.operation.ComponentExecutorResolver;
import org.mule.runtime.module.extension.internal.runtime.client.operation.DefaultOperationParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationKey;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.result.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationClient
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(OperationClient.class);
    private static final NullProfilingDataProducer NULL_PROFILING_DATA_PRODUCER = new NullProfilingDataProducer();
    private final ExecutionMediator<OperationModel> mediator;
    private final ComponentExecutorResolver executorResolver;
    private final ValueReturnDelegate returnDelegate;
    private final StreamingManager streamingManager;
    private final ExpressionManager expressionManager;
    private final ReflectionCache reflectionCache;
    private final MuleContext muleContext;

    public static OperationClient from(OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ExtensionConnectionSupplier extensionConnectionSupplier, ErrorTypeRepository errorTypeRepository, StreamingManager streamingManager, ReflectionCache reflectionCache, MuleContext muleContext) {
        return new OperationClient(OperationClient.createExecutionMediator(key, extensionConnectionSupplier, errorTypeRepository, reflectionCache, muleContext), ComponentExecutorResolver.from(key, extensionManager, expressionManager, reflectionCache, muleContext), new ValueReturnDelegate((ComponentModel)key.getOperationModel(), muleContext), streamingManager, expressionManager, reflectionCache, muleContext);
    }

    private OperationClient(ExecutionMediator<OperationModel> mediator, ComponentExecutorResolver executorResolver, ValueReturnDelegate returnDelegate, StreamingManager streamingManager, ExpressionManager expressionManager, ReflectionCache reflectionCache, MuleContext muleContext) {
        this.mediator = mediator;
        this.executorResolver = executorResolver;
        this.returnDelegate = returnDelegate;
        this.streamingManager = streamingManager;
        this.expressionManager = expressionManager;
        this.reflectionCache = reflectionCache;
        this.muleContext = muleContext;
    }

    public <T, A> CompletableFuture<Result<T, A>> execute(OperationKey key, DefaultOperationParameterizer parameterizer) {
        boolean shouldCompleteEvent = false;
        CoreEvent contextEvent = parameterizer.getContextEvent().orElse(null);
        if (contextEvent == null) {
            contextEvent = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
            shouldCompleteEvent = true;
        }
        OperationModel operationModel = key.getOperationModel();
        Optional<ConfigurationInstance> configurationInstance = this.getConfigurationInstance(key, contextEvent);
        Map<String, Object> resolvedParams = this.resolveOperationParameters(operationModel, configurationInstance, parameterizer, contextEvent);
        CursorProviderFactory cursorProviderFactory = parameterizer.getCursorProviderFactory(this.streamingManager);
        DefaultExecutionContext<OperationModel> context = new DefaultExecutionContext<OperationModel>(key.getExtensionModel(), configurationInstance, resolvedParams, operationModel, contextEvent, cursorProviderFactory, this.streamingManager, (Component)NullComponent.NULL_COMPONENT, parameterizer.getRetryPolicyTemplate(), ImmediateScheduler.IMMEDIATE_SCHEDULER, Optional.empty(), this.muleContext);
        return this.doExecute(context, shouldCompleteEvent);
    }

    private <T, A> CompletableFuture<Result<T, A>> doExecute(final ExecutionContextAdapter<OperationModel> ctx, final boolean shouldCompleteEvent) {
        final CompletableFuture<Result<T, A>> future = new CompletableFuture<Result<T, A>>();
        CompletableComponentExecutor.ExecutorCallback callback = new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                EventCompletingValue result = OperationClient.this.asEventCompletingResult(value, ctx, shouldCompleteEvent);
                try {
                    future.complete(result.value);
                }
                finally {
                    if (result.shouldCompleteEvent) {
                        ((BaseEventContext)ctx.getEvent().getContext()).success();
                    }
                }
            }

            public void error(Throwable e) {
                if (!(e instanceof MessagingException)) {
                    e = new MessagingException(ctx.getEvent(), e);
                }
                try {
                    future.completeExceptionally(e);
                }
                finally {
                    if (shouldCompleteEvent) {
                        ((BaseEventContext)ctx.getEvent().getContext()).error(e);
                    }
                }
            }
        };
        this.mediator.execute(this.executorResolver.resolveExecutor(ctx.getParameters()), ctx, callback);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> resolveOperationParameters(OperationModel operationModel, Optional<ConfigurationInstance> configurationInstance, DefaultOperationParameterizer parameterizer, CoreEvent event) {
        ComponentParameterization.Builder paramsBuilder = ComponentParameterization.builder((ParameterizedModel)operationModel);
        parameterizer.setValuesOn((ComponentParameterization.Builder<OperationModel>)paramsBuilder);
        try {
            ResolverSet resolverSet = ResolverSetUtils.getResolverSetFromComponentParameterization(paramsBuilder.build(), this.muleContext, true, this.reflectionCache, this.expressionManager, "");
            ValueResolvingContext.Builder ctxBuilder = ValueResolvingContext.builder(event);
            configurationInstance.ifPresent(ctxBuilder::withConfig);
            try (ValueResolvingContext ctx = ctxBuilder.build();){
                Map<String, Object> map = resolverSet.resolve(ctx).asMap();
                return map;
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
    }

    private <T, A> EventCompletingValue<Result<T, A>> asEventCompletingResult(Object value, ExecutionContextAdapter<OperationModel> context, boolean shouldCompleteEvent) {
        Message message = this.returnDelegate.asReturnValue(value, context).getMessage();
        TypedValue payload = message.getPayload();
        TypedValue attributes = message.getAttributes();
        EventCompletingValue<Object> completingPayload = this.asEventCompletingValue(payload.getValue(), context, shouldCompleteEvent);
        shouldCompleteEvent = shouldCompleteEvent && ((EventCompletingValue)completingPayload).shouldCompleteEvent;
        EventCompletingValue<Object> completingAttributes = this.asEventCompletingValue(attributes.getValue(), context, shouldCompleteEvent);
        shouldCompleteEvent = shouldCompleteEvent && ((EventCompletingValue)completingAttributes).shouldCompleteEvent;
        Result result = Result.builder().output(((EventCompletingValue)completingPayload).value).mediaType(payload.getDataType().getMediaType()).attributes(((EventCompletingValue)completingAttributes).value).attributesMediaType(attributes.getDataType().getMediaType()).build();
        return new EventCompletingValue<Result<T, A>>(result, shouldCompleteEvent);
    }

    private EventCompletingValue<Object> asEventCompletingValue(Object value, ExecutionContextAdapter ctx, boolean shouldCompleteEvent) {
        if (shouldCompleteEvent) {
            if (value instanceof CursorIteratorProvider) {
                return new EventCompletingValue<Object>((Object)new EventCompletingCursorIteratorProviderDecorator((CursorIteratorProvider)value, ctx.getEvent()), false);
            }
            if (value instanceof CursorStreamProvider) {
                return new EventCompletingValue<Object>((Object)new EventCompletingCursorStreamProviderDecorator((CursorStreamProvider)value, ctx.getEvent()), false);
            }
        }
        return new EventCompletingValue<Object>(value, shouldCompleteEvent);
    }

    private Optional<ConfigurationInstance> getConfigurationInstance(OperationKey key, CoreEvent contextEvent) {
        return key.getConfigurationProvider(contextEvent).map(config -> config.get((Event)contextEvent));
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.mediator, (boolean)true, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.executorResolver, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.mediator);
        LifecycleUtils.startIfNeeded((Object)this.executorResolver);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.mediator);
        LifecycleUtils.stopIfNeeded((Object)this.executorResolver);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.mediator, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.executorResolver, (Logger)LOGGER);
    }

    private static ExecutionMediator<OperationModel> createExecutionMediator(OperationKey key, ExtensionConnectionSupplier extensionConnectionSupplier, ErrorTypeRepository errorTypeRepository, ReflectionCache reflectionCache, MuleContext muleContext) {
        ExtensionModel extensionModel = key.getExtensionModel();
        OperationModel operationModel = key.getOperationModel();
        DefaultExecutionMediator<OperationModel> mediator = new DefaultExecutionMediator<OperationModel>(extensionModel, operationModel, ReconnectionUtils.createReconnectionInterceptorsChain(extensionModel, (ComponentModel)operationModel, extensionConnectionSupplier, reflectionCache), errorTypeRepository, muleContext.getExecutionClassLoader(), MuleExtensionUtils.getPagingResultTransformer(operationModel, extensionConnectionSupplier, MuleExtensionUtils.supportsOAuth(extensionModel)).orElse(null), NULL_PROFILING_DATA_PRODUCER, false);
        try {
            LifecycleUtils.initialiseIfNeeded(mediator, (boolean)true, (MuleContext)muleContext);
            LifecycleUtils.startIfNeeded(mediator);
            return mediator;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create mediator for operation " + key)), (Throwable)e);
        }
    }

    private static class NullProfilingDataProducer
    implements ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> {
        private NullProfilingDataProducer() {
        }

        public void triggerProfilingEvent(ComponentThreadingProfilingEventContext profilerEventContext) {
        }

        public void triggerProfilingEvent(CoreEvent sourceData, Function<CoreEvent, ComponentThreadingProfilingEventContext> transformation) {
        }
    }

    private static class EventCompletingValue<T> {
        private final T value;
        private final boolean shouldCompleteEvent;

        private EventCompletingValue(T value, boolean shouldCompleteEvent) {
            this.value = value;
            this.shouldCompleteEvent = shouldCompleteEvent;
        }
    }

    private static class EventCompletingCursorIteratorProviderDecorator
    extends EventCompletingCursorProviderDecorator<CursorIterator>
    implements CursorIteratorProvider {
        public EventCompletingCursorIteratorProviderDecorator(CursorIteratorProvider delegate, CoreEvent event) {
            super((CursorProvider)delegate, event);
        }
    }

    private static class EventCompletingCursorStreamProviderDecorator
    extends EventCompletingCursorProviderDecorator<CursorStream>
    implements CursorStreamProvider {
        public EventCompletingCursorStreamProviderDecorator(CursorStreamProvider delegate, CoreEvent event) {
            super((CursorProvider)delegate, event);
        }
    }

    private static abstract class EventCompletingCursorProviderDecorator<T extends Cursor>
    extends CursorProviderDecorator<T> {
        private final CoreEvent event;

        private EventCompletingCursorProviderDecorator(CursorProvider delegate, CoreEvent event) {
            super(delegate);
            this.event = event;
        }

        public void close() {
            try {
                super.close();
            }
            finally {
                ((BaseEventContext)this.event.getContext()).success();
            }
        }
    }
}

