/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NullSafeValueResolverWrapperTestCase
extends AbstractMuleContextTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private CoreEvent event;
    @Mock
    private ObjectTypeParametersResolver objectTypeParametersResolver;
    @Mock
    private ExpressionManager expressionManager;
    private final ReflectionCache reflectionCache = new ReflectionCache();

    @Before
    public void setUp() {
        Mockito.when((Object)this.event.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)this.event.getAuthentication()).thenReturn(Optional.empty());
        Message msg = Message.of(null);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)msg);
        Mockito.when((Object)this.event.asBindingContext()).thenReturn((Object)BindingContextUtils.getTargetBindingContext((Message)msg));
        Mockito.when((Object)this.event.getItemSequenceInfo()).thenReturn(Optional.empty());
    }

    @Test
    public void testMapType() throws Exception {
        this.assertExpected((ValueResolver)new StaticValueResolver(null), ExtensionsTestUtils.toMetadataType(HashMap.class), false, new HashMap());
    }

    @Test
    public void testPojoType() throws Exception {
        ExpressionManagerSession session = (ExpressionManagerSession)Mockito.mock(ExpressionManagerSession.class);
        Mockito.when((Object)session.evaluate((CompiledExpression)ArgumentMatchers.any(CompiledExpression.class), (DataType)ArgumentMatchers.any(DataType.class))).thenAnswer(inv -> new TypedValue((Object)5, (DataType)inv.getArgument(1)));
        Mockito.when((Object)this.expressionManager.openSession((BindingContext)ArgumentMatchers.any())).thenReturn((Object)session);
        this.assertExpected((ValueResolver)new StaticValueResolver(null), ExtensionsTestUtils.toMetadataType(DynamicPojo.class), true, new DynamicPojo(5));
        ((CoreEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.times((int)1))).asBindingContext();
    }

    @Test
    public void testPojoWithStaticDefaultValue() throws Exception {
        this.assertExpected((ValueResolver)new StaticValueResolver(null), ExtensionsTestUtils.toMetadataType(NonDynamicPojo.class), false, new NonDynamicPojo(false));
    }

    @Test
    public void testPojoWithMap() throws Exception {
        DynamicPojoWithMap pojo = new DynamicPojoWithMap();
        pojo.setMap(new HashMap<String, String>());
        this.assertExpected((ValueResolver)new StaticValueResolver(null), ExtensionsTestUtils.toMetadataType(DynamicPojoWithMap.class), false, pojo);
    }

    @Test
    public void testNullSafeSdkAndLegacyAnnotation() throws Exception {
        PojoUsingSdkApiAndLegacyApi pojo = new PojoUsingSdkApiAndLegacyApi();
        pojo.setParameters(new ASimplePojo(), new ASimplePojo());
        this.assertExpected((ValueResolver)new StaticValueResolver(null), ExtensionsTestUtils.toMetadataType(PojoUsingSdkApiAndLegacyApi.class), false, pojo);
    }

    private void assertExpected(ValueResolver valueResolver, MetadataType type, boolean isDynamic, Object expected) throws Exception {
        ValueResolver resolver = NullSafeValueResolverWrapper.of((ValueResolver)valueResolver, (MetadataType)type, (ReflectionCache)this.reflectionCache, (ExpressionManager)this.expressionManager, (MuleContext)muleContext, (ObjectTypeParametersResolver)this.objectTypeParametersResolver);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build();
        Assert.assertThat((Object)resolver.isDynamic(), (Matcher)Is.is((Object)isDynamic));
        Assert.assertThat((Object)resolver.resolve(ctx), (Matcher)Is.is((Object)expected));
    }

    public static class ASimplePojo {
        public String parameter = "parameter";

        public boolean equals(Object o) {
            if (o instanceof ASimplePojo) {
                ASimplePojo that = (ASimplePojo)o;
                return Objects.equals(this.parameter, that.parameter);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.parameter);
        }
    }

    public static class PojoUsingSdkApiAndLegacyApi {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional
        @NullSafe
        private ASimplePojo parameter1;
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional
        @org.mule.sdk.api.annotation.param.NullSafe
        private ASimplePojo parameter2;

        public void setParameters(ASimplePojo parameter1, ASimplePojo parameter2) {
            this.parameter1 = parameter1;
            this.parameter2 = parameter2;
        }

        public boolean equals(Object o) {
            if (o instanceof PojoUsingSdkApiAndLegacyApi) {
                PojoUsingSdkApiAndLegacyApi that = (PojoUsingSdkApiAndLegacyApi)o;
                return Objects.equals(this.parameter1, that.parameter1) && Objects.equals(this.parameter2, that.parameter2);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.parameter1, this.parameter2);
        }
    }

    public static class NonDynamicPojo {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false")
        private Boolean staticDefaultValue;

        public NonDynamicPojo() {
        }

        public NonDynamicPojo(Boolean staticDefaultValue) {
            this.staticDefaultValue = staticDefaultValue;
        }

        public Boolean getStaticDefaultValue() {
            return this.staticDefaultValue;
        }

        public void setStaticDefaultValue(Boolean staticDefaultValue) {
            this.staticDefaultValue = staticDefaultValue;
        }

        public boolean equals(Object o) {
            if (o instanceof NonDynamicPojo) {
                NonDynamicPojo that = (NonDynamicPojo)o;
                return Objects.equals(this.staticDefaultValue, that.staticDefaultValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.staticDefaultValue);
        }
    }

    public static class DynamicPojoWithMap {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional
        @NullSafe
        private Map<String, String> map;

        public Map<String, String> getMap() {
            return this.map;
        }

        public void setMap(Map<String, String> map) {
            this.map = map;
        }

        public boolean equals(Object o) {
            if (o instanceof DynamicPojoWithMap) {
                DynamicPojoWithMap that = (DynamicPojoWithMap)o;
                return Objects.equals(this.map, that.map);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.map);
        }
    }

    public static class DynamicPojo {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[5]")
        private int time;

        public DynamicPojo() {
        }

        public DynamicPojo(int time) {
            this.time = time;
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o instanceof DynamicPojo) {
                DynamicPojo that = (DynamicPojo)o;
                return this.time == that.time;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.time);
        }
    }
}

