/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.HasExternalLibraries;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.sdk.api.annotation.JavaVersionSupport;
import org.mule.sdk.api.annotation.error.ErrorTypes;
import org.mule.sdk.api.meta.JavaVersion;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.HeisenbergRouters;
import org.mule.test.heisenberg.extension.HeisenbergScopes;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.KillingOperations;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.heisenberg.extension.SecureHeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.exception.HeisenbergConnectionExceptionEnricher;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.CarDealer;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.vegan.extension.PaulMcCartneySource;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
@Feature(value="SDK")
public class DefaultExtensionModelFactoryTestCase
extends AbstractMuleTestCase {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final ExtensionModel heisenbergExtension = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    private final ExtensionModel veganExtension = MuleExtensionUtils.loadExtension(VeganExtension.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void flyweight() {
        ConfigurationModel appleConfiguration = (ConfigurationModel)this.aggressiveGet(this.veganExtension.getConfigurationModel("apple-config"));
        ConfigurationModel bananaConfiguration = (ConfigurationModel)this.aggressiveGet(this.veganExtension.getConfigurationModel("banana-config"));
        String sourceName = PaulMcCartneySource.class.getSimpleName();
        SourceModel appleSource = (SourceModel)this.aggressiveGet(appleConfiguration.getSourceModel(sourceName));
        SourceModel bananaSource = (SourceModel)this.aggressiveGet(bananaConfiguration.getSourceModel(sourceName));
        Assert.assertThat((Object)appleSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)appleSource)));
        Assert.assertThat((Object)bananaSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)bananaSource)));
        String operationName = "spreadTheWord";
        OperationModel appleOperation = (OperationModel)this.aggressiveGet(appleConfiguration.getOperationModel("spreadTheWord"));
        OperationModel bananaOperation = (OperationModel)this.aggressiveGet(bananaConfiguration.getOperationModel("spreadTheWord"));
        Assert.assertThat((Object)appleOperation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)bananaOperation)));
    }

    @Test
    public void blockingExecutionTypes() {
        final List<String> nonBlockingOperations = Arrays.asList("killMany", "executeAnything", "alwaysFailsWrapper", "getChain", "exceptionOnCallbacks", "neverFailsWrapper", "payloadModifier", "blockingNonBlocking", "nonBlocking", "callGusFringNonBlocking", "tapPhones", "sdkExecuteForeingOrders");
        final Reference cpuIntensive = new Reference((Object)false);
        final Reference blocking = new Reference((Object)false);
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operation) {
                String operationName = operation.getName();
                Matcher nonBlockingMatcher = Matchers.hasItem((Object)operationName);
                Assert.assertThat((Object)nonBlockingOperations, (Matcher)(operation.isBlocking() ? CoreMatchers.not((Matcher)nonBlockingMatcher) : nonBlockingMatcher));
                if (operationName.equals("approve")) {
                    Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.CPU_INTENSIVE));
                    cpuIntensive.set((Object)true);
                } else if (operation.requiresConnection()) {
                    Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.BLOCKING));
                    blocking.set((Object)true);
                } else {
                    Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.CPU_LITE));
                }
            }
        }.walk(this.heisenbergExtension);
        Assert.assertThat((Object)((Boolean)cpuIntensive.get()), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Boolean)blocking.get()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nonBlockingExecutionType() {
        ExtensionModel extensionModel = MuleExtensionUtils.loadExtension(MarvelExtension.class);
        OperationModel operation = (OperationModel)((ConfigurationModel)extensionModel.getConfigurationModel("ironMan").get()).getOperationModel("fireMissile").get();
        Assert.assertThat((Object)operation.isBlocking(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.CPU_LITE));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.instanceOf(StringType.class));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.equalTo((Object)this.typeLoader.load(Void.TYPE)));
    }

    @Test
    public void contentParameter() {
        this.assertSinglePrimaryContentParameter(this.veganExtension, "getAllApples", "#[payload]");
    }

    @Test
    public void contentParameterWithCustomDefault() {
        this.assertSinglePrimaryContentParameter(this.veganExtension, "tryToEatThisListOfMaps", null);
    }

    @Test
    public void exportedLibraries() {
        this.assertExternalLibraries((HasExternalLibraries)this.heisenbergExtension);
        new IdempotentExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                DefaultExtensionModelFactoryTestCase.this.assertExternalLibraries((HasExternalLibraries)model);
            }

            protected void onConnectionProvider(ConnectionProviderModel model) {
                DefaultExtensionModelFactoryTestCase.this.assertExternalLibraries((HasExternalLibraries)model);
            }
        }.walk(this.heisenbergExtension);
    }

    @Test
    public void streamingHintOnOperation() throws Exception {
        OperationModel operationModel = (OperationModel)((ConfigurationModel)this.heisenbergExtension.getConfigurationModels().get(0)).getOperationModel("sayMyName").get();
        ParameterModel streamingParameter = operationModel.getAllParameterModels().stream().filter(p -> p.getName().equals("streamingStrategy")).findFirst().get();
        this.assertStreamingStrategy(streamingParameter);
    }

    @Test
    public void streamingHintOnSource() throws Exception {
        SourceModel sourceModel = (SourceModel)((ConfigurationModel)this.heisenbergExtension.getConfigurationModels().get(0)).getSourceModel("ListenPayments").get();
        ParameterModel streamingParameter = sourceModel.getAllParameterModels().stream().filter(p -> p.getName().equals("streamingStrategy")).findFirst().get();
        this.assertStreamingStrategy(streamingParameter);
    }

    @Test
    public void untestableConnectionProvider() throws Exception {
        ConnectionProviderModel connectionProviderModel = this.veganExtension.getConfigurationModel("apple-config").map(c -> (ConnectionProviderModel)c.getConnectionProviders().get(0)).get();
        Assert.assertThat((Object)connectionProviderModel.supportsConnectivityTesting(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void untestableSdkConnectionProvider() throws Exception {
        ConnectionProviderModel connectionProviderModel = this.veganExtension.getConfigurationModel("kiwi-config").map(c -> (ConnectionProviderModel)c.getConnectionProviders().get(0)).get();
        Assert.assertThat((Object)connectionProviderModel.supportsConnectivityTesting(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testableConnectionProvider() throws Exception {
        ConnectionProviderModel connectionProviderModel = this.veganExtension.getConfigurationModel("banana-config").map(c -> (ConnectionProviderModel)c.getConnectionProviders().get(0)).get();
        Assert.assertThat((Object)connectionProviderModel.supportsConnectivityTesting(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sourceWithReducedBackPressureStrategies() {
        SourceModel source = (SourceModel)((ConfigurationModel)this.heisenbergExtension.getConfigurationModels().get(0)).getSourceModel("ListenPayments").get();
        ParameterModel parameter = source.getAllParameterModels().stream().filter(p -> "onCapacityOverload".equals(p.getName())).findAny().orElseThrow(() -> new IllegalStateException("No backPressureStrategy parameter"));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Object)BackPressureMode.FAIL));
        EnumAnnotation enumAnnotation = (EnumAnnotation)parameter.getType().getAnnotation(EnumAnnotation.class).orElseThrow(() -> new IllegalStateException("No enum annotation"));
        Assert.assertThat(Arrays.asList(enumAnnotation.getValues()), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{BackPressureMode.FAIL.name(), BackPressureMode.DROP.name()}));
    }

    @Test
    public void sourceWithFixedBackPressureStrategy() {
        SourceModel source = (SourceModel)this.heisenbergExtension.getSourceModels().get(0);
        Optional<ParameterModel> parameter = source.getAllParameterModels().stream().filter(p -> "onCapacityOverload".equals(p.getName())).findAny();
        Assert.assertThat((Object)parameter.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void sourceWithInheritedBackPressureStrategies() {
        SourceModel source = (SourceModel)((ConfigurationModel)this.heisenbergExtension.getConfigurationModels().get(0)).getSourceModel("ReconnectableListenPayments").get();
        BackPressureStrategyModelProperty backPressureStrategyModelProperty = (BackPressureStrategyModelProperty)source.getModelProperty(BackPressureStrategyModelProperty.class).get();
        Assert.assertThat((Object)backPressureStrategyModelProperty.getDefaultMode(), (Matcher)CoreMatchers.is((Object)BackPressureMode.FAIL));
        Assert.assertThat((Object)backPressureStrategyModelProperty.getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new BackPressureMode[]{BackPressureMode.FAIL, BackPressureMode.DROP}));
    }

    @Test
    public void sourceWithInvalidDefaultBackPressureStrategies() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("backPressureStrategy parameter has a default value which is not listed as an available option");
        MuleExtensionUtils.loadExtension(BadBackPressureHeisenbergExtension.class);
    }

    @Test
    public void sourceWithInvalidBackPressureStrategies() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        MuleExtensionUtils.loadExtension(IllegalBackPressureHeisenbergExtension.class);
    }

    @Test
    public void objectStoreParameters() {
        OperationModel operationModel = (OperationModel)this.heisenbergExtension.getOperationModel("storeMoney").get();
        ParameterModel parameter = operationModel.getAllParameterModels().stream().filter(p -> "objectStore".equals(p.getName())).findFirst().get();
        StereotypeModel stereotype = parameter.getAllowedStereotypes().stream().filter(s -> s.getType().equals(MuleStereotypes.OBJECT_STORE.getType())).findFirst().get();
        Assert.assertThat((Object)stereotype.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)MuleStereotypes.OBJECT_STORE.getNamespace()));
        Optional<ImportedTypeModel> typeImport = this.heisenbergExtension.getImportedTypes().stream().filter(i -> MetadataTypeUtils.getTypeId((MetadataType)i.getImportedType()).map(id -> ObjectStore.class.getName().equals(id)).orElse(false)).findFirst();
        Assert.assertThat((Object)typeImport.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Story(value="Supported Java Versions are reflected in the ExtensionModel")
    public void defaultJavaVersionSupport() {
        Assert.assertThat((Object)this.heisenbergExtension.getSupportedJavaVersions(), (Matcher)CoreMatchers.equalTo((Object)ExtensionConstants.DEFAULT_SUPPORTED_JAVA_VERSIONS));
    }

    @Test
    @Story(value="Supported Java Versions are reflected in the ExtensionModel")
    public void customJavaVersionSupport() {
        ExtensionModel model = MuleExtensionUtils.loadExtension(TestJavaSupportExtension.class);
        Assert.assertThat((Object)model.getSupportedJavaVersions(), (Matcher)Matchers.contains((Object[])new String[]{JavaVersion.JAVA_8.version(), JavaVersion.JAVA_17.version()}));
    }

    private void assertStreamingStrategy(ParameterModel streamingParameter) {
        Assert.assertThat((Object)streamingParameter.getType(), (Matcher)CoreMatchers.equalTo((Object)new StreamingStrategyTypeBuilder().getByteStreamingStrategyType()));
        Assert.assertThat((Object)streamingParameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)streamingParameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)streamingParameter.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
    }

    private void assertExternalLibraries(HasExternalLibraries model) {
        Assert.assertThat((Object)model.getExternalLibraryModels(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)model.getExternalLibraryModels(), (Matcher)Matchers.hasSize((int)1));
        ExternalLibraryModel library = (ExternalLibraryModel)model.getExternalLibraryModels().iterator().next();
        Assert.assertThat((Object)library.getName(), (Matcher)CoreMatchers.is((Object)"Heisenberg.so"));
        Assert.assertThat((Object)library.getDescription(), (Matcher)CoreMatchers.is((Object)"Native Heisenberg support"));
        Assert.assertThat((Object)((String)library.getRegexMatcher().get()), (Matcher)CoreMatchers.is((Object)"heisenberg.so"));
        Assert.assertThat((Object)((String)library.getRequiredClassName().get()), (Matcher)CoreMatchers.is((Object)"org.heisenberg.HeisenbergJNI"));
    }

    private void assertSinglePrimaryContentParameter(ExtensionModel extensionModel, String operationName, String defaultValue) {
        OperationModel appleOperation = (OperationModel)this.aggressiveGet(extensionModel.getOperationModel(operationName));
        List contentParameters = appleOperation.getAllParameterModels().stream().filter(ExtensionModelUtils::isContent).collect(Collectors.toList());
        Assert.assertThat(contentParameters, (Matcher)Matchers.hasSize((int)1));
        ParameterModel contentParameter = (ParameterModel)contentParameters.get(0);
        Assert.assertThat((Object)contentParameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)contentParameter.getDefaultValue(), (Matcher)CoreMatchers.is((Object)defaultValue));
        Assert.assertThat((Object)contentParameter.getRole(), (Matcher)CoreMatchers.is((Object)ParameterRole.PRIMARY_CONTENT));
    }

    private <T> T aggressiveGet(Optional<T> optional) {
        return optional.orElseThrow(NoSuchElementException::new);
    }

    @Extension(name="DefaultJavaSupport")
    @JavaVersionSupport(value={JavaVersion.JAVA_8, JavaVersion.JAVA_17})
    public static class TestJavaSupportExtension {
    }

    @Alias(value="ListenPayments")
    @EmitsResponse
    @Streaming
    @MediaType(value="text/plain")
    @BackPressure(defaultMode=BackPressureMode.FAIL, supportedModes={BackPressureMode.DROP, BackPressureMode.WAIT})
    public static class IllegalBackPressureSource
    extends HeisenbergSource {
    }

    @Extension(name="Heisenberg", category=Category.SELECT)
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class, KillingOperations.class, HeisenbergScopes.class, HeisenbergRouters.class})
    @OnException(value=HeisenbergConnectionExceptionEnricher.class)
    @ConnectionProviders(value={HeisenbergConnectionProvider.class, SecureHeisenbergConnectionProvider.class})
    @Sources(value={IllegalBackPressureSource.class})
    @Export(classes={HeisenbergExtension.class, HeisenbergException.class}, resources={"methRecipe.json"})
    @SubTypesMapping(value={@SubTypeMapping(baseType=Weapon.class, subTypes={Ricin.class}), @SubTypeMapping(baseType=Investment.class, subTypes={CarWash.class, CarDealer.class})})
    @ErrorTypes(value=HeisenbergErrors.class)
    public static class IllegalBackPressureHeisenbergExtension
    extends HeisenbergExtension {
    }

    @Alias(value="ListenPayments")
    @EmitsResponse
    @Streaming
    @MediaType(value="text/plain")
    @BackPressure(defaultMode=BackPressureMode.FAIL, supportedModes={BackPressureMode.DROP, BackPressureMode.WAIT})
    public static class BadBackPressureSource
    extends HeisenbergSource {
    }

    @Extension(name="Heisenberg", category=Category.SELECT)
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class, KillingOperations.class, HeisenbergScopes.class, HeisenbergRouters.class})
    @OnException(value=HeisenbergConnectionExceptionEnricher.class)
    @ConnectionProviders(value={HeisenbergConnectionProvider.class, SecureHeisenbergConnectionProvider.class})
    @Sources(value={BadBackPressureSource.class})
    @Export(classes={HeisenbergExtension.class, HeisenbergException.class}, resources={"methRecipe.json"})
    @SubTypesMapping(value={@SubTypeMapping(baseType=Weapon.class, subTypes={Ricin.class}), @SubTypeMapping(baseType=Investment.class, subTypes={CarWash.class, CarDealer.class})})
    @ErrorTypes(value=HeisenbergErrors.class)
    public static class BadBackPressureHeisenbergExtension
    extends HeisenbergExtension {
    }
}

