/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ParameterGroupLayoutOrderTestCase {
    private static final String GROUP_NAME = "Group1";
    private ParameterizedModel parameterizedModel;
    private ExtensionModel extensionModel;

    @Before
    public void setUp() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(OrderedExtension.class);
    }

    @Test
    public void configGroupImplicitOrderTestCase() {
        this.parameterizedModel = this.getConfig("GroupImplicitOrderConfig");
        this.assertGroupOrder(this.parameterizedModel, 1, 2);
    }

    @Test
    public void configGroupExplicitOrderTestCase() {
        this.parameterizedModel = this.getConfig("GroupExplicitOrderConfig");
        this.assertGroupOrder(this.parameterizedModel, 1, 2);
    }

    @Test
    public void configGroupReorderGeneralTestCase() {
        this.parameterizedModel = this.getConfig("GroupReorderGeneralConfig");
        this.assertGroupOrder(this.parameterizedModel, 0, 1);
    }

    @Test
    public void configGroupNoGeneralTestCase() {
        this.parameterizedModel = this.getConfig("GroupNoGeneralConfig");
        this.assertParameterOrder(this.parameterizedModel, GROUP_NAME, 1);
    }

    @Test
    public void configGroupOnlyGeneralTestCase() {
        this.parameterizedModel = this.getConfig("GroupOnlyGeneralConfig");
        this.assertParameterOrder(this.parameterizedModel, "General", 1);
    }

    @Test
    public void operationGroupImplicitOrderTestCase() {
        this.parameterizedModel = this.getOperation("implicitOrder");
        this.assertGroupOrder(this.parameterizedModel, 1, 2);
    }

    @Test
    public void operationGroupExplicitOrderTestCase() {
        this.parameterizedModel = this.getOperation("explicitOrder");
        this.assertGroupOrder(this.parameterizedModel, 1, 2);
    }

    @Test
    public void operationGroupReorderGeneralTestCase() {
        this.parameterizedModel = this.getOperation("reorder");
        this.assertGroupOrder(this.parameterizedModel, 0, 1);
    }

    @Test
    public void operationGroupNoGeneralTestCase() {
        this.parameterizedModel = this.getOperation("noGeneral");
        this.assertParameterOrder(this.parameterizedModel, GROUP_NAME, 1);
    }

    @Test
    public void operationGroupOnlyGeneralTestCase() {
        this.parameterizedModel = this.getOperation("onlyGeneral");
        this.assertParameterOrder(this.parameterizedModel, "General", 1);
    }

    private ConfigurationModel getConfig(String name) {
        return (ConfigurationModel)this.extensionModel.getConfigurationModel(name).get();
    }

    private OperationModel getOperation(String name) {
        return (OperationModel)this.extensionModel.getOperationModel(name).get();
    }

    private void assertGroupOrder(ParameterizedModel parameterizedModel, int expectedOrder, int expectedOrder2) {
        this.assertParameterOrder(parameterizedModel, "General", expectedOrder);
        this.assertParameterOrder(parameterizedModel, GROUP_NAME, expectedOrder2);
    }

    private void assertParameterOrder(ParameterizedModel parameterizedModel, String parameterName, int expectedOrder) {
        ParameterGroupModel paramOne = (ParameterGroupModel)MuleExtensionUtils.getNamedObject((List)parameterizedModel.getParameterGroupModels(), (String)parameterName);
        Optional layoutModel = paramOne.getLayoutModel();
        EnricherTestUtils.assertLayoutModel(parameterName, expectedOrder, layoutModel);
    }

    public static class OrderedOperations {
        public void noGeneral(@Placement(order=1) @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Group1") GroupImplicitOrder group) {
        }

        public void reorder(String param, @Placement(order=1) @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Group1") GroupImplicitOrder group) {
        }

        public void explicitOrder(String param, @Placement(order=2) @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Group1") GroupImplicitOrder group) {
        }

        public void implicitOrder(String param, @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Group1") GroupImplicitOrder group) {
        }

        public void onlyGeneral(String param) {
        }
    }

    @Configuration(name="GroupOnlyGeneralConfig")
    public static class ParameterGroupOnlyGeneral {
        @Parameter
        String paramOneGeneral;
        @Parameter
        String paramTwoGeneral;
    }

    @Configuration(name="GroupNoGeneralConfig")
    public static class ParameterGroupNoGeneral {
        @Placement(order=1)
        @ParameterGroup(name="Group1")
        GroupImplicitOrder groupOne;
    }

    @Configuration(name="GroupReorderGeneralConfig")
    public static class ParameterGroupReorder {
        @Placement(order=1)
        @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Group1")
        GroupImplicitOrder groupOne;
        @Parameter
        String paramOneGeneral;
        @Parameter
        String paramTwoGeneral;
    }

    @Configuration(name="GroupExplicitOrderConfig")
    public static class ParameterGroupExplicitOrder {
        @Placement(order=2)
        @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Group1")
        GroupImplicitOrder groupOne;
        @Parameter
        String paramOneGeneral;
        @Parameter
        String paramTwoGeneral;
    }

    @Configuration(name="GroupImplicitOrderConfig")
    public static class ParameterGroupImplicitOrder {
        @ParameterGroup(name="Group1")
        GroupImplicitOrder groupOne;
        @Parameter
        String paramOneGeneral;
        @Parameter
        String paramTwoGeneral;
    }

    public static class GroupImplicitOrder {
        @Parameter
        String paramOne;
        @Parameter
        String paramThree;
    }

    @Extension(name="OrderedExtension")
    @Operations(value={OrderedOperations.class})
    @Configurations(value={ParameterGroupImplicitOrder.class, ParameterGroupExplicitOrder.class, ParameterGroupReorder.class, ParameterGroupNoGeneral.class, ParameterGroupOnlyGeneral.class})
    public static class OrderedExtension {
    }
}

