/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.HashMap;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionInterceptor;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.test.petstore.extension.PetStoreConnector;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionInterceptorTestCase
extends AbstractMuleContextTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ExecutionContextAdapter operationContext;
    @Mock(lenient=true)
    private ConfigurationInstance configurationInstance;
    @Mock(lenient=true)
    private PetStoreConnector config;
    @Mock(lenient=true)
    private ExtensionConnectionSupplier connectionSupplier;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ConnectionHandler connectionHandler;
    private ConnectionInterceptor interceptor;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.operationContext.getComponentModel()).thenReturn((Object)this.operationModel);
        Mockito.when((Object)this.operationModel.getModelProperty(PagedOperationModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn((Object)this.config);
        HashMap contextVariables = new HashMap();
        Mockito.when((Object)this.operationContext.getVariable((String)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> contextVariables.get(invocationOnMock.getArguments()[0]));
        Mockito.when((Object)this.operationContext.setVariable((String)ArgumentMatchers.any(), ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            Object[] arguments = invocationOnMock.getArguments();
            return contextVariables.put((String)arguments[0], arguments[1]);
        });
        Mockito.when((Object)this.operationContext.removeVariable((String)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> contextVariables.remove(invocationOnMock.getArguments()[0]));
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.empty());
        this.interceptor = new ConnectionInterceptor(this.connectionSupplier, (ComponentTracer)Mockito.mock(ComponentTracer.class));
        Mockito.when((Object)this.connectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.eq((Object)this.operationContext), (ComponentTracer)ArgumentMatchers.any(ComponentTracer.class))).thenReturn((Object)this.connectionHandler);
    }

    @Test
    public void pagedOperation() throws Exception {
        Mockito.when((Object)this.operationModel.getModelProperty(PagedOperationModelProperty.class)).thenReturn(Optional.of(new PagedOperationModelProperty()));
        this.interceptor.before((ExecutionContext)this.operationContext);
        ((ExtensionConnectionSupplier)Mockito.verify((Object)this.connectionSupplier, (VerificationMode)Mockito.never())).getConnection((ExecutionContextAdapter)ArgumentMatchers.eq((Object)this.operationContext), (ComponentTracer)ArgumentMatchers.any());
    }

    @Test
    public void onSuccess() throws Exception {
        this.interceptor.before((ExecutionContext)this.operationContext);
        this.interceptor.onSuccess((ExecutionContext)this.operationContext, null);
        this.interceptor.after((ExecutionContext)this.operationContext, null);
        ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler)).release();
    }

    @Test
    public void onConnectionException() throws Exception {
        this.interceptor.before((ExecutionContext)this.operationContext);
        this.interceptor.onError((ExecutionContext)this.operationContext, (Throwable)new ConnectionException("Bleh"));
        this.interceptor.after((ExecutionContext)this.operationContext, null);
        ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler)).invalidate();
    }

    @Test
    public void onNonConnectionException() throws Exception {
        this.interceptor.before((ExecutionContext)this.operationContext);
        this.interceptor.onError((ExecutionContext)this.operationContext, (Throwable)new Exception());
        this.interceptor.after((ExecutionContext)this.operationContext, null);
        ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler)).release();
    }

    @Test
    public void onNonConnectionExceptionWithSupport() throws Exception {
        Mockito.when((Object)this.operationModel.supportsStreaming()).thenReturn((Object)true);
        this.interceptor.before((ExecutionContext)this.operationContext);
        this.interceptor.onError((ExecutionContext)this.operationContext, (Throwable)new Exception());
        this.interceptor.after((ExecutionContext)this.operationContext, null);
        ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler)).release();
    }
}

