/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.util.FieldSetter;

@Issue(value="W-14391247")
@Feature(value="SDK OAuth Extension")
public class ClientCredentialsConnectionProviderWrapperTestCase {
    @Test
    public void listenerIsUnRegisteredOnStop() throws MuleException {
        ConnectionProvider delegate = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        ClientCredentialsConfig oauthConfig = (ClientCredentialsConfig)Mockito.mock(ClientCredentialsConfig.class);
        ClientCredentialsGrantType type = new ClientCredentialsGrantType("http://accessToken", "#[accessToken]", ".*", null, CredentialsPlacement.BODY);
        Mockito.when((Object)oauthConfig.getGrantType()).thenReturn((Object)type);
        HashMap<Field, String> callbackValues = new HashMap<Field, String>();
        ClientCredentialsOAuthHandler oauthHandler = (ClientCredentialsOAuthHandler)Mockito.mock(ClientCredentialsOAuthHandler.class);
        Mockito.when((Object)oauthHandler.getOAuthContext((ClientCredentialsConfig)ArgumentMatchers.any())).thenReturn((Object)((ResourceOwnerOAuthContext)Mockito.mock(ResourceOwnerOAuthContext.class)));
        ReconnectionConfig reconnectionConfig = (ReconnectionConfig)Mockito.mock(ReconnectionConfig.class);
        TestClientCredentialsConnectionProviderWrapper wrapper = new TestClientCredentialsConnectionProviderWrapper(delegate, oauthConfig, callbackValues, oauthHandler, reconnectionConfig);
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)Mockito.mock(ClientCredentialsOAuthDancer.class);
        Mockito.when((Object)oauthHandler.register((ClientCredentialsConfig)ArgumentMatchers.any())).thenReturn((Object)dancer);
        wrapper.start();
        wrapper.connect();
        ((ClientCredentialsOAuthDancer)Mockito.verify((Object)dancer, (VerificationMode)Mockito.times((int)1))).addListener((ClientCredentialsListener)ArgumentMatchers.any());
        wrapper.stop();
        ((ClientCredentialsOAuthDancer)Mockito.verify((Object)dancer, (VerificationMode)Mockito.times((int)1))).removeListener((ClientCredentialsListener)ArgumentMatchers.any());
    }

    private class TestClientCredentialsConnectionProviderWrapper
    extends ClientCredentialsConnectionProviderWrapper {
        public TestClientCredentialsConnectionProviderWrapper(ConnectionProvider delegate, ClientCredentialsConfig oauthConfig, Map<Field, String> callbackValues, ClientCredentialsOAuthHandler oauthHandler, ReconnectionConfig reconnectionConfig) {
            super(delegate, oauthConfig, callbackValues, oauthHandler, reconnectionConfig);
        }

        protected FieldSetter<Object, Object> resolveOauthStateSetter(ClientCredentialsConfig oauthConfig) {
            return (FieldSetter)Mockito.mock(FieldSetter.class);
        }
    }
}

