/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.SourceClusterSupportModelProperty;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.source.SourceClusterSupport;
import org.mule.sdk.api.exception.ModuleException;
import org.mule.sdk.api.runtime.exception.ExceptionHandler;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.test.heisenberg.extension.AsyncHeisenbergSource;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.heisenberg.extension.SecureHeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.SaleInfo;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.types.DEAOfficerAttributes;
import org.mule.test.heisenberg.extension.model.types.IntegerAttributes;
import org.mule.test.heisenberg.extension.model.types.WeaponType;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.vegan.extension.PaulMcCartneySource;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
public class JavaDeclarationDelegateTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private static final String GET_GRAMS_IN_STORAGE = "getGramsInStorage";
    private static final String EXTENDED_CONFIG_NAME = "extended-config";
    private static final String SOURCE_NAME = "ListenPayments";
    private static final String ASYNC_SOURCE_NAME = "AsyncListenPayments";
    private static final String DEA_SOURCE_NAME = "dea-radio";
    private static final String SOURCE_PARAMETER = "initialBatchNumber";
    private static final String SOURCE_CALLBACK_PARAMETER = "payment";
    private static final String SOURCE_REPEATED_CALLBACK_PARAMETER = "sameNameParameter";
    private static final String SAY_MY_NAME_OPERATION = "sayMyName";
    private static final String NAME_AS_STREAM = "nameAsStream";
    private static final String GET_ENEMY_OPERATION = "getEnemy";
    private static final String GET_ALL_ENEMIES_OPERATION = "getAllEnemies";
    private static final String KILL_OPERATION = "kill";
    private static final String KILL_CUSTOM_OPERATION = "killWithCustomMessage";
    private static final String KILL_WITH_WEAPON = "killWithWeapon";
    private static final String KILL_WITH_RICINS = "killWithRicins";
    private static final String KILL_WITH_MULTIPLES_WEAPONS = "killWithMultiplesWeapons";
    private static final String KILL_WITH_MULTIPLE_WILDCARD_WEAPONS = "killWithMultipleWildCardWeapons";
    private static final String GET_PAGED_PERSONAL_INFO_OPERATION = "getPagedPersonalInfo";
    private static final String EMPTY_PAGED_OPERATION = "emptyPagedOperation";
    private static final String FAILING_PAGED_OPERATION = "failingPagedOperation";
    private static final String CONNECTION_PAGED_OPERATION = "pagedOperationUsingConnection";
    private static final String DIE = "die";
    private static final String LAUNDER_MONEY = "launder";
    private static final String INJECTED_EXTENSION_MANAGER = "getInjectedExtensionManager";
    private static final String ALIAS = "alias";
    private static final String KNOCK = "knock";
    private static final String KNOCK_MANY = "knockMany";
    private static final String CALL_SAUL = "callSaul";
    private static final String CALL_GUS_FRING = "callGusFring";
    private static final String CURE_CANCER = "cureCancer";
    private static final String GET_SAUL_PHONE = "getSaulPhone";
    private static final String GET_MEDICAL_HISTORY = "getMedicalHistory";
    private static final String APPROVE_INVESTMENT = "approve";
    private static final String IGNORED_OPERATION = "ignoredOperation";
    private static final String IGNORED_SOURCE = "ignored";
    private static final String IGNORED_SDK_SOURCE = "sdk-ignored";
    private static final String OTHER_HEISENBERG = "OtherHeisenberg";
    private static final String PROCESS_WEAPON = "processWeapon";
    private static final String PROCESS_WEAPON_LIST = "processWeaponList";
    private static final String PROCESS_WEAPON_WITH_DEFAULT_VALUE = "processWeaponWithDefaultValue";
    private static final String PROCESS_INFO = "processSale";
    private static final String FAIL_TO_EXECUTE = "failToExecute";
    private static final String THROW_ERROR = "throwError";
    public static final String ECHO_AN_OPERATION_WITH_ALIAS = "echo";
    public static final String GET_SECOND_BARBER_PREFERENCE = "getSecondBarberPreferences";
    public static final String BY_PASS_WEAPON = "byPassWeapon";
    public static final MetadataType WEAPON_TYPE = ExtensionsTestUtils.TYPE_LOADER.load(Weapon.class);
    public static final MetadataType STRING_TYPE = ExtensionsTestUtils.TYPE_LOADER.load(String.class);
    public static final MetadataType INT_TYPE = ExtensionsTestUtils.toMetadataType(Integer.TYPE);

    @Before
    public void setUp() {
        this.setDeclarer(this.declarerFor(HeisenbergExtension.class));
    }

    @Test
    public void describeTestModule() throws Exception {
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        this.assertExtensionProperties(extensionDeclaration, "Heisenberg");
        this.assertTestModuleConfiguration(extensionDeclaration);
        this.assertTestModuleOperations(extensionDeclaration);
        this.assertTestModuleConnectionProviders(extensionDeclaration);
        this.assertTestModuleMessageSource(extensionDeclaration);
        this.assertModelProperties(extensionDeclaration);
    }

    @Test
    public void heisenbergPointer() throws Exception {
        this.setDeclarer(this.declarerFor(HeisenbergPointer.class));
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        this.assertExtensionProperties(extensionDeclaration, OTHER_HEISENBERG);
        this.assertTestModuleConfiguration(extensionDeclaration);
        this.assertTestModuleOperations(extensionDeclaration);
        this.assertTestModuleConnectionProviders(extensionDeclaration);
        this.assertTestModuleMessageSource(extensionDeclaration);
        this.assertModelProperties(extensionDeclaration);
    }

    @Test
    public void heisenbergPointerPlusExternalConfig() {
        this.setDeclarer(this.declarerFor(HeisenbergPointerPlusExternalConfig.class));
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declareExtension().getDeclaration();
        this.assertExtensionProperties(extensionDeclaration, OTHER_HEISENBERG);
        Assert.assertThat((Object)extensionDeclaration.getConfigurations().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        ConfigurationDeclaration configuration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(1);
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.equalTo((Object)EXTENDED_CONFIG_NAME));
        Assert.assertThat((Object)configuration.getAllParameters(), (Matcher)Matchers.hasSize((int)35));
        this.assertParameter(configuration.getAllParameters(), "extendedProperty", "", STRING_TYPE, true, ExpressionSupport.SUPPORTED, null);
    }

    @Test(expected=IllegalConfigurationModelDefinitionException.class)
    public void heisenbergWithOperationsConfig() {
        this.declarerFor(HeisenbergWithSameOperationsAndConfigs.class);
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void heisenbergWithParameterGroupAsOptional() {
        this.declarerFor(HeisenbergWithParameterGroupAsOptional.class);
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void heisenbergWithRecursiveParameterGroup() {
        this.declarerFor(HeisenbergWithRecursiveParameterGroup.class);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void heisenbergWithMoreThanOneConfigInOperation() {
        this.declarerFor(HeisenbergWithInvalidOperation.class);
    }

    @Test(expected=IllegalOperationModelDefinitionException.class)
    public void heisenbergWithOperationPointingToExtension() {
        this.declarerFor(HeisenbergWithOperationsPointingToExtension.class);
    }

    @Test(expected=IllegalConfigurationModelDefinitionException.class)
    public void heisenbergWithOperationPointingToExtensionAndDefaultConfig() {
        this.declarerFor(HeisenbergWithOperationsPointingToExtensionAndDefaultConfig.class);
    }

    @Test
    public void messageOperationWithoutGenerics() {
        ExtensionDeclarer declarer = this.declarerFor(HeisenbergWithGenericlessMessageOperation.class);
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)declarer.getDeclaration(), "noGenerics");
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
    }

    @Test
    public void listOfResultsOperation() throws Exception {
        ExtensionDeclarer declarer = this.declarerFor(HeisenbergWithListOfResultOperations.class);
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)declarer.getDeclaration(), "listOfResults");
        MetadataType outputType = operation.getOutput().getType();
        Assert.assertThat((Object)outputType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType(((ArrayType)outputType).getType(), ExtensionsTestUtils.TYPE_LOADER.load(Integer.class), ExtensionsTestUtils.TYPE_LOADER.load(IntegerAttributes.class));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void invalidParameterGroupName() throws Exception {
        this.declarerFor(HeisenbergWithParameterGroupDefaultName.class);
    }

    @Test
    public void listOfResultsOperationWithoutGenerics() throws Exception {
        ExtensionDeclarer declarer = this.declarerFor(HeisenbergWithListOfResultOperations.class);
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)declarer.getDeclaration(), "listOfResultsWithoutGenerics");
        MetadataType outputType = operation.getOutput().getType();
        Assert.assertThat((Object)outputType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType(((ArrayType)outputType).getType(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.anyType().build(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.anyType().build());
    }

    @Test
    public void flyweight() {
        ExtensionDeclarer declarer = this.declarerFor(VeganExtension.class);
        ExtensionDeclaration declaration = (ExtensionDeclaration)declarer.getDeclaration();
        ConfigurationDeclaration appleConfiguration = (ConfigurationDeclaration)this.findDeclarationByName(declaration.getConfigurations(), "apple-config");
        ConfigurationDeclaration bananaConfiguration = (ConfigurationDeclaration)this.findDeclarationByName(declaration.getConfigurations(), "banana-config");
        String sourceName = PaulMcCartneySource.class.getSimpleName();
        SourceDeclaration appleSource = (SourceDeclaration)this.findDeclarationByName(appleConfiguration.getMessageSources(), sourceName);
        SourceDeclaration bananaSource = (SourceDeclaration)this.findDeclarationByName(bananaConfiguration.getMessageSources(), sourceName);
        Assert.assertThat((Object)appleSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)bananaSource)));
        String operationName = "spreadTheWord";
        OperationDeclaration appleOperation = (OperationDeclaration)this.findDeclarationByName(appleConfiguration.getOperations(), "spreadTheWord");
        OperationDeclaration bananaOperation = (OperationDeclaration)this.findDeclarationByName(bananaConfiguration.getOperations(), "spreadTheWord");
        Assert.assertThat((Object)appleOperation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)bananaOperation)));
    }

    @Test
    public void minMuleVersionIsDescribedCorrectly() {
        ExtensionDeclarer declarer = this.declarerFor(HeisenbergExtension.class);
        declarer.getDeclaration();
    }

    @Test
    public void categoryIsDescribedCorrectly() {
        this.setDeclarer(this.declarerFor(HeisenbergExtension.class));
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration declaration = (ExtensionDeclaration)declarer.getDeclaration();
        Assert.assertThat((Object)declaration.getCategory(), (Matcher)CoreMatchers.is((Object)Category.SELECT));
    }

    @Test
    public void minMuleVersionDefaultValueIsDescribedCorrectly() {
        ExtensionDeclarer declarer = this.declarerFor(PetStoreConnector.class);
        declarer.getDeclaration();
    }

    @Test
    public void categoryDefaultValueIsDescribedCorrectly() {
        this.setDeclarer(this.declarerFor(PetStoreConnector.class));
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration declaration = (ExtensionDeclaration)declarer.getDeclaration();
        Assert.assertThat((Object)declaration.getCategory(), (Matcher)CoreMatchers.is((Object)Category.COMMUNITY));
    }

    @Test
    public void flowListeningOperationWithoutAttributes() {
        this.setDeclarer(this.declarerFor(VeganExtension.class));
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration declaration = (ExtensionDeclaration)declarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)this.getConfiguration(declaration, "banana-config"), "getLunch");
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertOutputType(operation.getOutput(), ExtensionsTestUtils.toMetadataType(Fruit.class), true);
        this.assertOutputType(operation.getOutputAttributes(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.voidType().build(), false);
    }

    @Test
    public void disableIgnore() {
        DefaultExtensionLoadingContext loadingContext = this.createLoadingContext();
        loadingContext.addParameter("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", (Object)true);
        ExtensionDeclarer declarer = this.declarerFor(HeisenbergExtension.class, (ExtensionLoadingContext)loadingContext);
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        Assert.assertThat((Object)this.getOperation((WithOperationsDeclaration)extensionDeclaration, IGNORED_OPERATION), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List ignoredSources = extensionDeclaration.getMessageSources().stream().filter(s -> s.getName().equalsIgnoreCase(IGNORED_SOURCE)).collect(Collectors.toList());
        Assert.assertThat(ignoredSources, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void disableSdkIgnore() {
        DefaultExtensionLoadingContext loadingContext = this.createLoadingContext();
        loadingContext.addParameter("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", (Object)true);
        ExtensionDeclarer declarer = this.declarerFor(HeisenbergExtension.class, (ExtensionLoadingContext)loadingContext);
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        List ignoredSources = extensionDeclaration.getMessageSources().stream().filter(s -> s.getName().equalsIgnoreCase(IGNORED_SDK_SOURCE)).collect(Collectors.toList());
        Assert.assertThat(ignoredSources, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void defaultClusterSupport() {
        SourceDeclaration sourceDeclaration = this.getSourceDeclarationWithName(SOURCE_NAME);
        SourceClusterSupportModelProperty sourceClusterSupportModelProperty = (SourceClusterSupportModelProperty)sourceDeclaration.getModelProperty(SourceClusterSupportModelProperty.class).get();
        Assert.assertThat((Object)sourceClusterSupportModelProperty.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void clusterSupportDefaultingPrimaryNodeOnly() {
        SourceDeclaration sourceDeclaration = this.getSourceDeclarationWithName("listen-payments-cluster");
        SourceClusterSupportModelProperty sourceClusterSupportModelProperty = (SourceClusterSupportModelProperty)sourceDeclaration.getModelProperty(SourceClusterSupportModelProperty.class).get();
        Assert.assertThat((Object)sourceClusterSupportModelProperty.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY));
    }

    @Test
    public void backPressureSupport() {
        SourceDeclaration sourceDeclaration = this.getSourceDeclarationWithName("ListenPaymentsAllOptional");
        BackPressureStrategyModelProperty backPressureStrategyModelProperty = (BackPressureStrategyModelProperty)sourceDeclaration.getModelProperty(BackPressureStrategyModelProperty.class).get();
        Assert.assertThat((Object)backPressureStrategyModelProperty.getDefaultMode(), (Matcher)CoreMatchers.is((Object)BackPressureMode.FAIL));
        Assert.assertThat((Object)backPressureStrategyModelProperty.getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new BackPressureMode[]{BackPressureMode.FAIL, BackPressureMode.DROP}));
    }

    @Test
    public void handlingOfMetadataKeyIdWithoutOutputAndInputResolvers() {
        ExtensionDeclarer declarer = this.declarerFor(ExtensionWithMetadataKeyIdWithoutOutputAndInputResolvers.class);
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)declarer.getDeclaration(), "withParameterWithMetadataKeyId");
        java.util.Optional metadataKeyIdModelProperty = operation.getModelProperty(MetadataKeyIdModelProperty.class);
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            Assert.assertThat((Object)metadataKeyIdModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        } else {
            Assert.assertThat((Object)metadataKeyIdModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)((MetadataKeyIdModelProperty)metadataKeyIdModelProperty.get()).getCategoryName().isPresent(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)((MetadataKeyIdModelProperty)metadataKeyIdModelProperty.get()).getParameterName(), (Matcher)CoreMatchers.is((Object)"someMetadataKeyId"));
        }
    }

    private SourceDeclaration getSourceDeclarationWithName(String sourceName) {
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        ConfigurationDeclaration config = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        return config.getMessageSources().stream().filter(sourceDeclaration -> sourceDeclaration.getName().equals(sourceName)).findFirst().get();
    }

    private DefaultExtensionLoadingContext createLoadingContext() {
        return new DefaultExtensionLoadingContext(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()));
    }

    private <T extends NamedDeclaration> T findDeclarationByName(Collection<T> declarations, String name) {
        return (T)declarations.stream().filter(decl -> decl.getName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException());
    }

    private void assertTestModuleConfiguration(ExtensionDeclaration extensionDeclaration) throws Exception {
        Assert.assertThat((Object)extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        ConfigurationDeclaration conf = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        Assert.assertThat((Object)conf.getName(), (Matcher)CoreMatchers.equalTo((Object)"config"));
        List parameters = conf.getAllParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)34));
        this.assertParameter(parameters, "myName", "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, "Heisenberg");
        this.assertParameter(parameters, "age", "", ExtensionsTestUtils.toMetadataType(Integer.class), false, ExpressionSupport.SUPPORTED, "50");
        this.assertParameter(parameters, "enemies", "", this.listOfString(), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "money", "", ExtensionsTestUtils.toMetadataType(BigDecimal.class), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "cancer", "", ExtensionsTestUtils.toMetadataType(Boolean.TYPE), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "cancer", "", ExtensionsTestUtils.toMetadataType(Boolean.TYPE), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "dateOfBirth", "", ExtensionsTestUtils.toMetadataType(Date.class), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "dateOfDeath", "", ExtensionsTestUtils.toMetadataType(Calendar.class), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "dateOfConception", "", ExtensionsTestUtils.toMetadataType(LocalDateTime.class), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "dateOfGraduation", "", ExtensionsTestUtils.toMetadataType(Calendar.class), false, ExpressionSupport.NOT_SUPPORTED, null);
        this.assertParameter(parameters, "recipe", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().openWith((TypeBuilder)ExtensionsTestUtils.TYPE_BUILDER.numberType().integer().with((TypeAnnotation)new ClassInformationAnnotation(Long.class))).with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Long.class))).build(), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "ricinPacks", "", (MetadataType)ExtensionsTestUtils.arrayOf(Set.class, ExtensionsTestUtils.objectTypeBuilder(Ricin.class)), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "nextDoor", "", ExtensionsTestUtils.toMetadataType(KnockeableDoor.class), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "candidateDoors", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().openWith(ExtensionsTestUtils.objectTypeBuilder(KnockeableDoor.class).build()).with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, KnockeableDoor.class))).build(), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "initialHealth", "", ExtensionsTestUtils.toMetadataType(HealthStatus.class), false, ExpressionSupport.SUPPORTED, "CANCER");
        this.assertParameter(parameters, "finalHealth", "", ExtensionsTestUtils.toMetadataType(HealthStatus.class), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "labAddress", "", STRING_TYPE, false, ExpressionSupport.REQUIRED, null);
        this.assertParameter(parameters, "firstEndevour", "", STRING_TYPE, false, ExpressionSupport.NOT_SUPPORTED, null);
        this.assertParameter(parameters, "weapon", "", ExtensionsTestUtils.toMetadataType(Weapon.class), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "wildCardWeapons", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Weapon.class)), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "wildCards", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "worksAtDEA", "", ExtensionsTestUtils.toMetadataType(Boolean.TYPE), false, ExpressionSupport.SUPPORTED, String.valueOf(Boolean.TRUE));
        this.assertParameter(parameters, "lovesMinerals", "", ExtensionsTestUtils.toMetadataType(Boolean.TYPE), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "monthlyIncomes", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, (TypeBuilder)this.longTypeBuilder()), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "labeledRicin", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().openWith(ExtensionsTestUtils.objectTypeBuilder(Ricin.class)).with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Ricin.class))).build(), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "deathsBySeasons", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, List.class))).openWith((TypeBuilder)ExtensionsTestUtils.TYPE_BUILDER.arrayType().of((TypeBuilder)ExtensionsTestUtils.TYPE_BUILDER.stringType())).build(), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "weaponValueMap", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Weapon.class))).openWith(WEAPON_TYPE).build(), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "healthProgressions", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.arrayType().of(ExtensionsTestUtils.TYPE_LOADER.load(HealthStatus.class)).build(), false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "description", "", ExtensionsTestUtils.toMetadataType(String.class), false, ExpressionSupport.SUPPORTED, "(description)");
    }

    private NumberTypeBuilder longTypeBuilder() {
        return ExtensionsTestUtils.TYPE_BUILDER.numberType().integer().with((TypeAnnotation)new ClassInformationAnnotation(Long.class));
    }

    private void assertExtensionProperties(ExtensionDeclaration extensionDeclaration, String expectedName) {
        Assert.assertThat((Object)extensionDeclaration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)extensionDeclaration.getName(), (Matcher)CoreMatchers.is((Object)expectedName));
        Assert.assertThat((Object)extensionDeclaration.getVersion(), (Matcher)CoreMatchers.is((Object)MuleExtensionModelProvider.MULE_VERSION));
    }

    private void assertTestModuleOperations(ExtensionDeclaration extensionDeclaration) throws Exception {
        Assert.assertThat((Object)extensionDeclaration.getOperations(), (Matcher)Matchers.hasSize((int)66));
        WithOperationsDeclaration withOperationsDeclaration = (WithOperationsDeclaration)extensionDeclaration.getConfigurations().get(0);
        Assert.assertThat((Object)withOperationsDeclaration.getOperations().size(), (Matcher)CoreMatchers.is((Object)26));
        this.assertOperation(withOperationsDeclaration, SAY_MY_NAME_OPERATION, "");
        this.assertOperation(withOperationsDeclaration, NAME_AS_STREAM, "");
        this.assertOperation(withOperationsDeclaration, GET_ENEMY_OPERATION, "");
        this.assertOperation(withOperationsDeclaration, "getEnemyLong", "");
        this.assertOperation(withOperationsDeclaration, GET_ALL_ENEMIES_OPERATION, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, KILL_OPERATION, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, KILL_CUSTOM_OPERATION, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_WEAPON, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_RICINS, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_MULTIPLES_WEAPONS, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_MULTIPLE_WILDCARD_WEAPONS, "");
        this.assertOperation(withOperationsDeclaration, DIE, "");
        this.assertOperation(withOperationsDeclaration, LAUNDER_MONEY, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, INJECTED_EXTENSION_MANAGER, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, ALIAS, "");
        this.assertOperation(withOperationsDeclaration, CALL_SAUL, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, CALL_GUS_FRING, "");
        this.assertOperation(withOperationsDeclaration, GET_SAUL_PHONE, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, GET_MEDICAL_HISTORY, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, GET_GRAMS_IN_STORAGE, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, APPROVE_INVESTMENT, "");
        this.assertOperation(withOperationsDeclaration, GET_PAGED_PERSONAL_INFO_OPERATION, "");
        this.assertOperation(withOperationsDeclaration, EMPTY_PAGED_OPERATION, "");
        this.assertOperation(withOperationsDeclaration, FAILING_PAGED_OPERATION, "");
        this.assertOperation(withOperationsDeclaration, CONNECTION_PAGED_OPERATION, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_INFO, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_WEAPON, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_WEAPON_LIST, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_WEAPON_WITH_DEFAULT_VALUE, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, FAIL_TO_EXECUTE, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, THROW_ERROR, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, BY_PASS_WEAPON, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, ECHO_AN_OPERATION_WITH_ALIAS, "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, "executeRemoteKill", "");
        this.assertOperation((WithOperationsDeclaration)extensionDeclaration, "callGusFringNonBlocking", "");
        this.assertOperation(withOperationsDeclaration, "pagedOperationWithExtensionClassLoader", "");
        this.assertOperation(withOperationsDeclaration, "getDrugs", "");
        this.assertOperation(withOperationsDeclaration, "failAtClosePagedOperation", "");
        this.assertOperation(withOperationsDeclaration, "failingConnectivityPagedOperation", "");
        this.assertOperation(withOperationsDeclaration, "nameAsStreamConnected", "");
        this.assertOperation(withOperationsDeclaration, GET_SECOND_BARBER_PREFERENCE, "");
        OperationDeclaration operation = this.getOperation(withOperationsDeclaration, SAY_MY_NAME_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        operation = this.getOperation(withOperationsDeclaration, GET_ENEMY_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.equalTo((Object)STRING_TYPE));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.equalTo((Object)ExtensionsTestUtils.toMetadataType(IntegerAttributes.class)));
        this.assertParameter(operation.getAllParameters(), "index", "", INT_TYPE, false, ExpressionSupport.SUPPORTED, "0");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation(withOperationsDeclaration, GET_ALL_ENEMIES_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertFalse((boolean)operation.getDeprecation().isPresent());
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType(((ArrayType)operation.getOutput().getType()).getType(), STRING_TYPE, ExtensionsTestUtils.TYPE_LOADER.load(IntegerAttributes.class));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.equalTo((Object)STRING_TYPE));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
        this.assertParameter(operation.getAllParameters(), "victim", "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertParameter(operation.getAllParameters(), "goodbyeMessage", "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, "We are done");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_WEAPON);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)3));
        this.assertParameter(operation.getAllParameters(), "weapon", "", WEAPON_TYPE, true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(operation.getAllParameters(), "type", "", ExtensionsTestUtils.toMetadataType(WeaponType.class), true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(operation.getAllParameters(), "attributesOfWeapon", "", ExtensionsTestUtils.toMetadataType(Weapon.WeaponAttributes.class), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_RICINS);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(operation.getAllParameters(), "ricins", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Ricin.class)), false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_MULTIPLES_WEAPONS);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(operation.getAllParameters(), "weapons", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Weapon.class)), false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_WITH_MULTIPLE_WILDCARD_WEAPONS);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(operation.getAllParameters(), "wildCardWeapons", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Weapon.class)), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_CUSTOM_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)2));
        this.assertParameter(operation.getAllParameters(), "victim", "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertParameter(operation.getAllParameters(), "goodbyeMessage", "", STRING_TYPE, true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation(withOperationsDeclaration, LAUNDER_MONEY);
        this.assertParameter(operation.getAllParameters(), "amount", "", ExtensionsTestUtils.toMetadataType(Long.TYPE), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, INJECTED_EXTENSION_MANAGER);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, ALIAS);
        this.assertParameter(operation.getAllParameters(), "greeting", "", STRING_TYPE, true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(operation.getAllParameters(), "myName", "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, "Heisenberg");
        this.assertParameter(operation.getAllParameters(), "age", "", ExtensionsTestUtils.toMetadataType(Integer.class), false, ExpressionSupport.SUPPORTED, "50");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KNOCK);
        this.assertParameter(operation.getAllParameters(), "knockedDoor", "", ExtensionsTestUtils.toMetadataType(KnockeableDoor.class), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KNOCK_MANY);
        this.assertParameter(operation.getAllParameters(), "doors", "", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(KnockeableDoor.class)), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation(withOperationsDeclaration, CALL_SAUL);
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        this.assertConnected((ExecutableComponentDeclaration)operation, true);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, CURE_CANCER);
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        java.util.Optional<SdkExceptionHandlerFactory> exceptionEnricherFactory = operation.getModelProperty(ExceptionHandlerModelProperty.class).map(ExceptionHandlerModelProperty::getExceptionHandlerFactory);
        Assert.assertThat((Object)exceptionEnricherFactory.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ExceptionHandler handler = exceptionEnricherFactory.get().createHandler();
        Exception exception = handler.enrichException(new Exception());
        Assert.assertThat((Object)exception, (Matcher)CoreMatchers.instanceOf(ModuleException.class));
        Assert.assertThat((Object)((ModuleException)exception).getType(), (Matcher)CoreMatchers.is((Object)HeisenbergErrors.HEALTH));
        Assert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.instanceOf(HeisenbergException.class));
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, GET_MEDICAL_HISTORY);
        this.assertParameter(operation.getAllParameters(), "healthByYear", "", (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, HealthStatus.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(HealthStatus.class)).build(), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, GET_GRAMS_IN_STORAGE);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "grams", "", ExtensionsTestUtils.TYPE_LOADER.load(int[][].class), false, ExpressionSupport.SUPPORTED, "#[payload]");
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Object)ExtensionsTestUtils.TYPE_LOADER.load(int[][].class)));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, APPROVE_INVESTMENT);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "investment", "", ExtensionsTestUtils.TYPE_LOADER.load(Investment.class), true, ExpressionSupport.SUPPORTED, null);
        Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)operation.getOutput().getType()), (Matcher)CoreMatchers.equalTo((Object)JavaTypeUtils.getType((MetadataType)ExtensionsTestUtils.TYPE_LOADER.load(Investment.class))));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, IGNORED_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        operation = this.getOperation(withOperationsDeclaration, GET_PAGED_PERSONAL_INFO_OPERATION);
        Assert.assertThat((Object)operation.getModelProperty(PagedOperationModelProperty.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ArrayType outputType = (ArrayType)operation.getOutput().getType();
        Assert.assertThat((Object)outputType.getType(), (Matcher)CoreMatchers.is((Object)ExtensionsTestUtils.TYPE_LOADER.load(PersonalInfo.class)));
        this.assertConnected((ExecutableComponentDeclaration)operation, true);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_INFO);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        this.assertParameter(operation.getAllParameters(), "sales", "", ExtensionsTestUtils.TYPE_LOADER.load(new TypeToken<Map<String, SaleInfo>>(){}.getType()), true, ExpressionSupport.SUPPORTED, null);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_WEAPON);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "weapon", "", WEAPON_TYPE, false, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_WEAPON_LIST);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "weapons", "", ExtensionsTestUtils.TYPE_LOADER.load(new TypeToken<List<Weapon>>(){}.getType()), false, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, PROCESS_WEAPON_WITH_DEFAULT_VALUE);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "weapon", "", WEAPON_TYPE, false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "processWeaponListWithDefaultValue");
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "weapons", "", ExtensionsTestUtils.TYPE_LOADER.load(new TypeToken<List<Weapon>>(){}.getType()), false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "processAddressBook");
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "phoneNumbers", "", ExtensionsTestUtils.TYPE_LOADER.load(new TypeToken<List<String>>(){}.getType()), true, ExpressionSupport.SUPPORTED, null);
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, FAIL_TO_EXECUTE);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, THROW_ERROR);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
        operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, BY_PASS_WEAPON);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertParameter(operation.getAllParameters(), "awesomeWeapon", "", WEAPON_TYPE, true, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(operation.getAllParameters(), "awesomeName", "", STRING_TYPE, true, ExpressionSupport.SUPPORTED, null);
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        this.assertConnected((ExecutableComponentDeclaration)operation, false);
        this.assertTransactional((ExecutableComponentDeclaration)operation, false);
    }

    private void assertTestModuleConnectionProviders(ExtensionDeclaration extensionDeclaration) {
        Assert.assertThat((Object)extensionDeclaration.getConnectionProviders(), (Matcher)Matchers.hasSize((int)2));
        ConnectionProviderDeclaration connectionProvider = (ConnectionProviderDeclaration)extensionDeclaration.getConnectionProviders().get(0);
        Assert.assertThat((Object)connectionProvider.getName(), (Matcher)CoreMatchers.is((Object)"connection"));
        List parameters = connectionProvider.getAllParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertParameter(parameters, "saulPhoneNumber", "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, "505-503-4455");
        ImplementingTypeModelProperty typeModelProperty = (ImplementingTypeModelProperty)connectionProvider.getModelProperty(ImplementingTypeModelProperty.class).get();
        Assert.assertThat((Object)typeModelProperty.getType(), (Matcher)CoreMatchers.equalTo(HeisenbergConnectionProvider.class));
        parameters = ((ConnectionProviderDeclaration)extensionDeclaration.getConnectionProviders().get(1)).getAllParameters();
        this.assertParameter(parameters, "tlsContext", "", ExtensionsTestUtils.toMetadataType(TlsContextFactory.class), true, ExpressionSupport.NOT_SUPPORTED, null);
    }

    private void assertTestModuleMessageSource(ExtensionDeclaration extensionDeclaration) throws Exception {
        Assert.assertThat((Object)extensionDeclaration.getMessageSources(), (Matcher)Matchers.hasSize((int)1));
        SourceDeclaration source = (SourceDeclaration)extensionDeclaration.getMessageSources().get(0);
        Assert.assertThat((Object)source.getName(), (Matcher)CoreMatchers.is((Object)DEA_SOURCE_NAME));
        MetadataType outputType = source.getOutput().getType();
        Assert.assertThat((Object)outputType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        MetadataType outputMetadataType = IntrospectionUtils.getReturnType((Type)new TypeWrapper(Object.class, ExtensionsTestUtils.TYPE_LOADER));
        ExtensionsTestUtils.assertMessageType(((ArrayType)outputType).getType(), STRING_TYPE, ExtensionsTestUtils.TYPE_LOADER.load(DEAOfficerAttributes.class));
        Assert.assertThat((Object)source.getOutputAttributes().getType(), (Matcher)CoreMatchers.equalTo((Object)outputMetadataType));
        ConfigurationDeclaration config = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        Assert.assertThat((Object)config.getMessageSources(), (Matcher)Matchers.hasSize((int)6));
        this.assertHeisenbergSource((SourceDeclaration)config.getMessageSources().get(0), ASYNC_SOURCE_NAME, AsyncHeisenbergSource.class);
        this.assertHeisenbergSource((SourceDeclaration)config.getMessageSources().get(1), SOURCE_NAME, HeisenbergSource.class);
    }

    private void assertHeisenbergSource(SourceDeclaration source, String sourceName, Class<? extends Source> type) {
        Assert.assertThat((Object)source.getName(), (Matcher)CoreMatchers.is((Object)sourceName));
        List parameters = source.getAllParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)33));
        this.assertParameter(parameters, SOURCE_PARAMETER, "", INT_TYPE, true, ExpressionSupport.NOT_SUPPORTED, null);
        this.assertParameter(parameters, SOURCE_CALLBACK_PARAMETER, "", ExtensionsTestUtils.toMetadataType(Long.class), false, ExpressionSupport.SUPPORTED, "#[payload]");
        this.assertParameter(parameters, SOURCE_REPEATED_CALLBACK_PARAMETER, "", STRING_TYPE, false, ExpressionSupport.SUPPORTED, null);
        this.assertParameter(parameters, "methylamine", "", ExtensionsTestUtils.toMetadataType(Methylamine.class), false, ExpressionSupport.SUPPORTED, null);
        ImplementingTypeModelProperty typeModelProperty = (ImplementingTypeModelProperty)source.getModelProperty(ImplementingTypeModelProperty.class).get();
        Assert.assertThat((Object)typeModelProperty.getType(), (Matcher)CoreMatchers.equalTo(type));
    }

    private void assertOperation(WithOperationsDeclaration declaration, String operationName, String operationDescription) throws Exception {
        OperationDeclaration operation = this.getOperation(declaration, operationName);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.equalTo((Object)operationDescription));
    }

    private void assertParameter(List<ParameterDeclaration> parameters, String name, String description, MetadataType metadataType, boolean required, ExpressionSupport expressionSupport, Object defaultValue) {
        ParameterDeclaration param = this.findParameter(parameters, name);
        Assert.assertThat((Object)param, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)param.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)param.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
        this.assertParameterType(metadataType, param);
        Assert.assertThat((Object)param.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)param.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)expressionSupport));
        Assert.assertThat((Object)param.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
    }

    private void assertParameterType(MetadataType metadataType, ParameterDeclaration param) {
        ClassInformationAnnotation typeInfo = metadataType.getAnnotation(ClassInformationAnnotation.class).orElse(null);
        if (typeInfo != null) {
            ClassInformationAnnotation paramTypeInfo = param.getType().getAnnotation(ClassInformationAnnotation.class).orElse(null);
            Assert.assertThat((Object)typeInfo.getClassname(), (Matcher)CoreMatchers.equalTo((Object)paramTypeInfo.getClassname()));
        } else {
            Assert.assertThat((Object)ExtensionMetadataTypeUtils.getId((MetadataType)metadataType), (Matcher)CoreMatchers.equalTo((Object)ExtensionMetadataTypeUtils.getId((MetadataType)param.getType())));
        }
    }

    private void assertConnected(ExecutableComponentDeclaration declaration, boolean connected) {
        Assert.assertThat((Object)declaration.isRequiresConnection(), (Matcher)CoreMatchers.is((Object)connected));
    }

    private void assertTransactional(ExecutableComponentDeclaration declaration, boolean transactional) {
        Assert.assertThat((Object)declaration.isTransactional(), (Matcher)CoreMatchers.is((Object)transactional));
    }

    private void assertOutputType(OutputDeclaration output, MetadataType type, boolean isDynamic) {
        MetadataType outputType = output.getType();
        String outputTypeId = ExtensionMetadataTypeUtils.getId((MetadataType)outputType).orElse(null);
        String actualTypeId = ExtensionMetadataTypeUtils.getId((MetadataType)type).orElse(null);
        if (outputTypeId != null && type instanceof ObjectType) {
            Assert.assertThat((Object)actualTypeId, (Matcher)CoreMatchers.equalTo((Object)actualTypeId));
        } else {
            Assert.assertThat((Object)outputType, (Matcher)CoreMatchers.equalTo((Object)type));
        }
        Assert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)isDynamic));
    }

    private MetadataType listOfString() {
        return ExtensionsTestUtils.TYPE_BUILDER.arrayType().of((TypeBuilder)ExtensionsTestUtils.TYPE_BUILDER.stringType()).with((TypeAnnotation)new ClassInformationAnnotation(List.class)).build();
    }

    protected void assertModelProperties(ExtensionDeclaration extensionDeclaration) {
        ImplementingTypeModelProperty implementingTypeModelProperty = (ImplementingTypeModelProperty)extensionDeclaration.getModelProperty(ImplementingTypeModelProperty.class).get();
        Assert.assertThat((Object)implementingTypeModelProperty, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)HeisenbergExtension.class.isAssignableFrom(implementingTypeModelProperty.getType()), (Matcher)CoreMatchers.is((Object)true));
    }

    public static class MetadataResolver
    implements TypeKeysResolver {
        public String getCategoryName() {
            return null;
        }

        public Set<MetadataKey> getKeys(MetadataContext context) {
            return null;
        }
    }

    public static class OperationWithMetadataKeyId {
        public void withParameterWithMetadataKeyId(@MetadataKeyId(value=MetadataResolver.class) String someMetadataKeyId) {
        }
    }

    @Extension(name="Extension With MetadataKeyId Without Output And Input Resolvers")
    @Operations(value={OperationWithMetadataKeyId.class})
    public static class ExtensionWithMetadataKeyIdWithoutOutputAndInputResolvers {
    }

    private static class RecursiveParameterGroup {
        @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="recursive")
        private RecursiveParameterGroup recursiveParameterGroup;

        private RecursiveParameterGroup() {
        }
    }

    @Operations(value={HeisenbergExtension.class})
    public static class HeisenbergIsolatedConfig {
        @Parameter
        private String extendedProperty;

        public String getExtendedProperty() {
            return this.extendedProperty;
        }

        public void setExtendedProperty(String extendedProperty) {
            this.extendedProperty = extendedProperty;
        }
    }

    public static class HeisenbergAlternateConfig
    extends HeisenbergExtension {
        @Parameter
        private String extendedProperty;

        public String getExtendedProperty() {
            return this.extendedProperty;
        }

        public void setExtendedProperty(String extendedProperty) {
            this.extendedProperty = extendedProperty;
        }
    }

    public static class ListOfResultsOperations {
        public List<Result<Integer, IntegerAttributes>> listOfResults() {
            return null;
        }

        public List<Result> listOfResultsWithoutGenerics() {
            return null;
        }
    }

    public static class GenericlessMessageOperation {
        public Result noGenerics() {
            return null;
        }
    }

    public static class DuplicateConfigOperation {
        public Long launder(@Config HeisenbergExtension config, @Config HeisenbergExtension config2) {
            return 10L;
        }
    }

    @Extension(name="OtherHeisenberg")
    @Operations(value={HeisenbergExtension.class})
    public static class HeisenbergWithParameterGroupDefaultName {
        @ParameterGroup(name="General")
        private PersonalInfo personalInfo;
    }

    @Extension(name="OtherHeisenberg")
    @Operations(value={HeisenbergExtension.class, ListOfResultsOperations.class})
    public static class HeisenbergWithListOfResultOperations {
    }

    @Extension(name="OtherHeisenberg")
    @Operations(value={HeisenbergExtension.class, GenericlessMessageOperation.class})
    public static class HeisenbergWithGenericlessMessageOperation {
    }

    @Extension(name="OtherHeisenberg")
    @Operations(value={HeisenbergExtension.class})
    public static class HeisenbergWithOperationsPointingToExtensionAndDefaultConfig
    extends HeisenbergExtension {
    }

    @Extension(name="OtherHeisenberg")
    @Configurations(value={HeisenbergIsolatedConfig.class})
    public static class HeisenbergWithOperationsPointingToExtension
    extends HeisenbergExtension {
    }

    @Extension(name="OtherHeisenberg")
    @Operations(value={HeisenbergAlternateConfig.class})
    @Configurations(value={HeisenbergAlternateConfig.class})
    public static class HeisenbergWithSameOperationsAndConfigs
    extends HeisenbergExtension {
    }

    @Extension(name="OtherHeisenberg")
    public static class HeisenbergWithRecursiveParameterGroup
    extends HeisenbergExtension {
        @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="recursive")
        private RecursiveParameterGroup group;
    }

    @Extension(name="OtherHeisenberg")
    public static class HeisenbergWithParameterGroupAsOptional
    extends HeisenbergExtension {
        @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="personalInfo")
        @Optional
        private PersonalInfo personalInfo;
    }

    @Extension(name="OtherHeisenberg")
    @Operations(value={DuplicateConfigOperation.class})
    public static class HeisenbergWithInvalidOperation
    extends HeisenbergExtension {
    }

    @Configuration(name="extended-config")
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class})
    public static class NamedHeisenbergAlternateConfig
    extends HeisenbergAlternateConfig {
    }

    @Extension(name="OtherHeisenberg")
    @Configurations(value={HeisenbergExtension.class, NamedHeisenbergAlternateConfig.class})
    public static class HeisenbergPointerPlusExternalConfig {
    }

    @Extension(name="OtherHeisenberg")
    @Configurations(value={HeisenbergExtension.class})
    @ConnectionProviders(value={HeisenbergConnectionProvider.class, SecureHeisenbergConnectionProvider.class})
    public static class HeisenbergPointer
    extends HeisenbergExtension {
    }
}

