/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.TestComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.IdentityExecutor;
import org.mule.runtime.module.extension.internal.runtime.operation.InfiniteEmitter;
import org.mule.runtime.module.extension.internal.runtime.operation.ItemsConsumer;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.RouteBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Feature(value="Execution Engine")
@Story(value="Reactor")
public class ComponentMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessorTestCase.class);
    @Rule
    public ExpectedException expected = ExpectedException.none();
    protected ComponentMessageProcessor<ComponentModel> processor;
    protected ExtensionModel extensionModel;
    protected ComponentModel componentModel;
    protected ResolverSet resolverSet;
    protected ExtensionManager extensionManager;
    protected PolicyManager mockPolicyManager;
    private Flow testFlow;

    @Before
    public void before() throws MuleException {
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("mock").build());
        this.componentModel = (ComponentModel)Mockito.mock(ComponentModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{EnrichableModel.class}));
        Mockito.when((Object)this.componentModel.getModelProperty(CompletableComponentExecutorModelProperty.class)).thenReturn(Optional.of(new CompletableComponentExecutorModelProperty(IdentityExecutor::create)));
        this.resolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        this.extensionManager = (ExtensionManager)Mockito.mock(ExtensionManager.class);
        this.mockPolicyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        Mockito.when((Object)this.mockPolicyManager.createOperationPolicy((Component)ArgumentMatchers.any(), (CoreEvent)ArgumentMatchers.any(), (OperationParametersProcessor)ArgumentMatchers.any())).thenReturn((Object)DefaultPolicyManager.noPolicyOperation());
        this.testFlow = ComponentMessageProcessorTestCase.getTestFlow((MuleContext)muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.testFlow, (MuleContext)muleContext);
        this.processor = this.createProcessor();
        this.processor.setAnnotations(ComponentMessageProcessorTestCase.getAppleFlowComponentLocationAnnotations());
        this.processor.setComponentLocator(this.componentLocator);
        this.processor.setCacheIdGeneratorFactory(Optional.of((MetadataCacheIdGeneratorFactory)Mockito.mock(MetadataCacheIdGeneratorFactory.class)));
        this.processor.setMuleConfiguration(muleContext.getConfiguration());
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        this.processor.resolverSet = this.resolverSet;
        LifecycleUtils.startIfNeeded(this.processor);
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
        LifecycleUtils.stopIfNeeded((Object)this.testFlow);
        LifecycleUtils.disposeIfNeeded((Object)this.testFlow, (Logger)LOGGER);
    }

    protected ComponentMessageProcessor<ComponentModel> createProcessor() {
        return new TestComponentMessageProcessor(this.extensionModel, this.componentModel, null, null, null, this.resolverSet, null, null, null, null, this.extensionManager, this.mockPolicyManager, null, null, muleContext.getConfiguration().getShutdownTimeout()){

            protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
            }

            public ReactiveProcessor.ProcessingType getInnerProcessingType() {
                return ReactiveProcessor.ProcessingType.CPU_LITE;
            }
        };
    }

    protected CoreEvent.Builder getEventBuilder() {
        return InternalEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.testFlow, (ComponentLocation)TEST_CONNECTOR_LOCATION));
    }

    @Test
    public void happyPath() throws MuleException {
        ResolverSetResult resolverSetResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn((Object)resolverSetResult);
        Assert.assertNotNull((Object)Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block());
    }

    @Test
    public void muleRuntimeExceptionInResolutionResult() throws MuleException {
        ExpressionRuntimeException thrown = new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expectWrapped((Exception)thrown);
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void muleExceptionInResolutionResult() throws MuleException {
        DefaultMuleException thrown = new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expectWrapped((Exception)thrown);
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void runtimeExceptionInResolutionResult() throws MuleException {
        NullPointerException thrown = new NullPointerException("Expected");
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expectWrapped(thrown);
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void messageProcessorLifecycleIsPropagatedToRouteChains() throws MuleException {
        Mockito.clearInvocations((Object[])new ResolverSet[]{this.resolverSet});
        HashMap<String, RouteBuilderValueResolver> valueResolvers = new HashMap<String, RouteBuilderValueResolver>();
        RouteBuilderValueResolver routeBuilderValueResolver = (RouteBuilderValueResolver)Mockito.mock(RouteBuilderValueResolver.class);
        valueResolvers.put("resolver", routeBuilderValueResolver);
        Mockito.when((Object)this.resolverSet.getResolvers()).thenReturn(valueResolvers);
        this.processor.stop();
        ((RouteBuilderValueResolver)Mockito.verify((Object)routeBuilderValueResolver, (VerificationMode)Mockito.times((int)1))).stop();
        this.processor.dispose();
        ((RouteBuilderValueResolver)Mockito.verify((Object)routeBuilderValueResolver, (VerificationMode)Mockito.times((int)1))).dispose();
        this.processor.initialise();
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)1))).initialise();
        this.processor.start();
        ((RouteBuilderValueResolver)Mockito.verify((Object)routeBuilderValueResolver, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void happyPathFluxPublisher() throws MuleException, InterruptedException {
        ResolverSetResult resolverSetResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn((Object)resolverSetResult);
        this.subscribeToParallelPublisherAndAwait(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multipleUpstreamPublishers() throws MuleException, InterruptedException {
        ResolverSetResult resolverSetResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn((Object)resolverSetResult);
        InfiniteEmitter<CoreEvent> eventsEmitter = new InfiniteEmitter<CoreEvent>(() -> ((ComponentMessageProcessorTestCase)this).newEvent());
        InfiniteEmitter<CoreEvent> eventsEmitter2 = new InfiniteEmitter<CoreEvent>(() -> ((ComponentMessageProcessorTestCase)this).newEvent());
        ItemsConsumer eventsConsumer = new ItemsConsumer(10);
        ItemsConsumer eventsConsumer2 = new ItemsConsumer(3);
        Flux.create(eventsEmitter).transform(this.processor).subscribe(eventsConsumer);
        Flux.create(eventsEmitter2).transform(this.processor).subscribe(eventsConsumer2);
        eventsEmitter.start();
        eventsEmitter2.start();
        try {
            Assert.assertThat((Object)eventsConsumer.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)eventsConsumer2.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        }
        finally {
            eventsEmitter.stop();
            eventsEmitter2.stop();
        }
    }

    @Test
    @Issue(value="W-13563214")
    public void newSubscriptionAfterPreviousPublisherTermination() throws MuleException, InterruptedException {
        ResolverSetResult resolverSetResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn((Object)resolverSetResult);
        this.subscribeToParallelPublisherAndAwait(5);
        this.subscribeToParallelPublisherAndAwait(4);
    }

    private void expectWrapped(final Exception expect) {
        this.expected.expect((Matcher)new BaseMatcher<Exception>(){

            public boolean matches(Object o) {
                Exception e = (Exception)Exceptions.unwrap((Throwable)((Exception)o));
                Assert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MessagingException.class)));
                Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)expect)));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("condition not met");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeToParallelPublisherAndAwait(int numEvents) throws InterruptedException {
        InfiniteEmitter<CoreEvent> eventsEmitter = new InfiniteEmitter<CoreEvent>(() -> ((ComponentMessageProcessorTestCase)this).newEvent());
        ItemsConsumer eventsConsumer = new ItemsConsumer(numEvents);
        Flux.create(eventsEmitter).transform(this.processor).doOnNext(Assert::assertNotNull).subscribe(eventsConsumer);
        eventsEmitter.start();
        try {
            Assert.assertThat((Object)eventsConsumer.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        }
        finally {
            eventsEmitter.stop();
        }
    }
}

