/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.property.SourceClusterSupportModelProperty;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaSourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.execution.OnError;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.source.ClusterSupport;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.runtime.connectivity.Reconnectable;
import org.mule.sdk.api.runtime.connectivity.ReconnectionCallback;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.sdk.api.runtime.source.BackPressureContext;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.runtime.source.SourceCompletionCallback;
import org.mule.sdk.api.runtime.source.SourceResult;
import org.mule.sdk.api.store.ObjectStoreManager;
import org.mule.sdk.api.tx.SourceTransactionalAction;
import org.mule.sdk.compatibility.api.utils.ForwardCompatibilityHelper;

public class JavaSourceModelParserTestCase {
    protected JavaSourceModelParser parser;
    protected SourceElement sourceElement;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void defaultClusterSupport() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(TestSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void noClusterSupport() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(NonClusteredSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.NOT_SUPPORTED));
    }

    @Test
    public void clusterSupportDefaultingAllNodes() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(AllNodesSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void clusterSupportDefaultingPrimaryNodeOnly() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(PrimaryNodeSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY));
    }

    @Test
    public void sdkNoClusterSupport() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(SdkNonClusteredSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.NOT_SUPPORTED));
    }

    @Test
    public void sdkClusterSupportDefaultingAllNodes() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(SdkAllNodesSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES));
    }

    @Test
    public void sdkClusterSupportDefaultingPrimaryNodeOnly() {
        SourceClusterSupportModelProperty clusterSupport = this.parseClusterSupportFromSourceClass(SdkPrimaryNodeSource.class);
        Assert.assertThat((Object)clusterSupport.getSourceClusterSupport(), (Matcher)CoreMatchers.is((Object)org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY));
    }

    @Test
    public void noBackPressureStrategy() {
        java.util.Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(TestSource.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void backPressureSourceWithDefaults() {
        java.util.Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(BackPressureSourceWithDefaults.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)BackPressureMode.WAIT));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new BackPressureMode[]{BackPressureMode.WAIT}));
    }

    @Test
    public void sdkBackPressureSourceWithDefaults() {
        java.util.Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(SdkBackPressureSourceWithDefaults.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)BackPressureMode.WAIT));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new BackPressureMode[]{BackPressureMode.WAIT}));
    }

    @Test
    public void backPressureSourceWithSelectedValues() {
        java.util.Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(BackPressureSourceWithSelectedValues.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)BackPressureMode.DROP));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new BackPressureMode[]{BackPressureMode.FAIL, BackPressureMode.DROP}));
    }

    @Test
    public void sdkBackPressureSourceWithSelectedValues() {
        java.util.Optional<BackPressureStrategyModelProperty> backPressureStrategyModelProperty = this.parseBackPressureStrategyFromSourceClass(SdkBackPressureSourceWithSelectedValues.class);
        Assert.assertThat((Object)backPressureStrategyModelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getDefaultMode(), (Matcher)CoreMatchers.is((Object)BackPressureMode.DROP));
        Assert.assertThat((Object)backPressureStrategyModelProperty.get().getSupportedModes(), (Matcher)CoreMatchers.hasItems((Object[])new BackPressureMode[]{BackPressureMode.FAIL, BackPressureMode.DROP}));
    }

    @Test
    public void sourceEmitsResponse() {
        Assert.assertThat((Object)this.parseEmitsResponseFromSourceClass(EmitsResponseSource.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sdkSourceEmitsResponse() {
        Assert.assertThat((Object)this.parseEmitsResponseFromSourceClass(SdkEmitsResponseSource.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sourceDoesNotEmitsResponse() {
        Assert.assertThat((Object)this.parseEmitsResponseFromSourceClass(TestSource.class), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getMMVForSdkApiSource() {
        this.mockSourceWrapperWithClass(SdkNonClusteredSource.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SdkNonClusteredSource has min mule version 4.5.0 because it is annotated with ClusterSupport. ClusterSupport was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForLegacyApiSource() {
        this.mockSourceWrapperWithClass(TestSource.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)ResolvedMinMuleVersion.FIRST_MULE_VERSION));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source TestSource has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForSourceWithListResultOutput() {
        this.mockSourceWrapperWithClass(SourceListResultOutput.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceListResultOutput has min mule version 4.4 because it has a generic of type Result. Result was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceWithResultOutput() {
        this.mockSourceWrapperWithClass(SourceResultOutput.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceResultOutput has min mule version 4.4 because it has a generic of type Result. Result was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceExtendsReconnectable() {
        this.mockSourceWrapperWithClass(SourceImplementsReconnectable.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceImplementsReconnectable has min mule version 4.5.0 because it implements interface Reconnectable. Reconnectable was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceExtendsExtraReconnectable() {
        this.mockSourceWrapperWithClass(SourceImplementsExtraReconnectable.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceImplementsExtraReconnectable has min mule version 4.5.0 because it implements interface ExtraReconnectable. Interface ExtraReconnectable has min mule version 4.5.0 because it implements interface Reconnectable. Reconnectable was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithSdkAnnotation() {
        this.mockSourceWrapperWithClass(SdkEmitsResponseSource.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SdkEmitsResponseSource has min mule version 4.5.0 because it is annotated with EmitsResponse. EmitsResponse was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithSdkField() {
        this.mockSourceWrapperWithClass(SourceWithSdkField.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithSdkField has min mule version 4.5.0 because of its field someField. Field someField has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithInjectedField() {
        this.mockSourceWrapperWithClass(SourceWithInjectedSdkField.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithInjectedSdkField has min mule version 4.5.0 because of its field objectStoreManager. Field objectStoreManager has min mule version 4.5.0 because it is of type ObjectStoreManager. ObjectStoreManager was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithInjectField() {
        this.mockSourceWrapperWithClass(SourceWithInjectedOptionalSdkField.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.1.1"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithInjectedOptionalSdkField has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForSourceWithAutomaticallyInjectedSdkField() {
        this.mockSourceWrapperWithClass(SourceWithAutomaticallyInjectedSdkField.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithAutomaticallyInjectedSdkField has min mule version 4.5.0 because of its field sourceTransactionalAction. Field sourceTransactionalAction has min mule version 4.5.0 because it is of type SourceTransactionalAction. SourceTransactionalAction was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithSdkConnectionProvider() {
        this.mockSourceWrapperWithClass(SourceWithSdkConnectionProvider.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithSdkConnectionProvider has min mule version 4.5 because of its field connectionProvider. Field connectionProvider has min mule version 4.5 because it is of type ConnectionProvider. ConnectionProvider was introduced in Mule 4.5."));
    }

    @Test
    public void getMMVForSourceWithSdkParameterField() {
        this.mockSourceWrapperWithClass(SourceWithSdkParameterField.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithSdkParameterField has min mule version 4.4 because of its field someField. Field someField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceWithSdkInvalidField() {
        this.mockSourceWrapperWithClass(SourceWithMMVField.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithMMVField has min mule version 4.5.0 because of its field someField. Field someField has min mule version 4.5.0 because it is annotated with @MinMuleVersion."));
    }

    @Test
    public void getMMVForSourceWithSdkParameterGroup() {
        this.mockSourceWrapperWithClass(SourceWithSdkParameterGroup.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithSdkParameterGroup has min mule version 4.4 because of its field sdkParameterGroup. Field sdkParameterGroup has min mule version 4.4 because it is a parameter of type SdkParameterGroup. Type SdkParameterGroup has min mule version 4.4 because of its field someField. Field someField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceWithSdkParametersContainer() {
        this.mockSourceWrapperWithClass(SourceWithSdkParametersContainer.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithSdkParametersContainer has min mule version 4.5.0 because of its field parametersContainer. Field parametersContainer has min mule version 4.5.0 because it is a parameter of type SdkParametersContainer. Type SdkParametersContainer has min mule version 4.5.0 because of its field sdkLiteralParameter. Field sdkLiteralParameter has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithNestedContainer() {
        this.mockSourceWrapperWithClass(SourceWithNestedContainer.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithNestedContainer has min mule version 4.5.0 because of its field parametersContainer. Field parametersContainer has min mule version 4.5.0 because it is a parameter of type HasNestedContainer. Type HasNestedContainer has min mule version 4.5.0 because of its field nestedContainer. Field nestedContainer has min mule version 4.5.0 because it is a parameter of type SdkParametersContainer. Type SdkParametersContainer has min mule version 4.5.0 because of its field sdkLiteralParameter. Field sdkLiteralParameter has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithOnBackPressure() {
        this.mockSourceWrapperWithClass(SourceOnBackPressure.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceOnBackPressure has min mule version 4.4 because of its method onBackPressure. Method onBackPressure has min mule version 4.4 because of its parameter ctx. Parameter ctx has min mule version 4.4 because it is of type BackPressureContext. BackPressureContext was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceWithOnSuccess() {
        this.mockSourceWrapperWithClass(SourceOnSuccess.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceOnSuccess has min mule version 4.4 because of its method onSuccess. Method onSuccess has min mule version 4.4 because of its parameter callback. Parameter callback has min mule version 4.4 because it is of type SourceCompletionCallback. SourceCompletionCallback was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceWithOnError() {
        this.mockSourceWrapperWithClass(SourceOnError.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceOnError has min mule version 4.5.0 because of its method onError. Method onError has min mule version 4.5.0 because it is annotated with OnError. OnError was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForSourceWithOnTerminate() {
        this.mockSourceWrapperWithClass(SourceOnTerminate.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceOnTerminate has min mule version 4.4 because of its method onTerminate. Method onTerminate has min mule version 4.4 because of its parameter sourceResult. Parameter sourceResult has min mule version 4.4 because it is of type SourceResult. SourceResult was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForSourceWithNonAnnotatedMethod() {
        this.mockSourceWrapperWithClass(SourceWithNonAnnotatedMethod.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithNonAnnotatedMethod has min mule version 4.5.0 because of its method someMethod. Method someMethod has min mule version 4.5.0 because of its parameter param. Parameter param has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0."));
    }

    @Test
    public void getClassLevelMMVForSourceWithMMVAnnotation() {
        this.mockSourceWrapperWithClass(SourceWithHigherMMVAnnotation.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.7"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithHigherMMVAnnotation has min mule version 4.7 because it is the one set at the class level through the @MinMuleVersion annotation."));
    }

    @Test
    public void getOverwrittenMMVForSourceWithMMVAnnotation() {
        this.mockSourceWrapperWithClass(SourceWithLowerMMVAnnotation.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Calculated Min Mule Version is 4.5.0 which is greater than the one set at the source class level 4.4. Overriding it. Source SourceWithLowerMMVAnnotation has min mule version 4.5.0 because of its field sourceTransactionalAction. Field sourceTransactionalAction has min mule version 4.5.0 because it is of type SourceTransactionalAction. SourceTransactionalAction was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForExtendsPollingSource() {
        this.mockSourceWrapperWithClass(ExtendsPollingSource.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source ExtendsPollingSource has min mule version 4.4 because of its super class PollingSource. Source PollingSource has min mule version 4.4 because it is the one set at the class level through the @MinMuleVersion annotation."));
    }

    @Test
    public void getMMVForSourceWithRecursiveField() {
        this.mockSourceWrapperWithClass(SourceWithRecursiveParameter.class);
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        Assert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Source SourceWithRecursiveParameter has min mule version 4.4 because of its field recursiveParameter. Field recursiveParameter has min mule version 4.4 because it is a parameter of type RecursiveClass. Type RecursiveClass has min mule version 4.4 because of its field recursiveField. Field recursiveField has min mule version 4.4 because it is annotated with Optional. Optional was introduced in Mule 4.4."));
    }

    private boolean parseEmitsResponseFromSourceClass(Class<? extends Source> sourceClass) {
        this.mockSourceWrapperWithClass(sourceClass);
        return this.parser.emitsResponse();
    }

    private java.util.Optional<BackPressureStrategyModelProperty> parseBackPressureStrategyFromSourceClass(Class<? extends Source> sourceClass) {
        this.mockSourceWrapperWithClass(sourceClass);
        return this.parser.getBackPressureStrategyModelProperty();
    }

    private SourceClusterSupportModelProperty parseClusterSupportFromSourceClass(Class<? extends Source> sourceClass) {
        this.mockSourceWrapperWithClass(sourceClass);
        return this.parser.getSourceClusterSupportModelProperty();
    }

    protected void mockSourceWrapperWithClass(Class sourceClass) {
        this.sourceElement = new SourceTypeWrapper(sourceClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        this.parser = new JavaSourceModelParser((ExtensionElement)Mockito.mock(ExtensionElement.class), this.sourceElement, (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class));
    }

    private static class RecursiveClass {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        String someField;
        @org.mule.runtime.extension.api.annotation.param.Parameter
        @Optional
        RecursiveClass recursiveField;

        private RecursiveClass() {
        }
    }

    private static class SourceWithRecursiveParameter
    extends TestSource {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        RecursiveClass recursiveParameter;

        private SourceWithRecursiveParameter() {
        }
    }

    private static class ExtendsPollingSource
    extends PollingSource<String, String> {
        private ExtendsPollingSource() {
        }

        protected void doStart() throws MuleException {
        }

        protected void doStop() {
        }

        public void poll(PollContext<String, String> pollContext) {
        }

        public void onRejectedItem(Result<String, String> result, SourceCallbackContext callbackContext) {
        }
    }

    private static class HasNestedContainer {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        SdkParametersContainer nestedContainer;

        private HasNestedContainer() {
        }
    }

    private static class SdkParametersContainer {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        Literal<String> sdkLiteralParameter;
        @org.mule.runtime.extension.api.annotation.param.Parameter
        String anotherField;

        private SdkParametersContainer() {
        }
    }

    private static class SdkParameterGroup {
        @Parameter
        String someField;
        @Parameter
        String anotherField;

        private SdkParameterGroup() {
        }
    }

    @MinMuleVersion(value="4.4")
    private static class SourceWithLowerMMVAnnotation
    extends TestSource {
        SourceTransactionalAction sourceTransactionalAction;

        private SourceWithLowerMMVAnnotation() {
        }
    }

    @MinMuleVersion(value="4.7")
    private static class SourceWithHigherMMVAnnotation
    extends TestSource {
        SourceTransactionalAction sourceTransactionalAction;

        private SourceWithHigherMMVAnnotation() {
        }
    }

    private static class SourceWithNonAnnotatedMethod
    extends TestSource {
        private SourceWithNonAnnotatedMethod() {
        }

        public Result<String, String> someMethod(Literal<String> param) {
            return Result.builder().output((Object)param.getLiteralValue().orElse("")).attributes((Object)"Att").build();
        }
    }

    private static class SourceOnTerminate
    extends TestSource {
        private SourceOnTerminate() {
        }

        @OnTerminate
        public void onTerminate(SourceResult sourceResult) {
        }
    }

    private static class SourceOnError
    extends TestSource {
        private SourceOnError() {
        }

        @OnError
        public void onError() {
        }
    }

    private static class SourceOnSuccess
    extends TestSource {
        private SourceOnSuccess() {
        }

        @OnSuccess
        public void onSuccess(SourceCompletionCallback callback) {
        }
    }

    private static class SourceOnBackPressure
    extends TestSource {
        private SourceOnBackPressure() {
        }

        @OnBackPressure
        public void onBackPressure(BackPressureContext ctx) {
        }
    }

    private static class SourceWithNestedContainer
    extends TestSource {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        HasNestedContainer parametersContainer;

        private SourceWithNestedContainer() {
        }
    }

    private static class SourceWithSdkParametersContainer
    extends TestSource {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        SdkParametersContainer parametersContainer;

        private SourceWithSdkParametersContainer() {
        }
    }

    private static class SourceWithSdkParameterGroup
    extends TestSource {
        @ParameterGroup(name="pg")
        SdkParameterGroup sdkParameterGroup;

        private SourceWithSdkParameterGroup() {
        }
    }

    private static class SourceWithSdkParameterField
    extends TestSource {
        @Parameter
        String someField;

        private SourceWithSdkParameterField() {
        }
    }

    private static class SourceWithSdkConnectionProvider
    extends TestSource {
        @Connection
        ConnectionProvider<String> connectionProvider;

        private SourceWithSdkConnectionProvider() {
        }
    }

    private static class SourceWithAutomaticallyInjectedSdkField
    extends TestSource {
        SourceTransactionalAction sourceTransactionalAction;

        private SourceWithAutomaticallyInjectedSdkField() {
        }
    }

    private static class SourceWithInjectedOptionalSdkField
    extends TestSource {
        @Inject
        private java.util.Optional<ForwardCompatibilityHelper> forwardCompatibilityHelper;

        private SourceWithInjectedOptionalSdkField() {
        }
    }

    private static class SourceWithInjectedSdkField
    extends TestSource {
        @Inject
        ObjectStoreManager objectStoreManager;

        private SourceWithInjectedSdkField() {
        }
    }

    private static class SourceWithMMVField
    extends TestSource {
        @MinMuleVersion(value="4.5.0")
        String someField;

        private SourceWithMMVField() {
        }
    }

    private static class SourceWithSdkField
    extends TestSource {
        Literal<String> someField;

        private SourceWithSdkField() {
        }
    }

    private static class SourceImplementsExtraReconnectable
    extends Source<String, String>
    implements ExtraReconnectable {
        private SourceImplementsExtraReconnectable() {
        }

        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }

        public void reconnect(ConnectionException exception, ReconnectionCallback reconnectionCallback) {
        }
    }

    private static interface ExtraReconnectable
    extends Reconnectable {
    }

    private static class SourceImplementsReconnectable
    extends Source<String, String>
    implements Reconnectable {
        private SourceImplementsReconnectable() {
        }

        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }

        public void reconnect(ConnectionException exception, ReconnectionCallback reconnectionCallback) {
        }
    }

    private static class SourceResultOutput
    extends Source<Result<String, String>, String> {
        private SourceResultOutput() {
        }

        public void onStart(SourceCallback<Result<String, String>, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    private static class SourceListResultOutput
    extends Source<List<Result<String, String>>, String> {
        private SourceListResultOutput() {
        }

        public void onStart(SourceCallback<List<Result<String, String>>, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    @org.mule.sdk.api.annotation.source.EmitsResponse
    public static class SdkEmitsResponseSource
    extends TestSource {
    }

    @EmitsResponse
    public static class EmitsResponseSource
    extends TestSource {
    }

    @org.mule.sdk.api.annotation.source.BackPressure(defaultMode=org.mule.sdk.api.runtime.source.BackPressureMode.DROP, supportedModes={org.mule.sdk.api.runtime.source.BackPressureMode.FAIL, org.mule.sdk.api.runtime.source.BackPressureMode.DROP})
    public static class SdkBackPressureSourceWithSelectedValues
    extends TestSource {
    }

    @BackPressure(defaultMode=BackPressureMode.DROP, supportedModes={BackPressureMode.FAIL, BackPressureMode.DROP})
    public static class BackPressureSourceWithSelectedValues
    extends TestSource {
    }

    @org.mule.sdk.api.annotation.source.BackPressure
    public static class SdkBackPressureSourceWithDefaults
    extends TestSource {
    }

    @BackPressure
    public static class BackPressureSourceWithDefaults
    extends TestSource {
    }

    @ClusterSupport(value=org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
    public static class SdkPrimaryNodeSource
    extends TestSource {
    }

    @ClusterSupport(value=org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES)
    public static class SdkAllNodesSource
    extends TestSource {
    }

    @ClusterSupport(value=org.mule.sdk.api.annotation.source.SourceClusterSupport.NOT_SUPPORTED)
    public static class SdkNonClusteredSource
    extends TestSource {
    }

    @org.mule.runtime.extension.api.annotation.source.ClusterSupport(value=SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
    public static class PrimaryNodeSource
    extends TestSource {
    }

    @org.mule.runtime.extension.api.annotation.source.ClusterSupport(value=SourceClusterSupport.DEFAULT_ALL_NODES)
    public static class AllNodesSource
    extends TestSource {
    }

    @org.mule.runtime.extension.api.annotation.source.ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
    public static class NonClusteredSource
    extends TestSource {
    }

    public static class TestSource
    extends Source<String, Object> {
        public void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

