/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.el.GlobalBindingContextProvider;
import org.mule.runtime.internal.dsl.DefaultDslResolvingContext;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.ExtensionActivator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@SmallTest
public class ExtensionActivatorTestCase
extends AbstractMuleTestCase {
    private static final String MOCK_EXTENSION_PREFIX = "mock";
    private static final String MOCK_TYPE_ALIAS = "MockType";
    private static final String MOCK_TYPE_ID = "MockTypeId";
    private static final String MOCK_EXTENSION_NAME = "Mock Extension";

    @Test
    public void enumsReleasedWhenStopped() throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("type", HeisenbergExtension.class.getName());
        attributes.put("version", "1.0.0");
        attributes.put("COMPILATION_MODE", true);
        ExtensionModel extensionModel = new DefaultJavaExtensionModelLoader().loadExtensionModel(HeisenbergExtension.class.getClassLoader(), (DslResolvingContext)new DefaultDslResolvingContext(Collections.emptySet()), attributes);
        ExtensionActivator extensionActivator = new ExtensionActivator((MuleContext)MuleContextUtils.mockMuleContext());
        extensionActivator.activateExtension(extensionModel);
        Assert.assertThat((Object)extensionActivator.getEnumTypes().size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        extensionActivator.stop();
        Assert.assertThat((Object)extensionActivator.getEnumTypes(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    @Issue(value="W-11969246")
    public void activatedExtensionTypesAreAddedToGlobalBindings() throws MuleException {
        ObjectType mockType = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA).objectType().id(MOCK_TYPE_ID).with((TypeAnnotation)new TypeAliasAnnotation(MOCK_TYPE_ALIAS)).build();
        ExtensionModel extensionModel = ExtensionActivatorTestCase.extensionWithTypes(Collections.singleton(mockType));
        MuleContextWithRegistry muleContext = MuleContextUtils.mockMuleContext();
        MuleRegistry spiedRegistry = (MuleRegistry)Mockito.spy((Object)muleContext.getRegistry());
        Mockito.when((Object)muleContext.getRegistry()).thenReturn((Object)spiedRegistry);
        ((MuleRegistry)Mockito.doNothing().when((Object)spiedRegistry)).registerObject((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        ExtensionActivator extensionActivator = new ExtensionActivator((MuleContext)muleContext);
        extensionActivator.activateExtension(extensionModel);
        ArgumentCaptor bcProviderCaptor = ArgumentCaptor.forClass(GlobalBindingContextProvider.class);
        String registryKey = "Mock ExtensionGlobalBindingContextProvider";
        ((MuleRegistry)Mockito.verify((Object)spiedRegistry)).registerObject((String)ArgumentMatchers.eq((Object)registryKey), bcProviderCaptor.capture());
        BindingContext bindingContext = ((GlobalBindingContextProvider)bcProviderCaptor.getValue()).getBindingContext();
        Assert.assertThat((Object)bindingContext.modules().size(), (Matcher)Matchers.is((Object)1));
        ExpressionModule module = (ExpressionModule)bindingContext.modules().stream().findAny().get();
        Assert.assertThat((Object)module.declaredTypes(), (Matcher)Matchers.contains((Object[])new MetadataType[]{mockType}));
    }

    private static ExtensionModel extensionWithTypes(Set<ObjectType> metadataTypes) {
        ExtensionModel mockExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class, (Answer)Mockito.RETURNS_MOCKS);
        XmlDslModel dslModel = XmlDslModel.builder().setPrefix(MOCK_EXTENSION_PREFIX).build();
        Mockito.when((Object)mockExtensionModel.getXmlDslModel()).thenReturn((Object)dslModel);
        Mockito.when((Object)mockExtensionModel.getName()).thenReturn((Object)MOCK_EXTENSION_NAME);
        Mockito.when((Object)mockExtensionModel.getTypes()).thenReturn(metadataTypes);
        Mockito.when((Object)mockExtensionModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        return mockExtensionModel;
    }
}

