/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.security;

import java.util.Optional;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.module.extension.internal.runtime.security.DefaultAuthenticationHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultAuthenticationHandlerTestCase
extends AbstractMuleTestCase {
    @Mock
    private SecurityContext securityContext;
    @Mock
    private SecurityManager manager;
    @Mock
    private Consumer<SecurityContext> securityContextUpdater;
    @Mock
    private Authentication authentication;
    private AuthenticationHandler authenticationHandler;

    @Before
    public void setUp() throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        Mockito.when((Object)this.manager.authenticate(this.authentication)).thenReturn((Object)this.authentication);
        Mockito.when((Object)this.manager.createSecurityContext(this.authentication)).thenReturn((Object)this.securityContext);
    }

    @Test
    public void setAuthentication() throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        this.authenticationHandler = new DefaultAuthenticationHandler(this.securityContext, this.manager, this.securityContextUpdater);
        this.authenticationHandler.setAuthentication(this.authentication);
        ((SecurityManager)Mockito.verify((Object)this.manager)).authenticate(this.authentication);
        ((SecurityContext)Mockito.verify((Object)this.securityContext)).setAuthentication(this.authentication);
        ((Consumer)Mockito.verify(this.securityContextUpdater)).accept(this.securityContext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.manager, this.securityContext, this.securityContextUpdater});
    }

    @Test
    public void setAuthenticationNullContext() throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        this.authenticationHandler = new DefaultAuthenticationHandler(null, this.manager, this.securityContextUpdater);
        this.authenticationHandler.setAuthentication(this.authentication);
        ((SecurityManager)Mockito.verify((Object)this.manager)).authenticate(this.authentication);
        ((SecurityManager)Mockito.verify((Object)this.manager)).createSecurityContext(this.authentication);
        ((SecurityContext)Mockito.verify((Object)this.securityContext)).setAuthentication(this.authentication);
        ((Consumer)Mockito.verify(this.securityContextUpdater)).accept(this.securityContext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.manager, this.securityContext, this.securityContextUpdater});
    }

    @Test
    public void getAuthentication() throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        this.authenticationHandler = new DefaultAuthenticationHandler(this.securityContext, this.manager, this.securityContextUpdater);
        Mockito.when((Object)this.securityContext.getAuthentication()).thenReturn((Object)this.authentication);
        Optional optional = this.authenticationHandler.getAuthentication();
        Assert.assertThat((Object)optional.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((Authentication)optional.get()), (Matcher)Matchers.is((Object)this.authentication));
    }

    @Test
    public void getAuthenticationWhenContextHasNullAuthentication() throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        this.authenticationHandler = new DefaultAuthenticationHandler(this.securityContext, this.manager, this.securityContextUpdater);
        Mockito.when((Object)this.securityContext.getAuthentication()).thenReturn(null);
        Optional optional = this.authenticationHandler.getAuthentication();
        Assert.assertThat((Object)optional.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getAuthenticationWhenNullContext() throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        this.authenticationHandler = new DefaultAuthenticationHandler(null, this.manager, this.securityContextUpdater);
        Optional optional = this.authenticationHandler.getAuthentication();
        Assert.assertThat((Object)optional.isPresent(), (Matcher)Matchers.is((Object)false));
    }
}

