/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager.jdk;

import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.internal.util.JdkVersionUtils;
import org.mule.runtime.module.extension.internal.manager.jdk.ExtensionJdkValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public abstract class BaseExtensionJdkValidatorTestCase
extends AbstractMuleTestCase {
    protected ExtensionJdkValidator validator;
    protected ExtensionModel extensionModel;
    protected JdkVersionUtils.JdkVersion jdk8 = new JdkVersionUtils.JdkVersion("1.8");
    protected JdkVersionUtils.JdkVersion jdk11 = new JdkVersionUtils.JdkVersion("11");
    protected JdkVersionUtils.JdkVersion jdk17 = new JdkVersionUtils.JdkVersion("17");
    protected JdkVersionUtils.JdkVersion jdk21 = new JdkVersionUtils.JdkVersion("21");

    protected abstract ExtensionJdkValidator validatorFor(JdkVersionUtils.JdkVersion var1);

    protected abstract void assertFailure(Runnable var1);

    @Before
    public void before() {
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"Test Extension");
        this.mockSupportsJavaVersions("1.8", "11", "17");
    }

    @Test
    public void supportedJdks() {
        this.validatorFor(this.jdk8).validateJdkSupport(this.extensionModel);
        this.validatorFor(this.jdk11).validateJdkSupport(this.extensionModel);
        this.validatorFor(this.jdk17).validateJdkSupport(this.extensionModel);
    }

    @Test
    public void unsupportedJdk() {
        this.assertFailure(() -> this.validatorFor(this.jdk21).validateJdkSupport(this.extensionModel));
    }

    protected void mockSupportsJavaVersions(String ... versions) {
        Mockito.when((Object)this.extensionModel.getSupportedJavaVersions()).thenReturn((Object)Stream.of(versions).collect(Collectors.toCollection(LinkedHashSet::new)));
    }
}

